/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf;

import com.emc.mongoose.api.common.supply.BatchSupplier;
import com.emc.mongoose.api.common.supply.RangePatternDefinedSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.junit.Assert;
import org.junit.Test;

public class RangePatternDefinedSupplierTest {
    private static final int BATCH_SIZE = 4096;
    private static final int TIME_LIMIT_SEC = 50;

    @Test
    public void testConstantStringSupplyRate() throws Exception {
        RangePatternDefinedSupplier input = new RangePatternDefinedSupplier("qazxswedc");
        LongAdder counter = new LongAdder();
        ArrayList buff = new ArrayList(4096);
        Thread t = new Thread(() -> RangePatternDefinedSupplierTest.lambda$testConstantStringSupplyRate$0((BatchSupplier)input, buff, counter));
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        t.interrupt();
        System.out.println("Constant string supply rate: " + counter.sum() / 50L);
    }

    @Test
    public void testSingleLongParamSupplyRate() throws Exception {
        RangePatternDefinedSupplier input = new RangePatternDefinedSupplier("_%d[0-1000]");
        LongAdder counter = new LongAdder();
        ArrayList buff = new ArrayList(4096);
        Thread t = new Thread(() -> RangePatternDefinedSupplierTest.lambda$testSingleLongParamSupplyRate$1((BatchSupplier)input, buff, counter));
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        t.interrupt();
        System.out.println("Single long parameter supply rate: " + counter.sum() / 50L);
    }

    @Test
    public void testSingleDoubleParamSupplyRate() throws Exception {
        RangePatternDefinedSupplier input = new RangePatternDefinedSupplier("_%f{#.##}[0-1000]");
        LongAdder counter = new LongAdder();
        ArrayList buff = new ArrayList(4096);
        Thread t = new Thread(() -> RangePatternDefinedSupplierTest.lambda$testSingleDoubleParamSupplyRate$2((BatchSupplier)input, buff, counter));
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        t.interrupt();
        System.out.println("Single double parameter supply rate: " + counter.sum() / 50L);
    }

    @Test
    public void testSingleDateParamSupplyRate() throws Exception {
        RangePatternDefinedSupplier input = new RangePatternDefinedSupplier("_%D{yyyy-MM-dd'T'HH:mm:ss.SSS}");
        LongAdder counter = new LongAdder();
        ArrayList buff = new ArrayList(4096);
        Thread t = new Thread(() -> RangePatternDefinedSupplierTest.lambda$testSingleDateParamSupplyRate$3((BatchSupplier)input, buff, counter));
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        t.interrupt();
        System.out.println("Single date parameter supply rate: " + counter.sum() / 50L);
    }

    @Test
    public void testMixedParamsSupplyRate() throws Exception {
        RangePatternDefinedSupplier input = new RangePatternDefinedSupplier("_%d[0-1000]_%f{#.##}[0-1000]_%D{yyyy-MM-dd'T'HH:mm:ss.SSS}");
        LongAdder counter = new LongAdder();
        ArrayList buff = new ArrayList(4096);
        Thread t = new Thread(() -> RangePatternDefinedSupplierTest.lambda$testMixedParamsSupplyRate$4((BatchSupplier)input, buff, counter));
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        t.interrupt();
        System.out.println("Mixed parameters supply rate: " + counter.sum() / 50L);
    }

    @Test
    public void test10LongParamsSupplyRate() throws Exception {
        RangePatternDefinedSupplier input = new RangePatternDefinedSupplier("_%d[0-10]_%d[10-100]_%d[10-1000]_%d[1000-10000]_%d[10000-100000]_%d[100000-1000000]_%d[1000000-10000000]_%d[10000000-100000000]_%d[100000000-1000000000]_%d[1000000000-2000000000]");
        LongAdder counter = new LongAdder();
        ArrayList buff = new ArrayList(4096);
        Thread t = new Thread(() -> RangePatternDefinedSupplierTest.lambda$test10LongParamsSupplyRate$5((BatchSupplier)input, buff, counter));
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        t.interrupt();
        System.out.println("10 long parameters supply rate: " + counter.sum() / 50L);
    }

    @Test
    public void test10DoubleParamsSupplyRate() throws Exception {
        RangePatternDefinedSupplier input = new RangePatternDefinedSupplier("_%f{#.###}[0-10]_%f{#.###}[10-100]_%f{#.###}[10-1000]_%f{#.###}[1000-10000]_%f{#.###}[10000-100000]_%f{#.###}[100000-1000000]_%f{#.###}[1000000-10000000]_%f{#.###}[10000000-100000000]_%f{#.###}[100000000-1000000000]_%f{#.###}[1000000000-2000000000]");
        LongAdder counter = new LongAdder();
        ArrayList buff = new ArrayList(4096);
        Thread t = new Thread(() -> RangePatternDefinedSupplierTest.lambda$test10DoubleParamsSupplyRate$6((BatchSupplier)input, buff, counter));
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        t.interrupt();
        System.out.println("10 double parameters supply rate: " + counter.sum() / 50L);
    }

    @Test
    public void test10DateParamsSupplyRate() throws Exception {
        RangePatternDefinedSupplier input = new RangePatternDefinedSupplier("_%D{yyyy-MM-dd'T'HH:mm:ss.SSS}_%D{yyyy-MM-dd'T'HH:mm:ss.SSS}_%D{yyyy-'W'ww}_%D{yyMMddHHmmssZ}_%D{EEE, d MMM yyyy HH:mm:ss Z}_%D{yyyyy.MMMMM.dd GGG hh:mm aaa}_%D{K:mm a, z}_%D{h:mm a}_%D{EEE, MMM d, ''yy}_%D{yyyy.MM.dd G 'at' HH:mm:ss z}");
        LongAdder counter = new LongAdder();
        ArrayList buff = new ArrayList(4096);
        Thread t = new Thread(() -> RangePatternDefinedSupplierTest.lambda$test10DateParamsSupplyRate$7((BatchSupplier)input, buff, counter));
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        t.interrupt();
        System.out.println("10 date parameters supply rate: " + counter.sum() / 50L);
    }

    private static /* synthetic */ void lambda$test10DateParamsSupplyRate$7(BatchSupplier input, List buff, LongAdder counter) {
        while (true) {
            Assert.assertEquals((long)4096L, (long)input.get(buff, 4096));
            counter.add(4096L);
            buff.clear();
        }
    }

    private static /* synthetic */ void lambda$test10DoubleParamsSupplyRate$6(BatchSupplier input, List buff, LongAdder counter) {
        while (true) {
            Assert.assertEquals((long)4096L, (long)input.get(buff, 4096));
            counter.add(4096L);
            buff.clear();
        }
    }

    private static /* synthetic */ void lambda$test10LongParamsSupplyRate$5(BatchSupplier input, List buff, LongAdder counter) {
        while (true) {
            Assert.assertEquals((long)4096L, (long)input.get(buff, 4096));
            counter.add(4096L);
            buff.clear();
        }
    }

    private static /* synthetic */ void lambda$testMixedParamsSupplyRate$4(BatchSupplier input, List buff, LongAdder counter) {
        while (true) {
            Assert.assertEquals((long)4096L, (long)input.get(buff, 4096));
            counter.add(4096L);
            buff.clear();
        }
    }

    private static /* synthetic */ void lambda$testSingleDateParamSupplyRate$3(BatchSupplier input, List buff, LongAdder counter) {
        while (true) {
            Assert.assertEquals((long)4096L, (long)input.get(buff, 4096));
            counter.add(4096L);
            buff.clear();
        }
    }

    private static /* synthetic */ void lambda$testSingleDoubleParamSupplyRate$2(BatchSupplier input, List buff, LongAdder counter) {
        while (true) {
            Assert.assertEquals((long)4096L, (long)input.get(buff, 4096));
            counter.add(4096L);
            buff.clear();
        }
    }

    private static /* synthetic */ void lambda$testSingleLongParamSupplyRate$1(BatchSupplier input, List buff, LongAdder counter) {
        while (true) {
            Assert.assertEquals((long)4096L, (long)input.get(buff, 4096));
            counter.add(4096L);
            buff.clear();
        }
    }

    private static /* synthetic */ void lambda$testConstantStringSupplyRate$0(BatchSupplier input, List buff, LongAdder counter) {
        while (true) {
            Assert.assertEquals((long)4096L, (long)input.get(buff, 4096));
            counter.add(4096L);
            buff.clear();
        }
    }
}

