/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf;

import com.emc.mongoose.api.common.concurrent.WeightThrottle;
import com.emc.mongoose.api.model.io.IoType;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Test;

public class WeightThrottleTest {
    private final Int2IntMap weightMap = new Int2IntOpenHashMap(){
        {
            this.put(IoType.CREATE.ordinal(), 80);
            this.put(IoType.READ.ordinal(), 20);
        }
    };
    private final Int2ObjectMap<LongAdder> resultsMap = new Int2ObjectOpenHashMap<LongAdder>(){
        {
            this.put(IoType.CREATE.ordinal(), new LongAdder());
            this.put(IoType.READ.ordinal(), new LongAdder());
        }
    };
    private final WeightThrottle wt = new WeightThrottle(this.weightMap);

    @Test
    public void testRequestApprovalFor() throws Exception {
        ExecutorService es = Executors.newFixedThreadPool(2);
        es.submit(new SubmTask(IoType.CREATE));
        es.submit(new SubmTask(IoType.READ));
        es.awaitTermination(10L, TimeUnit.SECONDS);
        es.shutdownNow();
        double writes = ((LongAdder)this.resultsMap.get(IoType.CREATE.ordinal())).sum();
        long reads = ((LongAdder)this.resultsMap.get(IoType.READ.ordinal())).sum();
        Assert.assertEquals((double)4.0, (double)(writes / (double)reads), (double)0.01);
        System.out.println("Write rate: " + writes / 10.0 + " Hz, read rate: " + reads / 10L + " Hz");
    }

    @Test
    public void testRequestBatchApprovalFor() throws Exception {
        ExecutorService es = Executors.newFixedThreadPool(2);
        es.submit(new BatchSubmTask(IoType.CREATE));
        es.submit(new BatchSubmTask(IoType.READ));
        es.awaitTermination(10L, TimeUnit.SECONDS);
        es.shutdownNow();
        double writes = ((LongAdder)this.resultsMap.get(IoType.CREATE.ordinal())).sum();
        long reads = ((LongAdder)this.resultsMap.get(IoType.READ.ordinal())).sum();
        Assert.assertEquals((double)4.0, (double)(writes / (double)reads), (double)0.01);
        System.out.println("Write rate: " + writes / 10.0 + " Hz, read rate: " + reads / 10L + " Hz");
    }

    private final class BatchSubmTask
    implements Runnable {
        private final IoType ioType;

        public BatchSubmTask(IoType ioType) {
            this.ioType = ioType;
        }

        @Override
        public final void run() {
            while (true) {
                int n;
                if ((n = WeightThrottleTest.this.wt.tryAcquire(this.ioType.ordinal(), 128)) > 0) {
                    ((LongAdder)WeightThrottleTest.this.resultsMap.get(this.ioType.ordinal())).add(n);
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
        }
    }

    private final class SubmTask
    implements Runnable {
        private final IoType ioType;

        public SubmTask(IoType ioType) {
            this.ioType = ioType;
        }

        @Override
        public final void run() {
            while (true) {
                if (WeightThrottleTest.this.wt.tryAcquire(this.ioType.ordinal())) {
                    ((LongAdder)WeightThrottleTest.this.resultsMap.get(this.ioType.ordinal())).increment();
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
        }
    }
}

