/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf.util.mock;

import com.emc.mongoose.api.common.exception.UserShootHisFootException;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.data.DataIoTask;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.storage.Credential;
import com.emc.mongoose.storage.driver.base.StorageDriverBase;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;

public final class BasicStorageDriverMock<I extends Item, O extends IoTask<I>>
extends StorageDriverBase<I, O> {
    public BasicStorageDriverMock(String stepName, DataInput contentSrc, LoadConfig loadConfig, StorageConfig storageConfig, boolean verifyFlag) throws UserShootHisFootException {
        super(stepName, contentSrc, loadConfig, storageConfig, verifyFlag);
    }

    public final List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return Collections.emptyList();
    }

    public final void adjustIoBuffers(long avgTransferSize, IoType ioType) throws RemoteException {
    }

    protected final String requestNewPath(String path) {
        return path;
    }

    protected final String requestNewAuthToken(Credential credential) {
        return credential == null ? "" : credential.toString();
    }

    protected final boolean submit(O ioTask) throws IllegalStateException {
        ioTask.reset();
        ioTask.startRequest();
        ioTask.finishRequest();
        ioTask.startResponse();
        if (ioTask instanceof DataIoTask) {
            DataIoTask dataIoTask = (DataIoTask)ioTask;
            DataItem dataItem = dataIoTask.getItem();
            switch (dataIoTask.getIoType()) {
                case CREATE: {
                    try {
                        dataIoTask.setCountBytesDone(dataItem.size());
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case READ: {
                    dataIoTask.startDataResponse();
                }
                case UPDATE: {
                    List fixedRanges = dataIoTask.getFixedRanges();
                    if (fixedRanges == null || fixedRanges.isEmpty()) {
                        if (dataIoTask.hasMarkedRanges()) {
                            dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                            break;
                        }
                        try {
                            dataIoTask.setCountBytesDone(dataItem.size());
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                    break;
                }
            }
            dataIoTask.startDataResponse();
        }
        ioTask.finishResponse();
        ioTask.setStatus(IoTask.Status.SUCC);
        this.ioTaskCompleted((IoTask)ioTask);
        return true;
    }

    protected final int submit(List<O> ioTasks, int from, int to) throws IllegalStateException {
        for (int i = from; i < to; ++i) {
            IoTask ioTask = (IoTask)ioTasks.get(i);
            ioTask.reset();
            ioTask.startRequest();
            ioTask.finishRequest();
            ioTask.startResponse();
            if (ioTask instanceof DataIoTask) {
                DataIoTask dataIoTask = (DataIoTask)ioTask;
                DataItem dataItem = dataIoTask.getItem();
                switch (dataIoTask.getIoType()) {
                    case CREATE: {
                        try {
                            dataIoTask.setCountBytesDone(dataItem.size());
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    case READ: {
                        dataIoTask.startDataResponse();
                    }
                    case UPDATE: {
                        List fixedRanges = dataIoTask.getFixedRanges();
                        if (fixedRanges == null || fixedRanges.isEmpty()) {
                            if (dataIoTask.hasMarkedRanges()) {
                                dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                                break;
                            }
                            try {
                                dataIoTask.setCountBytesDone(dataItem.size());
                            }
                            catch (IOException iOException) {}
                            break;
                        }
                        dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                        break;
                    }
                }
                dataIoTask.startDataResponse();
            }
            ioTask.finishResponse();
            ioTask.setStatus(IoTask.Status.SUCC);
            this.ioTaskCompleted(ioTask);
        }
        return to - from;
    }

    protected final int submit(List<O> ioTasks) throws IllegalStateException {
        return this.submit(ioTasks, 0, ioTasks.size());
    }

    protected void doInterrupt() throws IllegalStateException {
    }

    public final String toString() {
        return String.format(super.toString(), "mock-basic");
    }
}

