/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf.util.mock;

import com.emc.mongoose.api.model.concurrent.DaemonBase;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.data.DataIoTask;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.storage.StorageDriver;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.log.Loggers;
import com.github.akurilov.commons.io.Input;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public final class DummyStorageDriverMock<I extends Item, O extends IoTask<I>>
extends DaemonBase
implements StorageDriver<I, O> {
    private final int batchSize;
    private final int outputQueueCapacity;
    private final int concurrencyLevel;
    private final BlockingQueue<O> ioResultsQueue;
    private final LongAdder scheduledTaskCount = new LongAdder();
    private final LongAdder completedTaskCount = new LongAdder();

    public DummyStorageDriverMock(String stepName, DataInput contentSrc, LoadConfig loadConfig, StorageConfig storageConfig, boolean verifyFlag) {
        this.batchSize = loadConfig.getBatchConfig().getSize();
        this.outputQueueCapacity = storageConfig.getDriverConfig().getQueueConfig().getOutput();
        this.concurrencyLevel = loadConfig.getLimitConfig().getConcurrency();
        this.ioResultsQueue = new ArrayBlockingQueue<O>(this.outputQueueCapacity);
    }

    public final boolean put(O task) throws IOException {
        if (!this.isStarted()) {
            throw new EOFException();
        }
        this.checkStateFor(task);
        if (this.ioResultsQueue.offer(task)) {
            this.scheduledTaskCount.increment();
            this.completedTaskCount.increment();
            return true;
        }
        return false;
    }

    public final int put(List<O> tasks, int from, int to) throws IOException {
        int i;
        if (!this.isStarted()) {
            throw new EOFException();
        }
        for (i = from; i < to && this.isStarted(); ++i) {
            IoTask nextTask = (IoTask)tasks.get(i);
            this.checkStateFor(nextTask);
            if (!this.ioResultsQueue.offer(tasks.get(i))) break;
        }
        int n = i - from;
        this.scheduledTaskCount.add(n);
        this.completedTaskCount.add(n);
        return n;
    }

    public final int put(List<O> tasks) throws IOException {
        if (!this.isStarted()) {
            throw new EOFException();
        }
        int n = 0;
        for (IoTask nextIoTask : tasks) {
            if (!this.isStarted()) break;
            this.checkStateFor(nextIoTask);
            if (!this.ioResultsQueue.offer(nextIoTask)) break;
            ++n;
        }
        this.scheduledTaskCount.add(n);
        this.completedTaskCount.add(n);
        return n;
    }

    private void checkStateFor(O ioTask) throws IOException {
        ioTask.reset();
        ioTask.startRequest();
        ioTask.finishRequest();
        ioTask.startResponse();
        if (ioTask instanceof DataIoTask) {
            DataIoTask dataIoTask = (DataIoTask)ioTask;
            DataItem dataItem = dataIoTask.getItem();
            switch (dataIoTask.getIoType()) {
                case CREATE: {
                    dataIoTask.setCountBytesDone(dataItem.size());
                    break;
                }
                case READ: {
                    dataIoTask.startDataResponse();
                }
                case UPDATE: {
                    List fixedRanges = dataIoTask.getFixedRanges();
                    if (fixedRanges == null || fixedRanges.isEmpty()) {
                        if (dataIoTask.hasMarkedRanges()) {
                            dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                            break;
                        }
                        dataIoTask.setCountBytesDone(dataItem.size());
                        break;
                    }
                    dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                    break;
                }
            }
            dataIoTask.startDataResponse();
        }
        ioTask.finishResponse();
        ioTask.setStatus(IoTask.Status.SUCC);
    }

    public final Input<O> getInput() throws IOException {
        return this;
    }

    public final O get() throws EOFException, IOException {
        return (O)((IoTask)this.ioResultsQueue.poll());
    }

    public final List<O> getAll() {
        int n = this.ioResultsQueue.size();
        ArrayList ioTaskResults = new ArrayList(n);
        this.ioResultsQueue.drainTo(ioTaskResults, n);
        return ioTaskResults;
    }

    public final long skip(long count) throws IOException {
        int n = (int)Math.min(count, Integer.MAX_VALUE);
        ArrayList tmpBuff = new ArrayList(n);
        n = this.ioResultsQueue.drainTo(tmpBuff, n);
        tmpBuff.clear();
        return n;
    }

    public final List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return Collections.emptyList();
    }

    public final int getConcurrencyLevel() throws RemoteException {
        return this.concurrencyLevel;
    }

    public final int getActiveTaskCount() throws RemoteException {
        return (int)(this.getScheduledTaskCount() - this.getCompletedTaskCount());
    }

    public final long getScheduledTaskCount() throws RemoteException {
        return this.scheduledTaskCount.sum();
    }

    public final long getCompletedTaskCount() throws RemoteException {
        return this.completedTaskCount.sum();
    }

    public final boolean isIdle() throws RemoteException {
        return this.ioResultsQueue.isEmpty();
    }

    public final void adjustIoBuffers(long avgTransferSize, IoType ioType) throws RemoteException {
    }

    protected void doStart() throws IllegalStateException {
        Loggers.MSG.debug("{}: started", (Object)this.toString());
    }

    protected final void doShutdown() throws IllegalStateException {
        Loggers.MSG.debug("{}: shut down", (Object)this.toString());
    }

    public final boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException, RemoteException {
        return true;
    }

    protected final void doInterrupt() throws IllegalStateException {
        Loggers.MSG.debug("{}: interrupted", (Object)this.toString());
    }

    protected final void doClose() throws IOException {
        this.ioResultsQueue.clear();
        Loggers.MSG.debug("{}: closed", (Object)this.toString());
    }

    public final String toString() {
        return String.format(super.toString(), "mock-dummy");
    }
}

