/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf;

import com.emc.mongoose.api.common.supply.BatchSupplier;
import com.emc.mongoose.api.common.supply.ConstantStringSupplier;
import com.emc.mongoose.api.common.supply.RangePatternDefinedSupplier;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.BasicIoTaskBuilder;
import com.emc.mongoose.api.model.io.task.IoTaskBuilder;
import com.emc.mongoose.api.model.io.task.data.BasicDataIoTaskBuilder;
import com.emc.mongoose.api.model.item.BasicDataItem;
import com.emc.mongoose.api.model.item.BasicDataItemFactory;
import com.emc.mongoose.api.model.item.IdStringInput;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.item.ItemNameSupplier;
import com.emc.mongoose.api.model.item.ItemNamingType;
import com.emc.mongoose.api.model.item.NewDataItemInput;
import com.emc.mongoose.load.generator.BasicLoadGenerator;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.io.collection.CircularListInput;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.junit.Test;

public class BasicLoadGeneratorTest {
    private static final int BATCH_SIZE = 4096;
    private static final int TIME_LIMIT = 30;

    @Test
    public final void testNewDataItems() throws Exception {
        final LongAdder counter = new LongAdder();
        SizeInBytes itemSize = new SizeInBytes(0L);
        BasicDataItemFactory itemFactory = new BasicDataItemFactory();
        ItemNameSupplier itemNameInput = new ItemNameSupplier(ItemNamingType.RANDOM, null, 13, 36, 0L);
        NewDataItemInput itemInput = new NewDataItemInput((ItemFactory)itemFactory, (IdStringInput)itemNameInput, itemSize);
        BasicIoTaskBuilder ioTaskBuilder = new BasicDataIoTaskBuilder().setIoType(IoType.CREATE).setOutputPathSupplier((BatchSupplier)new ConstantStringSupplier("/default")).setUidSupplier(null).setSecretSupplier(null);
        boolean shuffleFlag = false;
        try (BasicLoadGenerator loadGenerator = new BasicLoadGenerator((Input)itemInput, 4096, 0L, (IoTaskBuilder)ioTaskBuilder, Long.MAX_VALUE, new SizeInBytes(0L), 0, false);){
            loadGenerator.setOutputs((List)new ArrayList<Output>(){
                {
                    this.add(new CountingOutput(counter));
                }
            });
            loadGenerator.start();
            TimeUnit.SECONDS.sleep(30L);
            System.out.println(loadGenerator.toString() + " rate: " + counter.sum() / 30L);
        }
    }

    @Test
    public final void testNewDataItemsWithAscNames() throws Exception {
        final LongAdder counter = new LongAdder();
        SizeInBytes itemSize = new SizeInBytes(0L);
        BasicDataItemFactory itemFactory = new BasicDataItemFactory();
        ItemNameSupplier itemNameInput = new ItemNameSupplier(ItemNamingType.ASC, null, 10, 10, 0L);
        NewDataItemInput itemInput = new NewDataItemInput((ItemFactory)itemFactory, (IdStringInput)itemNameInput, itemSize);
        BasicIoTaskBuilder ioTaskBuilder = new BasicDataIoTaskBuilder().setIoType(IoType.CREATE).setOutputPathSupplier((BatchSupplier)new ConstantStringSupplier("/default")).setUidSupplier(null).setSecretSupplier(null);
        boolean shuffleFlag = false;
        try (BasicLoadGenerator loadGenerator = new BasicLoadGenerator((Input)itemInput, 4096, 0L, (IoTaskBuilder)ioTaskBuilder, Long.MAX_VALUE, new SizeInBytes(0L), 0, false);){
            loadGenerator.setOutputs((List)new ArrayList<Output>(){
                {
                    this.add(new CountingOutput(counter));
                }
            });
            loadGenerator.start();
            TimeUnit.SECONDS.sleep(30L);
            System.out.println(loadGenerator.toString() + " (w/ asc names) rate: " + counter.sum() / 30L);
        }
    }

    @Test
    public final void testNewDataItemsWithCredentials() throws Exception {
        final LongAdder counter = new LongAdder();
        SizeInBytes itemSize = new SizeInBytes(0L);
        BasicDataItemFactory itemFactory = new BasicDataItemFactory();
        ItemNameSupplier itemNameInput = new ItemNameSupplier(ItemNamingType.RANDOM, null, 13, 36, 0L);
        NewDataItemInput itemInput = new NewDataItemInput((ItemFactory)itemFactory, (IdStringInput)itemNameInput, itemSize);
        BasicIoTaskBuilder ioTaskBuilder = new BasicDataIoTaskBuilder().setIoType(IoType.CREATE).setOutputPathSupplier((BatchSupplier)new ConstantStringSupplier("/default")).setUidSupplier((BatchSupplier)new ConstantStringSupplier("wuser1@sanity.local")).setSecretSupplier((BatchSupplier)new ConstantStringSupplier("secret"));
        boolean shuffleFlag = false;
        try (BasicLoadGenerator loadGenerator = new BasicLoadGenerator((Input)itemInput, 4096, 0L, (IoTaskBuilder)ioTaskBuilder, Long.MAX_VALUE, new SizeInBytes(0L), 0, false);){
            loadGenerator.setOutputs((List)new ArrayList<Output>(){
                {
                    this.add(new CountingOutput(counter));
                }
            });
            loadGenerator.start();
            TimeUnit.SECONDS.sleep(30L);
            System.out.println(loadGenerator.toString() + "(w/ constant credentials) rate: " + counter.sum() / 30L);
        }
    }

    @Test
    public final void testNewDataItemsWithDynamicPath() throws Exception {
        final LongAdder counter = new LongAdder();
        SizeInBytes itemSize = new SizeInBytes(0L);
        BasicDataItemFactory itemFactory = new BasicDataItemFactory();
        ItemNameSupplier itemNameInput = new ItemNameSupplier(ItemNamingType.RANDOM, null, 13, 36, 0L);
        NewDataItemInput itemInput = new NewDataItemInput((ItemFactory)itemFactory, (IdStringInput)itemNameInput, itemSize);
        BasicIoTaskBuilder ioTaskBuilder = new BasicDataIoTaskBuilder().setIoType(IoType.CREATE).setOutputPathSupplier((BatchSupplier)new RangePatternDefinedSupplier("$p{16;2}")).setUidSupplier(null).setSecretSupplier(null);
        boolean shuffleFlag = false;
        try (BasicLoadGenerator loadGenerator = new BasicLoadGenerator((Input)itemInput, 4096, 0L, (IoTaskBuilder)ioTaskBuilder, Long.MAX_VALUE, new SizeInBytes(0L), 0, false);){
            loadGenerator.setOutputs((List)new ArrayList<Output>(){
                {
                    this.add(new CountingOutput(counter));
                }
            });
            loadGenerator.start();
            TimeUnit.SECONDS.sleep(30L);
            System.out.println(loadGenerator.toString() + " (w/ dynamic path) rate: " + counter.sum() / 30L);
        }
    }

    @Test
    public final void testDataItemsBuffer() throws Exception {
        final LongAdder counter = new LongAdder();
        ArrayList<BasicDataItem> items = new ArrayList<BasicDataItem>(4096);
        for (int i = 0; i < 4096; ++i) {
            BasicDataItem item = new BasicDataItem();
            item.setName(Long.toString(System.nanoTime(), 36));
            items.add(item);
        }
        CircularListInput itemInput = new CircularListInput(items);
        BasicIoTaskBuilder ioTaskBuilder = new BasicDataIoTaskBuilder().setIoType(IoType.READ).setOutputPathSupplier(null).setUidSupplier(null).setSecretSupplier(null);
        boolean shuffleFlag = false;
        try (BasicLoadGenerator loadGenerator = new BasicLoadGenerator((Input)itemInput, 4096, 0L, (IoTaskBuilder)ioTaskBuilder, Long.MAX_VALUE, new SizeInBytes(0L), 0, false);){
            loadGenerator.setOutputs((List)new ArrayList<Output>(){
                {
                    this.add(new CountingOutput(counter));
                }
            });
            loadGenerator.start();
            TimeUnit.SECONDS.sleep(30L);
            System.out.println(loadGenerator.toString() + " rate: " + counter.sum() / 30L);
        }
    }

    @Test
    public final void testDataItemsBufferWithShuffle() throws Exception {
        final LongAdder counter = new LongAdder();
        ArrayList<BasicDataItem> items = new ArrayList<BasicDataItem>(4096);
        for (int i = 0; i < 4096; ++i) {
            BasicDataItem item = new BasicDataItem();
            item.setName(Long.toString(System.nanoTime(), 36));
            items.add(item);
        }
        CircularListInput itemInput = new CircularListInput(items);
        BasicIoTaskBuilder ioTaskBuilder = new BasicDataIoTaskBuilder().setIoType(IoType.READ).setOutputPathSupplier(null).setUidSupplier(null).setSecretSupplier(null);
        boolean shuffleFlag = true;
        try (BasicLoadGenerator loadGenerator = new BasicLoadGenerator((Input)itemInput, 4096, 0L, (IoTaskBuilder)ioTaskBuilder, Long.MAX_VALUE, new SizeInBytes(0L), 0, true);){
            loadGenerator.setOutputs((List)new ArrayList<Output>(){
                {
                    this.add(new CountingOutput(counter));
                }
            });
            loadGenerator.start();
            TimeUnit.SECONDS.sleep(30L);
            System.out.println(loadGenerator.toString() + " (w/ shuffling) rate: " + counter.sum() / 30L);
        }
    }

    private static final class CountingOutput<T>
    implements Output<T> {
        private final LongAdder counter;

        public CountingOutput(LongAdder counter) {
            this.counter = counter;
        }

        public boolean put(T item) throws IOException {
            this.counter.increment();
            return true;
        }

        public int put(List<T> buffer, int from, int to) throws IOException {
            this.counter.add(to - from);
            return to - from;
        }

        public int put(List<T> buffer) throws IOException {
            this.counter.add(buffer.size());
            return buffer.size();
        }

        public Input<T> getInput() throws IOException {
            return null;
        }

        public void close() throws IOException {
        }
    }
}

