/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf;

import com.emc.mongoose.api.common.supply.BatchSupplier;
import com.emc.mongoose.api.common.supply.ConstantStringSupplier;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTaskBuilder;
import com.emc.mongoose.api.model.io.task.data.BasicDataIoTaskBuilder;
import com.emc.mongoose.api.model.io.task.data.DataIoTask;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.item.DelayedTransferConvertBuffer;
import com.emc.mongoose.api.model.item.IdStringInput;
import com.emc.mongoose.api.model.item.ItemNameSupplier;
import com.emc.mongoose.api.model.item.ItemNamingType;
import com.emc.mongoose.api.model.item.ItemType;
import com.emc.mongoose.api.model.item.NewDataItemInput;
import com.emc.mongoose.api.model.item.TransferConvertBuffer;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DelayedTransferBufferTest {
    private static final int BATCH_SIZE = 4096;
    private static final int BUFF_CAPACITY = 1000000;
    private static Input<DataItem> ITEM_INPUT;
    private static IoTaskBuilder<DataItem, DataIoTask<DataItem>> IO_TASK_BUILDER;
    private static TransferConvertBuffer<DataItem, DataIoTask<DataItem>> BUFF;
    private static final int TIMEOUT = 100;

    @BeforeClass
    public static void setUpClass() throws Exception {
        ITEM_INPUT = new NewDataItemInput(ItemType.getItemFactory((ItemType)ItemType.DATA), (IdStringInput)new ItemNameSupplier(ItemNamingType.ASC, null, 13, 36, 0L), new SizeInBytes(0L));
        IO_TASK_BUILDER = new BasicDataIoTaskBuilder();
        IO_TASK_BUILDER.setIoType(IoType.NOOP);
        IO_TASK_BUILDER.setOutputPathSupplier((BatchSupplier)new ConstantStringSupplier("/default"));
        IO_TASK_BUILDER.setUidSupplier((BatchSupplier)new ConstantStringSupplier("uid1"));
        IO_TASK_BUILDER.setSecretSupplier((BatchSupplier)new ConstantStringSupplier("secret1"));
        BUFF = new DelayedTransferConvertBuffer(1000000, TimeUnit.SECONDS, 0L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        IO_TASK_BUILDER.close();
        BUFF.close();
    }

    @Test
    public final void testIoRate() throws Exception {
        LongAdder OP_COUNTER = new LongAdder();
        Thread producerThread = new Thread(() -> {
            ArrayList dataItemsBuff = new ArrayList(4096);
            ArrayList ioTaskBuff = new ArrayList(4096);
            try {
                while (true) {
                    if (4096 != ITEM_INPUT.get(dataItemsBuff, 4096)) {
                        Assert.fail();
                    }
                    IO_TASK_BUILDER.getInstances(dataItemsBuff, ioTaskBuff);
                    for (int n = 0; n < 4096; n += BUFF.put(ioTaskBuff, n, 4096)) {
                    }
                    dataItemsBuff.clear();
                    ioTaskBuff.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return;
            }
        });
        Thread consumerThread = new Thread(() -> {
            ArrayList dataItemsBuff = new ArrayList(4096);
            try {
                int n;
                while ((n = BUFF.get(dataItemsBuff, 4096)) >= 0) {
                    OP_COUNTER.add(n);
                    dataItemsBuff.clear();
                }
            }
            catch (EOFException eOFException) {
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        });
        producerThread.start();
        consumerThread.start();
        TimeUnit.SECONDS.sleep(100L);
        producerThread.interrupt();
        consumerThread.interrupt();
        System.out.println("I/O rate: " + OP_COUNTER.sum() / 100L);
    }
}

