/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ChainLoadStepTest
extends EnvConfiguredScenarioTestBase {
    private static final long COUNT_LIMIT = 100000L;
    private static String ITEM_OUTPUT_PATH;
    private static String STD_OUTPUT;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1, 1000));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("1MB"), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = ChainLoadStepTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "ChainStep.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--test-step-limit-count=100000");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        switch (STORAGE_DRIVER_TYPE) {
            case "fs": {
                ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
                CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
                break;
            }
            case "swift": {
                CONFIG.getStorageConfig().getNetConfig().getHttpConfig().setNamespace("ns1");
            }
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        SCENARIO.run();
        TimeUnit.SECONDS.sleep(10L);
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && "fs".equals(STORAGE_DRIVER_TYPE)) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public final void testStdOutput() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ChainLoadStepTest.testMetricsTableStdout(STD_OUTPUT, STEP_ID, STORAGE_DRIVERS_COUNT, 100000L, (Map<IoType, Integer>)new HashMap<IoType, Integer>(){
            {
                this.put(IoType.CREATE, CONCURRENCY);
                this.put(IoType.READ, CONCURRENCY);
                this.put(IoType.UPDATE, CONCURRENCY);
                this.put(IoType.DELETE, CONCURRENCY);
                this.put(IoType.NOOP, CONCURRENCY);
            }
        });
    }

    @Test
    public final void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalRecs = ChainLoadStepTest.getMetricsTotalLogRecords();
        ChainLoadStepTest.testTotalMetricsLogRecord(totalRecs.get(0), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 100000L, 0);
        ChainLoadStepTest.testTotalMetricsLogRecord(totalRecs.get(1), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 100000L, 0);
        ChainLoadStepTest.testTotalMetricsLogRecord(totalRecs.get(2), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(1L, ITEM_DATA_SIZE.get(), 1.0), 100000L, 0);
        ChainLoadStepTest.testTotalMetricsLogRecord(totalRecs.get(3), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
        ChainLoadStepTest.testTotalMetricsLogRecord(totalRecs.get(4), IoType.DELETE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(0L), 0L, 0);
        ChainLoadStepTest.testTotalMetricsLogRecord(totalRecs.get(5), IoType.NOOP, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(0L), 0L, 0);
    }
}

