/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.common.net.NetUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.EnvUtil;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ChainWithDelayTest
extends EnvConfiguredScenarioTestBase {
    private static final Path SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "ChainWithDelay.json");
    private static final int DELAY_SECONDS = 60;
    private static final int TIME_LIMIT = 180;
    private static final String ZONE1_ADDR = "127.0.0.1";
    private static String ZONE2_ADDR;
    private static boolean FINISHED_IN_TIME;
    private static String STD_OUTPUT;

    @BeforeClass
    public static void setUpClass() throws Exception {
        try {
            ZONE2_ADDR = NetUtil.getHostAddrString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("fs"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1000));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes("10GB")));
        STEP_ID = ChainWithDelayTest.class.getSimpleName();
        EnvUtil.set("ZONE1_ADDRS", ZONE1_ADDR);
        EnvUtil.set("ZONE2_ADDRS", ZONE2_ADDR);
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--storage-net-http-namespace=ns1");
        CONFIG_ARGS.add("--test-step-limit-time=180");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        Thread runner = new Thread(() -> {
            try {
                SCENARIO.run();
            }
            catch (Throwable t) {
                LogUtil.exception((Level)Level.ERROR, (Throwable)t, (String)"Failed to run the scenario", (Object[])new Object[0]);
            }
            finally {
                try {
                    SCENARIO.close();
                }
                catch (Throwable tt) {
                    LogUtil.exception((Level)Level.ERROR, (Throwable)tt, (String)"Failed to close the scenario", (Object[])new Object[0]);
                }
            }
        });
        STD_OUT_STREAM.startRecording();
        runner.start();
        TimeUnit.SECONDS.timedJoin(runner, 185L);
        FINISHED_IN_TIME = !runner.isAlive();
        runner.interrupt();
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        TimeUnit.SECONDS.sleep(10L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testFinishedInTime() {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        Assert.assertTrue((String)"Scenario didn't finished in time", (boolean)FINISHED_IN_TIME);
    }

    @Test
    public final void testStdOutput() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ChainWithDelayTest.testMetricsTableStdout(STD_OUTPUT, STEP_ID, STORAGE_DRIVERS_COUNT, 0L, (Map<IoType, Integer>)new HashMap<IoType, Integer>(){
            {
                this.put(IoType.CREATE, CONCURRENCY);
                this.put(IoType.READ, CONCURRENCY);
            }
        });
    }

    @Test
    public void testIoTraceFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        HashMap<String, Long> timingMap = new HashMap<String, Long>();
        List<CSVRecord> ioTraceRecords = ChainWithDelayTest.getIoTraceLogRecords();
        block4: for (CSVRecord ioTraceRec : ioTraceRecords) {
            String storageNode = ioTraceRec.get("StorageNode");
            String itemPath = ioTraceRec.get("ItemPath");
            IoType ioType = IoType.values()[Integer.parseInt(ioTraceRec.get("IoTypeCode"))];
            long reqTimeStart = Long.parseLong(ioTraceRec.get("ReqTimeStart[us]"));
            long duration = Long.parseLong(ioTraceRec.get("Duration[us]"));
            switch (ioType) {
                case CREATE: {
                    Assert.assertTrue((boolean)storageNode.startsWith(ZONE1_ADDR));
                    timingMap.put(itemPath, reqTimeStart + duration);
                    continue block4;
                }
                case READ: {
                    Assert.assertTrue((boolean)storageNode.startsWith(ZONE2_ADDR));
                    Long prevOpFinishTime = (Long)timingMap.get(itemPath);
                    if (prevOpFinishTime == null) {
                        Assert.fail((String)("No create I/O trace record for \"" + itemPath + "\""));
                        continue block4;
                    }
                    Assert.assertTrue(((double)(reqTimeStart - prevOpFinishTime) / 1000000.0 > 60.0 ? 1 : 0) != 0);
                    continue block4;
                }
            }
            Assert.fail((String)("Unexpected I/O type: " + ioType));
        }
    }
}

