/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.math3.stat.Frequency;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class CircularAppendTest
extends EnvConfiguredScenarioTestBase {
    private static final int EXPECTED_APPEND_COUNT = 100;
    private static final long EXPECTED_COUNT = 100L;
    private static final String ITEM_OUTPUT_FILE_1 = "CircularAppendTest1.csv";
    private static String STD_OUTPUT;
    private static String ITEM_OUTPUT_PATH;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1000));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = CircularAppendTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "CircularAppend.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--storage-net-http-namespace=ns1");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
            CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        SCENARIO.run();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        LogUtil.flushAll();
        TimeUnit.SECONDS.sleep(10L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && STORAGE_DRIVER_TYPE.equals("fs")) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        try {
            List<CSVRecord> metricsLogRecords = CircularAppendTest.getMetricsLogRecords();
            Assert.assertTrue((String)"There should be more than 0 metrics records in the log file", (metricsLogRecords.size() > 0 ? 1 : 0) != 0);
            CircularAppendTest.testMetricsLogRecords(metricsLogRecords, IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 10000L, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalMetrcisLogRecords = CircularAppendTest.getMetricsTotalLogRecords();
        Assert.assertEquals((String)"There should be 1 total metrics records in the log file", (long)1L, (long)totalMetrcisLogRecords.size());
        CircularAppendTest.testTotalMetricsLogRecord(totalMetrcisLogRecords.get(0), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        CircularAppendTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = CircularAppendTest.getIoTraceLogRecords();
        Assert.assertTrue((String)("There should be more than 100 records in the I/O trace log file, but got: " + ioTraceRecords.size()), (100L < (long)ioTraceRecords.size() ? 1 : 0) != 0);
        for (CSVRecord ioTraceRecord : ioTraceRecords) {
            CircularAppendTest.testIoTraceRecord(ioTraceRecord, IoType.UPDATE.ordinal(), ITEM_DATA_SIZE);
        }
    }

    @Test
    public void testUpdatedItemsOutputFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ArrayList<CSVRecord> items = new ArrayList<CSVRecord>();
        try (BufferedReader br = new BufferedReader(new FileReader(ITEM_OUTPUT_FILE_1));){
            CSVParser csvParser = CSVFormat.RFC4180.parse((Reader)br);
            for (CSVRecord csvRecord : csvParser) {
                items.add(csvRecord);
            }
        }
        int itemIdRadix = CONFIG.getItemConfig().getNamingConfig().getRadix();
        Frequency freq = new Frequency();
        SizeInBytes expectedFinalSize = new SizeInBytes((long)(80.0 * (double)ITEM_DATA_SIZE.get()), (long)(120.0 * (double)ITEM_DATA_SIZE.get()), 1.0);
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            CSVRecord itemRec = (CSVRecord)items.get(i);
            String itemPath = itemRec.get(0);
            for (int j = i; j < n; ++j) {
                if (i == j) continue;
                Assert.assertFalse((boolean)itemPath.equals(((CSVRecord)items.get(j)).get(0)));
            }
            String itemId = itemPath.substring(itemPath.lastIndexOf(47) + 1);
            if (!STORAGE_DRIVER_TYPE.equals("atmos")) {
                long itemOffset = Long.parseLong(itemRec.get(1), 16);
                Assert.assertEquals((long)Long.parseLong(itemId, itemIdRadix), (long)itemOffset);
                freq.addValue(itemOffset);
            }
            long itemSize = Long.parseLong(itemRec.get(2));
            Assert.assertTrue((String)("Expected size: " + expectedFinalSize.toString() + ", actual: " + itemSize), (expectedFinalSize.getMin() <= itemSize && itemSize <= expectedFinalSize.getMax() ? 1 : 0) != 0);
            Assert.assertEquals((Object)"0/0", (Object)itemRec.get(3));
        }
        if (!STORAGE_DRIVER_TYPE.equals("atmos")) {
            Assert.assertEquals((long)100L, (long)freq.getUniqueCount());
        }
    }
}

