/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class CircularReadSingleItemTest
extends EnvConfiguredScenarioTestBase {
    private static final String ITEM_OUTPUT_FILE = CircularReadSingleItemTest.class.getSimpleName() + ".csv";
    private static String STD_OUTPUT;
    private static boolean FINISHED_IN_TIME;
    private static String ITEM_OUTPUT_PATH;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos", "swift"));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = CircularReadSingleItemTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "CircularReadSingleItem.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--storage-net-http-namespace=ns1");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
            CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        Thread runner = new Thread(() -> {
            try {
                STD_OUT_STREAM.startRecording();
                SCENARIO.run();
                STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
            }
            catch (Throwable t) {
                LogUtil.exception((Level)Level.ERROR, (Throwable)t, (String)"Failed to run the scenario", (Object[])new Object[0]);
            }
        });
        runner.start();
        TimeUnit.MINUTES.timedJoin(runner, 65L);
        FINISHED_IN_TIME = !runner.isAlive();
        runner.interrupt();
        LogUtil.flushAll();
        TimeUnit.SECONDS.sleep(10L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && STORAGE_DRIVER_TYPE.equals("fs")) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testFinishedInTime() {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        Assert.assertTrue((String)"Scenario didn't finished in time", (boolean)FINISHED_IN_TIME);
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> metricsLogRecords = CircularReadSingleItemTest.getMetricsLogRecords();
        Assert.assertTrue((String)"There should be more than 2 metrics records in the log file", (metricsLogRecords.size() > 1 ? 1 : 0) != 0);
        CircularReadSingleItemTest.testMetricsLogRecords(metricsLogRecords, IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 60, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalMetrcisLogRecords = CircularReadSingleItemTest.getMetricsTotalLogRecords();
        Assert.assertEquals((String)"There should be 1 total metrics records in the log file", (long)1L, (long)totalMetrcisLogRecords.size());
        CircularReadSingleItemTest.testTotalMetricsLogRecord(totalMetrcisLogRecords.get(0), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 60);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        CircularReadSingleItemTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = CircularReadSingleItemTest.getIoTraceLogRecords();
        Assert.assertTrue((String)"There should be more than 1 record in the I/O trace log file", (ioTraceRecords.size() > 1 ? 1 : 0) != 0);
        for (CSVRecord ioTraceRecord : ioTraceRecords) {
            CircularReadSingleItemTest.testIoTraceRecord(ioTraceRecord, IoType.READ.ordinal(), ITEM_DATA_SIZE);
        }
    }

    @Test
    public void testItemsOutputFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ArrayList<CSVRecord> items = new ArrayList<CSVRecord>();
        try (BufferedReader br = new BufferedReader(new FileReader(ITEM_OUTPUT_FILE));){
            CSVParser csvParser = CSVFormat.RFC4180.parse((Reader)br);
            for (CSVRecord csvRecord : csvParser) {
                items.add(csvRecord);
            }
        }
        Assert.assertEquals((long)1L, (long)items.size());
        int itemIdRadix = CONFIG.getItemConfig().getNamingConfig().getRadix();
        CSVRecord itemRec = (CSVRecord)items.get(0);
        String itemPath = itemRec.get(0);
        String itemId = itemPath.substring(itemPath.lastIndexOf(47) + 1);
        long itemOffset = Long.parseLong(itemRec.get(1), 16);
        Assert.assertEquals((long)Long.parseLong(itemId, itemIdRadix), (long)itemOffset);
        long itemSize = Long.parseLong(itemRec.get(2));
        Assert.assertEquals((long)ITEM_DATA_SIZE.get(), (long)itemSize);
        String modLayerAndMask = itemRec.get(3);
        Assert.assertEquals((Object)"0/0", (Object)modLayerAndMask);
    }
}

