/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.tests.system.util.EnvUtil;
import com.emc.mongoose.tests.system.util.HttpStorageMockUtil;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class CopyUsingInputPathTest
extends EnvConfiguredScenarioTestBase {
    private static String ITEM_SRC_PATH;
    private static String ITEM_DST_PATH;
    private static String STD_OUTPUT;
    private static final int COUNT_LIMIT = 1000000;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos"));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = CopyUsingInputPathTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "CopyUsingInputPath.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        ITEM_SRC_PATH = STORAGE_DRIVER_TYPE.equals("fs") ? Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString() : '/' + STEP_ID;
        ITEM_DST_PATH = ITEM_SRC_PATH + "Dst";
        ITEM_SRC_PATH = ITEM_SRC_PATH + "Src";
        EnvUtil.set("ITEM_SRC_PATH", ITEM_SRC_PATH);
        EnvUtil.set("ITEM_DST_PATH", ITEM_DST_PATH);
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        SCENARIO.run();
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && STORAGE_DRIVER_TYPE.equals("fs")) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_SRC_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_DST_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> metricsLogRecords = CopyUsingInputPathTest.getMetricsLogRecords();
        Assert.assertTrue((String)"There should be more than 0 metrics records in the log file", (metricsLogRecords.size() > 0 ? 1 : 0) != 0);
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            CopyUsingInputPathTest.testMetricsLogRecords(metricsLogRecords, IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(ITEM_DATA_SIZE.get() / 2L, ITEM_DATA_SIZE.get(), 1.0), 0L, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        } else {
            CopyUsingInputPathTest.testMetricsLogRecords(metricsLogRecords, IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        }
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalMetrcisLogRecords = CopyUsingInputPathTest.getMetricsTotalLogRecords();
        Assert.assertEquals((String)"There should be 1 total metrics records in the log file", (long)1L, (long)totalMetrcisLogRecords.size());
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            CopyUsingInputPathTest.testTotalMetricsLogRecord(totalMetrcisLogRecords.get(0), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(ITEM_DATA_SIZE.get() / 2L, ITEM_DATA_SIZE.get(), 1.0), 0L, 0);
        } else {
            CopyUsingInputPathTest.testTotalMetricsLogRecord(totalMetrcisLogRecords.get(0), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
        }
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        CopyUsingInputPathTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = CopyUsingInputPathTest.getIoTraceLogRecords();
        Assert.assertTrue((String)"There should be 1000000 records in the I/O trace log file", (ioTraceRecords.size() <= 1000000 ? 1 : 0) != 0);
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            for (CSVRecord ioTraceRecord : ioTraceRecords) {
                String nextItemPath = ioTraceRecord.get("ItemPath");
                File nextSrcFile = new File(nextItemPath);
                String nextItemId = nextItemPath.substring(nextItemPath.lastIndexOf(File.separatorChar) + 1);
                File nextDstFile = Paths.get(ITEM_SRC_PATH, nextItemId).toFile();
                Assert.assertTrue((String)("File \"" + nextItemPath + "\" doesn't exist"), (boolean)nextSrcFile.exists());
                Assert.assertTrue((String)("File \"" + nextDstFile.getPath() + "\" doesn't exist"), (boolean)nextDstFile.exists());
                Assert.assertEquals((long)nextSrcFile.length(), (long)nextDstFile.length());
                CopyUsingInputPathTest.testIoTraceRecord(ioTraceRecord, IoType.CREATE.ordinal(), new SizeInBytes(nextSrcFile.length()));
            }
        } else {
            String node = (String)HTTP_STORAGE_MOCKS.keySet().iterator().next();
            for (CSVRecord ioTraceRecord : ioTraceRecords) {
                CopyUsingInputPathTest.testIoTraceRecord(ioTraceRecord, IoType.CREATE.ordinal(), ITEM_DATA_SIZE);
                String nextItemPath = ioTraceRecord.get("ItemPath");
                String nextItemId = nextItemPath.substring(nextItemPath.lastIndexOf(File.separatorChar) + 1);
                HttpStorageMockUtil.assertItemExists(node, ITEM_SRC_PATH + '/' + nextItemId, ITEM_DATA_SIZE.get());
            }
        }
    }
}

