/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.tests.system.util.HttpStorageMockUtil;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.math3.stat.Frequency;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class CreateLimitBySizeTest
extends EnvConfiguredScenarioTestBase {
    private static boolean FINISHED_IN_TIME = true;
    private static String STD_OUTPUT = null;
    private static final String ITEM_OUTPUT_FILE = CreateLimitBySizeTest.class.getSimpleName() + ".csv";
    private static String ITEM_OUTPUT_PATH = null;
    private static SizeInBytes SIZE_LIMIT;
    private static long EXPECTED_COUNT;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("fs", "atmos"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = CreateLimitBySizeTest.class.getSimpleName();
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        SIZE_LIMIT = ITEM_DATA_SIZE.get() > SizeInBytes.toFixedSize((String)"1GB") ? new SizeInBytes(100L * ITEM_DATA_SIZE.get()) : (ITEM_DATA_SIZE.get() > SizeInBytes.toFixedSize((String)"1MB") ? new SizeInBytes(1000L * ITEM_DATA_SIZE.get()) : (ITEM_DATA_SIZE.get() > SizeInBytes.toFixedSize((String)"10KB") ? new SizeInBytes(10000L * ITEM_DATA_SIZE.get()) : new SizeInBytes(100000L * ITEM_DATA_SIZE.get())));
        EXPECTED_COUNT = SIZE_LIMIT.get() / ITEM_DATA_SIZE.get();
        try {
            Files.delete(Paths.get(ITEM_OUTPUT_FILE, new String[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CONFIG.getItemConfig().getOutputConfig().setFile(ITEM_OUTPUT_FILE);
        CONFIG.getTestConfig().getStepConfig().getLimitConfig().setSize(SIZE_LIMIT);
        switch (STORAGE_DRIVER_TYPE) {
            case "fs": {
                ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
                CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
                break;
            }
            case "swift": {
                CONFIG.getStorageConfig().getNetConfig().getHttpConfig().setNamespace("ns1");
            }
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        Thread runner = new Thread(() -> {
            try {
                STD_OUT_STREAM.startRecording();
                SCENARIO.run();
                STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
            }
            catch (Throwable t) {
                LogUtil.exception((Level)Level.ERROR, (Throwable)t, (String)"Failed to run the scenario", (Object[])new Object[0]);
            }
        });
        runner.start();
        TimeUnit.SECONDS.timedJoin(runner, 1000L);
        FINISHED_IN_TIME = !runner.isAlive();
        runner.interrupt();
        LogUtil.flushAll();
        TimeUnit.SECONDS.sleep(10L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && "fs".equals(STORAGE_DRIVER_TYPE)) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testFinishedInTime() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        Assert.assertTrue((boolean)FINISHED_IN_TIME);
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        CreateLimitBySizeTest.testMetricsLogRecords(CreateLimitBySizeTest.getMetricsLogRecords(), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, EXPECTED_COUNT, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        CreateLimitBySizeTest.testTotalMetricsLogRecord(CreateLimitBySizeTest.getMetricsTotalLogRecords().get(0), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, EXPECTED_COUNT, 0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        CreateLimitBySizeTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        CreateLimitBySizeTest.testMetricsTableStdout(STD_OUTPUT, STEP_ID, STORAGE_DRIVERS_COUNT, EXPECTED_COUNT, (Map<IoType, Integer>)new HashMap<IoType, Integer>(){
            {
                this.put(IoType.CREATE, CONCURRENCY);
            }
        });
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = CreateLimitBySizeTest.getIoTraceLogRecords();
        Assert.assertEquals((long)EXPECTED_COUNT, (long)ioTraceRecords.size());
        String nodeAddr = (String)HTTP_STORAGE_MOCKS.keySet().iterator().next();
        for (CSVRecord ioTraceRecord : ioTraceRecords) {
            CreateLimitBySizeTest.testIoTraceRecord(ioTraceRecord, IoType.CREATE.ordinal(), ITEM_DATA_SIZE);
            HttpStorageMockUtil.assertItemExists(nodeAddr, ioTraceRecord.get("ItemPath"), Long.parseLong(ioTraceRecord.get("TransferSize")));
        }
    }

    @Test
    public void testIoBufferSizeAdjustment() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        String msg = "Adjust output buffer size: " + ITEM_DATA_SIZE.toString();
        for (int i = 0; i < STORAGE_DRIVERS_COUNT; ++i) {
            int k = STD_OUTPUT.indexOf(msg);
            if (k > -1) {
                msg = STD_OUTPUT.substring(k + msg.length());
                continue;
            }
            Assert.fail((String)("Expected the message to occur " + STORAGE_DRIVERS_COUNT + " times, but got " + i));
        }
    }

    @Test
    public void testItemsOutputFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ArrayList<CSVRecord> items = new ArrayList<CSVRecord>();
        try (BufferedReader br = new BufferedReader(new FileReader(ITEM_OUTPUT_FILE));){
            CSVParser csvParser = CSVFormat.RFC4180.parse((Reader)br);
            for (CSVRecord csvRecord : csvParser) {
                items.add(csvRecord);
            }
        }
        Assert.assertEquals((long)EXPECTED_COUNT, (long)items.size());
        int itemIdRadix = CONFIG.getItemConfig().getNamingConfig().getRadix();
        Frequency freq = new Frequency();
        for (CSVRecord itemRec : items) {
            String itemPath = itemRec.get(0);
            String itemId = itemPath.substring(itemPath.lastIndexOf(47) + 1);
            long itemOffset = Long.parseLong(itemRec.get(1), 16);
            Assert.assertEquals((long)Long.parseLong(itemId, itemIdRadix), (long)itemOffset);
            freq.addValue(itemOffset);
            long itemSize = Long.parseLong(itemRec.get(2));
            Assert.assertEquals((long)ITEM_DATA_SIZE.get(), (long)itemSize);
            String modLayerAndMask = itemRec.get(3);
            Assert.assertEquals((Object)"0/0", (Object)modLayerAndMask);
        }
        Assert.assertEquals((long)items.size(), (long)freq.getUniqueCount());
    }
}

