/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.tests.system.util.OpenFilesCounter;
import com.emc.mongoose.tests.system.util.PortListener;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class CreateNoLimitTest
extends EnvConfiguredScenarioTestBase {
    private static Thread RUNNER;
    private static String ITEM_OUTPUT_PATH;
    private static String STD_OUTPUT;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("s3", "swift"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(100, 1000));
        STEP_ID = CreateNoLimitTest.class.getSimpleName();
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        switch (STORAGE_DRIVER_TYPE) {
            case "fs": {
                ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
                CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
                break;
            }
            case "swift": {
                CONFIG.getStorageConfig().getNetConfig().getHttpConfig().setNamespace("ns1");
            }
        }
        SCENARIO = new JsonScenario(CONFIG, DEFAULT_SCENARIO_PATH.toFile());
        RUNNER = new Thread(() -> {
            try {
                SCENARIO.run();
            }
            catch (Throwable t) {
                LogUtil.exception((Level)Level.ERROR, (Throwable)t, (String)"Failed to run the scenario", (Object[])new Object[0]);
            }
        });
        STD_OUT_STREAM.startRecording();
        RUNNER.start();
        TimeUnit.SECONDS.sleep(25L);
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG) {
            if (RUNNER != null) {
                RUNNER.interrupt();
            }
            if ("fs".equals(STORAGE_DRIVER_TYPE)) {
                try {
                    DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public final void testActualConcurrencyCount() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        int expectedConcurrency = STORAGE_DRIVERS_COUNT * CONCURRENCY;
        if ("fs".equals(STORAGE_DRIVER_TYPE)) {
            int actualConcurrency = OpenFilesCounter.getOpenFilesCount(ITEM_OUTPUT_PATH);
            Assert.assertTrue((String)("Expected concurrency <= " + actualConcurrency + ", actual: " + actualConcurrency), (actualConcurrency <= expectedConcurrency ? 1 : 0) != 0);
        } else {
            int actualConcurrency = 0;
            int startPort = CONFIG.getStorageConfig().getNetConfig().getNodeConfig().getPort();
            for (int j = 0; j < HTTP_STORAGE_NODE_COUNT; ++j) {
                actualConcurrency += PortListener.getCountConnectionsOnPort("127.0.0.1:" + (startPort + j));
            }
            Assert.assertEquals((String)("Expected concurrency: " + actualConcurrency + ", actual: " + actualConcurrency), (float)expectedConcurrency, (float)actualConcurrency, (float)(expectedConcurrency / 100));
        }
    }

    @Test
    public final void testStdOutput() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        CreateNoLimitTest.testMetricsTableStdout(STD_OUTPUT, STEP_ID, STORAGE_DRIVERS_COUNT, 0L, (Map<IoType, Integer>)new HashMap<IoType, Integer>(){
            {
                this.put(IoType.CREATE, CONCURRENCY);
            }
        });
    }
}

