/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.EnvUtil;
import com.emc.mongoose.tests.system.util.HttpStorageMockUtil;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class DeleteUsingInputPathLimitByRateTest
extends EnvConfiguredScenarioTestBase {
    private static final int EXPECTED_COUNT = 100000;
    private static final int EXPECTED_RATE = 1234;
    private static String STD_OUTPUT = null;
    private static String ITEM_OUTPUT_PATH = null;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = DeleteUsingInputPathLimitByRateTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "DeleteUsingInputPathLimitByRate.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        switch (STORAGE_DRIVER_TYPE) {
            case "fs": {
                ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
                EnvUtil.set("ITEMS_PATH", ITEM_OUTPUT_PATH);
                break;
            }
            case "swift": {
                CONFIG.getStorageConfig().getNetConfig().getHttpConfig().setNamespace("ns1");
            }
            default: {
                EnvUtil.set("ITEMS_PATH", "/" + STEP_ID);
            }
        }
        try {
            SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
            STD_OUT_STREAM.startRecording();
            SCENARIO.run();
            STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        }
        catch (Throwable t) {
            LogUtil.exception((Level)Level.ERROR, (Throwable)t, (String)"Failed to run the scenario", (Object[])new Object[0]);
        }
        LogUtil.flushAll();
        TimeUnit.SECONDS.sleep(10L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && "fs".equals(STORAGE_DRIVER_TYPE)) {
            try {
                FileUtils.deleteDirectory((File)new File(ITEM_OUTPUT_PATH));
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> metricsLogRecs = DeleteUsingInputPathLimitByRateTest.getMetricsLogRecords();
        DeleteUsingInputPathLimitByRateTest.testMetricsLogRecords(metricsLogRecs, IoType.DELETE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(0L), 100000L, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        for (CSVRecord metricsLogRec : metricsLogRecs) {
            Assert.assertEquals((double)1234.0, (double)Double.parseDouble(metricsLogRec.get("TPAvg[op/s]")), (double)1234.0);
        }
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        CSVRecord totalRec = DeleteUsingInputPathLimitByRateTest.getMetricsTotalLogRecords().get(0);
        DeleteUsingInputPathLimitByRateTest.testTotalMetricsLogRecord(totalRec, IoType.DELETE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(0L), 100000L, 0);
        Assert.assertEquals((double)1234.0, (double)Double.parseDouble(totalRec.get("TPAvg[op/s]")), (double)123.0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        DeleteUsingInputPathLimitByRateTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.DELETE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        DeleteUsingInputPathLimitByRateTest.testMetricsTableStdout(STD_OUTPUT, STEP_ID, STORAGE_DRIVERS_COUNT, 100000L, (Map<IoType, Integer>)new HashMap<IoType, Integer>(){
            {
                this.put(IoType.DELETE, CONCURRENCY);
            }
        });
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = DeleteUsingInputPathLimitByRateTest.getIoTraceLogRecords();
        Assert.assertTrue((ioTraceRecords.size() > 0 ? 1 : 0) != 0);
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            for (CSVRecord ioTraceRecord : ioTraceRecords) {
                DeleteUsingInputPathLimitByRateTest.testIoTraceRecord(ioTraceRecord, IoType.DELETE.ordinal(), new SizeInBytes(0L));
                String nextItemPath = ioTraceRecord.get("ItemPath");
                Assert.assertFalse((boolean)Files.exists(Paths.get(nextItemPath, new String[0]), new LinkOption[0]));
            }
        } else {
            String nodeAddr = (String)CONFIG.getStorageConfig().getNetConfig().getNodeConfig().getAddrs().get(0);
            for (CSVRecord ioTraceRecord : ioTraceRecords) {
                DeleteUsingInputPathLimitByRateTest.testIoTraceRecord(ioTraceRecord, IoType.DELETE.ordinal(), new SizeInBytes(0L));
                String nextItemPath = ioTraceRecord.get("ItemPath");
                HttpStorageMockUtil.assertItemNotExists(nodeAddr, nextItemPath);
            }
        }
    }
}

