/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.DateUtil;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.LogPatterns;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class HttpStorageMetricsThresholdTest
extends EnvConfiguredScenarioTestBase {
    private static final double LOAD_THRESHOLD = 0.8;
    private static final int RANDOM_RANGES_COUNT = 10;
    private static String STD_OUTPUT;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("fs"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L)));
        STEP_ID = HttpStorageMetricsThresholdTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "HttpStorageMetricsThreshold.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        SCENARIO.run();
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        TimeUnit.SECONDS.sleep(10L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> metricsLogRecs = HttpStorageMetricsThresholdTest.getMetricsLogRecords();
        ArrayList<CSVRecord> createMetricsRecs = new ArrayList<CSVRecord>();
        ArrayList<CSVRecord> readMetricsRecs = new ArrayList<CSVRecord>();
        ArrayList<CSVRecord> updateMetricsRecs = new ArrayList<CSVRecord>();
        for (CSVRecord metricsRec : metricsLogRecs) {
            IoType nextMetricsRecIoType = IoType.valueOf((String)metricsRec.get("TypeLoad"));
            switch (nextMetricsRecIoType) {
                case NOOP: {
                    Assert.fail((String)("Unexpected I/O type: " + nextMetricsRecIoType));
                    break;
                }
                case CREATE: {
                    createMetricsRecs.add(metricsRec);
                    break;
                }
                case READ: {
                    readMetricsRecs.add(metricsRec);
                    break;
                }
                case UPDATE: {
                    updateMetricsRecs.add(metricsRec);
                    break;
                }
                case DELETE: {
                    Assert.fail((String)("Unexpected I/O type: " + nextMetricsRecIoType));
                    break;
                }
                case LIST: {
                    Assert.fail((String)("Unexpected I/O type: " + nextMetricsRecIoType));
                }
            }
        }
        long period = CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod();
        HttpStorageMetricsThresholdTest.testMetricsLogRecords(createMetricsRecs, IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0, period);
        HttpStorageMetricsThresholdTest.testMetricsLogRecords(readMetricsRecs, IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0, period);
        HttpStorageMetricsThresholdTest.testMetricsLogRecords(updateMetricsRecs, IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(0L, ITEM_DATA_SIZE.get(), 1.0), 0L, 0, period);
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalMetricsRecs = HttpStorageMetricsThresholdTest.getMetricsTotalLogRecords();
        HttpStorageMetricsThresholdTest.testTotalMetricsLogRecord(totalMetricsRecs.get(0), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
        HttpStorageMetricsThresholdTest.testTotalMetricsLogRecord(totalMetricsRecs.get(1), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
        HttpStorageMetricsThresholdTest.testTotalMetricsLogRecord(totalMetricsRecs.get(2), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(0L, ITEM_DATA_SIZE.get(), 1.0), 0L, 0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        long period = CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod();
        HttpStorageMetricsThresholdTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, period);
        HttpStorageMetricsThresholdTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, period);
        HttpStorageMetricsThresholdTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(0L, ITEM_DATA_SIZE.get(), 1.0), period);
    }

    @Test
    public void testMedTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalThresholdMetricsRecs = HttpStorageMetricsThresholdTest.getMetricsMedTotalLogRecords();
        HttpStorageMetricsThresholdTest.testTotalMetricsLogRecord(totalThresholdMetricsRecs.get(0), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
        HttpStorageMetricsThresholdTest.testTotalMetricsLogRecord(totalThresholdMetricsRecs.get(1), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
        HttpStorageMetricsThresholdTest.testTotalMetricsLogRecord(totalThresholdMetricsRecs.get(2), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, new SizeInBytes(0L, ITEM_DATA_SIZE.get(), 1.0), 0L, 0);
    }

    @Test
    public void testThresholdConditionMessagesInStdout() throws Exception {
        Matcher m;
        Assume.assumeFalse((boolean)SKIP_FLAG);
        int n = 0;
        while ((m = LogPatterns.STD_OUT_LOAD_THRESHOLD_ENTRANCE.matcher(STD_OUTPUT)).find()) {
            Date dtEnter = DateUtil.FMT_DATE_ISO8601.parse(m.group("dateTime"));
            int threshold = Integer.parseInt(m.group("threshold"));
            Assert.assertEquals((double)((double)CONCURRENCY * 0.8), (double)threshold, (double)0.0);
            STD_OUTPUT = m.replaceFirst("");
            m = LogPatterns.STD_OUT_LOAD_THRESHOLD_EXIT.matcher(STD_OUTPUT.substring(m.regionStart()));
            Assert.assertTrue((boolean)m.find());
            Date dtExit = DateUtil.FMT_DATE_ISO8601.parse(m.group("dateTime"));
            Assert.assertTrue((boolean)dtEnter.before(dtExit));
            STD_OUTPUT = m.replaceFirst("");
            ++n;
        }
        Assert.assertEquals((long)3L, (long)n);
    }
}

