/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class InfiniteLoopTest
extends EnvConfiguredScenarioTestBase {
    private static final int SCENARIO_TIMEOUT = 50;
    private static final int EXPECTED_STEP_TIME = 5;
    private static final int EXPECTED_LOOP_COUNT = 10;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos", "fs", "swift"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_COUNT", Arrays.asList(1));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1, 10));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("1MB"), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = InfiniteLoopTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "InfiniteLoop.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--item-output-path=/default");
        CONFIG_ARGS.add("--test-step-limit-time=5");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        Thread runner = new Thread(() -> SCENARIO.run());
        runner.start();
        TimeUnit.SECONDS.timedJoin(runner, 50L);
        runner.interrupt();
        TimeUnit.SECONDS.sleep(10L);
        LogUtil.flushAll();
    }

    @Test
    public final void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalRecs = InfiniteLoopTest.getMetricsTotalLogRecords();
        Assert.assertEquals((long)10L, (long)totalRecs.size());
    }
}

