/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class LoopByCountTest
extends EnvConfiguredScenarioTestBase {
    private static final int EXPECTED_LOOP_COUNT = 10;
    private static final int EXPECTED_STEP_TIME = 5;
    private static long ACTUAL_TEST_TIME;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("fs", "s3", "swift"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1, 10));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_COUNT", Arrays.asList(2));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("10KB"), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = LoopByCountTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "LoopByCount.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--test-step-limit-time=5");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        ACTUAL_TEST_TIME = System.currentTimeMillis();
        SCENARIO.run();
        ACTUAL_TEST_TIME = (System.currentTimeMillis() - ACTUAL_TEST_TIME) / 1000L;
        TimeUnit.SECONDS.sleep(10L);
        LogUtil.flushAll();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public final void testDuration() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        Assert.assertEquals((float)50.0f, (float)ACTUAL_TEST_TIME, (float)25.0f);
    }

    @Test
    public final void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalRecs = LoopByCountTest.getMetricsTotalLogRecords();
        Assert.assertEquals((long)10L, (long)totalRecs.size());
        for (CSVRecord totalRec : totalRecs) {
            LoopByCountTest.testTotalMetricsLogRecord(totalRec, IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 5);
        }
    }
}

