/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.LoopByCountTest;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.LogPatterns;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class LoopByRangeTest
extends EnvConfiguredScenarioTestBase {
    private static final double EXPECTED_LOOP_START_VALUE = 2.71828182846;
    private static final double EXPECTED_LOOP_LIMIT_VALUE = 3.1415926;
    private static final double EXPECTED_STEP_VALUE = 0.1;
    private static final Pattern PTRN_LOOP_STEP_MSG = Pattern.compile(LogPatterns.ASCII_COLOR.pattern() + LogPatterns.DATE_TIME_ISO8601.pattern() + "\\s+" + LogPatterns.STD_OUT_LOG_LEVEL.pattern() + "\\s+" + LogPatterns.STD_OUT_CLASS_NAME.pattern() + "\\s+" + LogPatterns.STD_OUT_THREAD_NAME.pattern() + "\\s+Use\\snext\\svalue\\sfor\\s\"i\":\\s(?<stepValue>\\d\\.\\d+)");
    private static String STD_OUTPUT;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos", "s3", "swift"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(10, 100, 1000));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_COUNT", Arrays.asList(2));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes("1KB"), new SizeInBytes("1MB"), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = LoopByCountTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "LoopByRange.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        SCENARIO.run();
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public final void testSteps() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        Matcher m = PTRN_LOOP_STEP_MSG.matcher(STD_OUTPUT);
        double nextExpectedStepVal = 2.71828182846;
        while (m.find()) {
            String t = m.group("stepValue");
            Assert.assertEquals((double)nextExpectedStepVal, (double)Double.parseDouble(t), (double)0.001);
            Assert.assertTrue((nextExpectedStepVal <= 3.1415926 ? 1 : 0) != 0);
            nextExpectedStepVal += 0.1;
        }
    }
}

