/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class LoopBySequenceTest
extends EnvConfiguredScenarioTestBase {
    private static final int EXPECTED_LOOP_COUNT = 4;
    private static final int EXPECTED_STEP_TIME = 15;
    private static long ACTUAL_TEST_TIME;
    private static String ITEM_OUTPUT_PATH;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos", "s3"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_COUNT", Arrays.asList(2));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(10, 100, 1000));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes("1MB"), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = LoopBySequenceTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "LoopBySequence.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--test-step-limit-time=15");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        switch (STORAGE_DRIVER_TYPE) {
            case "fs": {
                ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
                CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
                break;
            }
            case "swift": {
                CONFIG.getStorageConfig().getNetConfig().getHttpConfig().setNamespace("ns1");
            }
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        ACTUAL_TEST_TIME = System.currentTimeMillis();
        SCENARIO.run();
        ACTUAL_TEST_TIME = (System.currentTimeMillis() - ACTUAL_TEST_TIME) / 1000L;
        TimeUnit.SECONDS.sleep(15L);
        LogUtil.flushAll();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && "fs".equals(STORAGE_DRIVER_TYPE)) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public final void testDuration() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        Assert.assertEquals((float)60.0f, (float)ACTUAL_TEST_TIME, (float)10.0f);
    }

    @Test
    public final void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalRecs = LoopBySequenceTest.getMetricsTotalLogRecords();
        Assert.assertEquals((long)4L, (long)totalRecs.size());
        LoopBySequenceTest.testTotalMetricsLogRecord(totalRecs.get(0), IoType.CREATE, 1, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 15);
        LoopBySequenceTest.testTotalMetricsLogRecord(totalRecs.get(1), IoType.CREATE, 10, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 15);
        LoopBySequenceTest.testTotalMetricsLogRecord(totalRecs.get(2), IoType.CREATE, 100, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 15);
        LoopBySequenceTest.testTotalMetricsLogRecord(totalRecs.get(3), IoType.CREATE, 1000, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 15);
    }
}

