/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.tests.system.util.OpenFilesCounter;
import com.emc.mongoose.tests.system.util.PortListener;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class MixedLoadTest
extends EnvConfiguredScenarioTestBase {
    private static boolean FINISHED_IN_TIME;
    private static String STD_OUTPUT;
    private static int ACTUAL_CONCURRENCY;
    private static String ITEM_OUTPUT_PATH;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = MixedLoadTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "MixedLoad.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--storage-net-http-namespace=ns1");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
            CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        Thread runner = new Thread(() -> {
            try {
                SCENARIO.run();
            }
            catch (Throwable t) {
                LogUtil.exception((Level)Level.ERROR, (Throwable)t, (String)"Failed to run the scenario", (Object[])new Object[0]);
            }
        });
        runner.start();
        TimeUnit.SECONDS.sleep(10L);
        STD_OUT_STREAM.startRecording();
        TimeUnit.SECONDS.sleep(10L);
        switch (STORAGE_DRIVER_TYPE) {
            case "fs": {
                ACTUAL_CONCURRENCY = OpenFilesCounter.getOpenFilesCount(ITEM_OUTPUT_PATH);
                break;
            }
            case "atmos": 
            case "s3": 
            case "swift": {
                int startPort = CONFIG.getStorageConfig().getNetConfig().getNodeConfig().getPort();
                for (int i = 0; i < HTTP_STORAGE_NODE_COUNT; ++i) {
                    ACTUAL_CONCURRENCY += PortListener.getCountConnectionsOnPort("127.0.0.1:" + (startPort + i));
                }
                break;
            }
        }
        TimeUnit.SECONDS.timedJoin(runner, 50L);
        FINISHED_IN_TIME = !runner.isAlive();
        runner.interrupt();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        LogUtil.flushAll();
        TimeUnit.SECONDS.sleep(10L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && STORAGE_DRIVER_TYPE.equals("fs")) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testFinishedInTime() {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        Assert.assertTrue((String)"Scenario didn't finished in time", (boolean)FINISHED_IN_TIME);
    }

    @Test
    public void testActualConcurrency() {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        Assume.assumeThat((Object)STORAGE_DRIVER_TYPE, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)"fs")));
        Assert.assertEquals((float)(2 * STORAGE_DRIVERS_COUNT * CONCURRENCY), (float)ACTUAL_CONCURRENCY, (float)5.0f);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        HashMap<IoType, Integer> concurrencyMap = new HashMap<IoType, Integer>();
        concurrencyMap.put(IoType.CREATE, CONCURRENCY);
        concurrencyMap.put(IoType.READ, CONCURRENCY);
        MixedLoadTest.testMetricsTableStdout(STD_OUTPUT, STEP_ID, STORAGE_DRIVERS_COUNT, 0L, concurrencyMap);
    }
}

