/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.EnvUtil;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class MultiPartCreateTest
extends EnvConfiguredScenarioTestBase {
    private static String STD_OUTPUT;
    private static long EXPECTED_COUNT;
    private static SizeInBytes PART_SIZE;
    private static SizeInBytes SIZE_LIMIT;
    private static final String ITEM_OUTPUT_FILE;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos", "fs"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1000));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("10KB"), new SizeInBytes("10GB")));
        STEP_ID = MultiPartCreateTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "MultiPartCreate.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        PART_SIZE = ITEM_DATA_SIZE;
        ITEM_DATA_SIZE = new SizeInBytes(PART_SIZE.get(), 100L * PART_SIZE.get(), 3.0);
        CONFIG.getItemConfig().getDataConfig().setSize(ITEM_DATA_SIZE);
        EnvUtil.set("PART_SIZE", PART_SIZE.toString());
        EnvUtil.set("ITEM_OUTPUT_FILE", ITEM_OUTPUT_FILE);
        SIZE_LIMIT = new SizeInBytes(Math.min(SizeInBytes.toFixedSize((String)"100GB"), (long)(1000 * CONCURRENCY) * PART_SIZE.get()));
        EnvUtil.set("SIZE_LIMIT", SIZE_LIMIT.toString());
        EXPECTED_COUNT = SIZE_LIMIT.get() / ITEM_DATA_SIZE.getAvg();
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        SCENARIO.run();
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        TimeUnit.SECONDS.sleep(5L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalMetrcisLogRecords = MultiPartCreateTest.getMetricsTotalLogRecords();
        Assert.assertEquals((String)"There should be 1 total metrics records in the log file", (long)1L, (long)totalMetrcisLogRecords.size());
        MultiPartCreateTest.testTotalMetricsLogRecord(totalMetrcisLogRecords.get(0), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        MultiPartCreateTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = MultiPartCreateTest.getIoTraceLogRecords();
        Assert.assertTrue((String)("There should be more than " + EXPECTED_COUNT + " records in the I/O trace log file, but got: " + ioTraceRecords.size()), (EXPECTED_COUNT < (long)ioTraceRecords.size() ? 1 : 0) != 0);
        SizeInBytes ZERO_SIZE = new SizeInBytes(0L);
        SizeInBytes TAIL_PART_SIZE = new SizeInBytes(1L, PART_SIZE.get(), 1.0);
        for (CSVRecord ioTraceRecord : ioTraceRecords) {
            try {
                MultiPartCreateTest.testIoTraceRecord(ioTraceRecord, IoType.CREATE.ordinal(), ZERO_SIZE);
            }
            catch (AssertionError e) {
                try {
                    MultiPartCreateTest.testIoTraceRecord(ioTraceRecord, IoType.CREATE.ordinal(), PART_SIZE);
                }
                catch (AssertionError ee) {
                    MultiPartCreateTest.testIoTraceRecord(ioTraceRecord, IoType.CREATE.ordinal(), TAIL_PART_SIZE);
                }
            }
        }
    }

    @Test
    public void testItemsOutputFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ArrayList<CSVRecord> itemRecs = new ArrayList<CSVRecord>();
        try (BufferedReader br = new BufferedReader(new FileReader(ITEM_OUTPUT_FILE));
             CSVParser csvParser = CSVFormat.RFC4180.parse((Reader)br);){
            for (CSVRecord csvRecord : csvParser) {
                itemRecs.add(csvRecord);
            }
        }
        long sizeSum = 0L;
        int n = itemRecs.size();
        Assert.assertEquals((float)EXPECTED_COUNT, (float)n, (float)(EXPECTED_COUNT / 2L));
        for (int i = 0; i < n; ++i) {
            long nextItemSize = Long.parseLong(((CSVRecord)itemRecs.get(i)).get(2));
            Assert.assertTrue((ITEM_DATA_SIZE.getMin() <= nextItemSize ? 1 : 0) != 0);
            Assert.assertTrue((ITEM_DATA_SIZE.getMax() >= nextItemSize ? 1 : 0) != 0);
            sizeSum += nextItemSize;
        }
        long expectedAvgSize = ITEM_DATA_SIZE.getAvg();
        Assert.assertEquals((float)expectedAvgSize, (float)(sizeSum / (long)n), (float)(expectedAvgSize / 5L));
    }

    static {
        ITEM_OUTPUT_FILE = MultiPartCreateTest.class.getSimpleName() + "Items.csv";
    }
}

