/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReadCustomContentVerificationFailTest
extends EnvConfiguredScenarioTestBase {
    private static String ITEM_OUTPUT_PATH;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(10, 1000));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = ReadCustomContentVerificationFailTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "ReadVerificationFail.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--item-data-input-file=" + PathUtil.getBaseDir() + "/config/content/textexample");
        CONFIG_ARGS.add("--storage-net-http-namespace=ns1");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
            CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        SCENARIO.run();
        LogUtil.flushAll();
        TimeUnit.SECONDS.sleep(5L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && STORAGE_DRIVER_TYPE.equals("fs")) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = ReadCustomContentVerificationFailTest.getIoTraceLogRecords();
        Assert.assertTrue((String)"The count of the I/O trace records should be > 0", (ioTraceRecords.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < ioTraceRecords.size(); ++i) {
            CSVRecord csvRecord = ioTraceRecords.get(i);
            Assert.assertEquals((String)("Record #" + i + ": unexpected operation type " + csvRecord.get("IoTypeCode")), (Object)IoType.READ, (Object)IoType.values()[Integer.parseInt(csvRecord.get("IoTypeCode"))]);
            Assert.assertEquals((String)("Record #" + i + ": unexpected status code " + csvRecord.get("StatusCode")), (Object)IoTask.Status.RESP_FAIL_CORRUPT, (Object)IoTask.Status.values()[Integer.parseInt(csvRecord.get("StatusCode"))]);
        }
    }
}

