/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.base.EnvConfiguredTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.tests.system.util.EnvUtil;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReadFilesWithVariablePathTest
extends EnvConfiguredScenarioTestBase {
    private static String FILE_OUTPUT_PATH;
    private static String STD_OUTPUT;
    private static final int EXPECTED_COUNT = 10000;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos", "s3", "swift"));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes("1MB"), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = ReadFilesWithVariablePathTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "ReadFilesWithVariablePath.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--item-naming-radix=16");
        CONFIG_ARGS.add("--item-naming-length=16");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            FILE_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
            EnvUtil.set("FILE_OUTPUT_PATH", FILE_OUTPUT_PATH);
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        SCENARIO.run();
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        TimeUnit.SECONDS.sleep(5L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG) {
            try {
                DirWithManyFilesDeleter.deleteExternal(FILE_OUTPUT_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredTestBase.tearDownClass();
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ReadFilesWithVariablePathTest.testMetricsLogRecords(ReadFilesWithVariablePathTest.getMetricsLogRecords(), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 10000L, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ReadFilesWithVariablePathTest.testTotalMetricsLogRecord(ReadFilesWithVariablePathTest.getMetricsTotalLogRecords().get(0), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 10000L, 0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ReadFilesWithVariablePathTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = ReadFilesWithVariablePathTest.getIoTraceLogRecords();
        Assert.assertEquals((long)10000L, (long)ioTraceRecords.size());
        Pattern subPathPtrn = Pattern.compile("(/[0-9a-f]){1,2}/[0-9a-f]{16}");
        int baseOutputPathLen = FILE_OUTPUT_PATH.length();
        for (CSVRecord ioTraceRecord : ioTraceRecords) {
            ReadFilesWithVariablePathTest.testIoTraceRecord(ioTraceRecord, IoType.READ.ordinal(), ITEM_DATA_SIZE);
            String nextFilePath = ioTraceRecord.get("ItemPath");
            Assert.assertTrue((boolean)nextFilePath.startsWith(FILE_OUTPUT_PATH));
            nextFilePath = nextFilePath.substring(baseOutputPathLen);
            Matcher m = subPathPtrn.matcher(nextFilePath);
            Assert.assertTrue((boolean)m.matches());
        }
    }
}

