/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReadUsingInputFileLimitByCountTest
extends EnvConfiguredScenarioTestBase {
    private static long EXPECTED_COUNT = 10000L;
    private static String STD_OUTPUT = null;
    private static String ITEM_OUTPUT_PATH = null;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos", "s3"));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes("1MB"), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = ReadUsingInputFileLimitByCountTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "ReadUsingInputFileLimitByCount.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        switch (STORAGE_DRIVER_TYPE) {
            case "fs": {
                ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
                CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
                break;
            }
            case "swift": {
                CONFIG.getStorageConfig().getNetConfig().getHttpConfig().setNamespace("ns1");
            }
        }
        try {
            SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
            STD_OUT_STREAM.startRecording();
            SCENARIO.run();
            STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        }
        catch (Throwable t) {
            LogUtil.exception((Level)Level.ERROR, (Throwable)t, (String)"Failed to run the scenario", (Object[])new Object[0]);
        }
        LogUtil.flushAll();
        TimeUnit.SECONDS.sleep(10L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && "fs".equals(STORAGE_DRIVER_TYPE)) {
            try {
                FileUtils.deleteDirectory((File)new File(ITEM_OUTPUT_PATH));
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ReadUsingInputFileLimitByCountTest.testMetricsLogRecords(ReadUsingInputFileLimitByCountTest.getMetricsLogRecords(), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, EXPECTED_COUNT, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ReadUsingInputFileLimitByCountTest.testTotalMetricsLogRecord(ReadUsingInputFileLimitByCountTest.getMetricsTotalLogRecords().get(0), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, EXPECTED_COUNT, 0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ReadUsingInputFileLimitByCountTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = ReadUsingInputFileLimitByCountTest.getIoTraceLogRecords();
        Assert.assertEquals((long)EXPECTED_COUNT, (long)ioTraceRecords.size());
        for (CSVRecord ioTraceRecord : ioTraceRecords) {
            ReadUsingInputFileLimitByCountTest.testIoTraceRecord(ioTraceRecord, IoType.READ.ordinal(), ITEM_DATA_SIZE);
        }
    }
}

