/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReadVerificationDisableTest
extends EnvConfiguredScenarioTestBase {
    private static String ITEM_OUTPUT_PATH;
    private static String STD_OUTPUT;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("s3", "swift"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1, 1000));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = ReadVerificationDisableTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "ReadVerificationDisable.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        CONFIG_ARGS.add("--storage-net-http-namespace=ns1");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
            CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        SCENARIO.run();
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        TimeUnit.SECONDS.sleep(5L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && STORAGE_DRIVER_TYPE.equals("fs")) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = ReadVerificationDisableTest.getIoTraceLogRecords();
        for (int i = 0; i < ioTraceRecords.size(); ++i) {
            CSVRecord csvRecord = ioTraceRecords.get(i);
            Assert.assertEquals((String)("Record #" + i + ": unexpected operation type " + csvRecord.get("IoTypeCode")), (Object)IoType.READ, (Object)IoType.values()[Integer.parseInt(csvRecord.get("IoTypeCode"))]);
            Assert.assertEquals((String)("Record #" + i + ": unexpected status code " + csvRecord.get("StatusCode")), (Object)IoTask.Status.SUCC, (Object)IoTask.Status.values()[Integer.parseInt(csvRecord.get("StatusCode"))]);
        }
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ReadVerificationDisableTest.testMetricsLogRecords(ReadVerificationDisableTest.getMetricsLogRecords(), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ReadVerificationDisableTest.testTotalMetricsLogRecord(ReadVerificationDisableTest.getMetricsTotalLogRecords().get(0), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ReadVerificationDisableTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        ReadVerificationDisableTest.testMetricsTableStdout(STD_OUTPUT, STEP_ID, STORAGE_DRIVERS_COUNT, 0L, (Map<IoType, Integer>)new HashMap<IoType, Integer>(){
            {
                this.put(IoType.CREATE, CONCURRENCY);
                this.put(IoType.UPDATE, CONCURRENCY);
                this.put(IoType.READ, CONCURRENCY);
            }
        });
    }
}

