/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.tests.system.util.DirWithManyFilesDeleter;
import com.emc.mongoose.ui.log.LogUtil;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class SingleRandomUpdateAndMultipleRandomReadTest
extends EnvConfiguredScenarioTestBase {
    private static String ITEM_OUTPUT_PATH;
    private static String STD_OUTPUT;
    private static SizeInBytes EXPECTED_UPDATE_SIZE;
    private static SizeInBytes EXPECTED_READ_SIZE;
    private static final long EXPECTED_COUNT = 1000L;
    private static final int READ_RANDOM_RANGES_COUNT = 7;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1000));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = SingleRandomUpdateAndMultipleRandomReadTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "SingleRandomUpdateAndMultipleRandomRead.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        EXPECTED_READ_SIZE = new SizeInBytes(127L, ITEM_DATA_SIZE.get(), 1.0);
        EXPECTED_UPDATE_SIZE = new SizeInBytes(1L, ITEM_DATA_SIZE.get(), 1.0);
        if (STORAGE_DRIVER_TYPE.equals("fs")) {
            ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
            CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        SCENARIO.run();
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && STORAGE_DRIVER_TYPE.equals("fs")) {
            try {
                DirWithManyFilesDeleter.deleteExternal(ITEM_OUTPUT_PATH);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> metricsLogRecords = SingleRandomUpdateAndMultipleRandomReadTest.getMetricsLogRecords();
        ArrayList<CSVRecord> updateMetricsRecords = new ArrayList<CSVRecord>();
        ArrayList<CSVRecord> readMetricsRecords = new ArrayList<CSVRecord>();
        for (CSVRecord metricsLogRec : metricsLogRecords) {
            if (IoType.UPDATE.name().equalsIgnoreCase(metricsLogRec.get("TypeLoad"))) {
                updateMetricsRecords.add(metricsLogRec);
                continue;
            }
            readMetricsRecords.add(metricsLogRec);
        }
        SingleRandomUpdateAndMultipleRandomReadTest.testMetricsLogRecords(updateMetricsRecords, IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, EXPECTED_UPDATE_SIZE, 1000L, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        SingleRandomUpdateAndMultipleRandomReadTest.testMetricsLogRecords(readMetricsRecords, IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, EXPECTED_READ_SIZE, 1000L, 0, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalMetrcisLogRecords = SingleRandomUpdateAndMultipleRandomReadTest.getMetricsTotalLogRecords();
        SingleRandomUpdateAndMultipleRandomReadTest.testTotalMetricsLogRecord(totalMetrcisLogRecords.get(0), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, EXPECTED_UPDATE_SIZE, 1000L, 0);
        SingleRandomUpdateAndMultipleRandomReadTest.testTotalMetricsLogRecord(totalMetrcisLogRecords.get(1), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, EXPECTED_READ_SIZE, 1000L, 0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        String stdOutput = STD_OUTPUT.replaceAll("[\r\n]+", " ");
        SingleRandomUpdateAndMultipleRandomReadTest.testSingleMetricsStdout(stdOutput, IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, EXPECTED_UPDATE_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        SingleRandomUpdateAndMultipleRandomReadTest.testSingleMetricsStdout(stdOutput, IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, EXPECTED_READ_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = SingleRandomUpdateAndMultipleRandomReadTest.getIoTraceLogRecords();
        Assert.assertEquals((String)"There should be 2000 records in the I/O trace log file", (long)2000L, (long)ioTraceRecords.size());
        int i = 0;
        while ((long)i < 2000L) {
            if ((long)i < 1000L) {
                SingleRandomUpdateAndMultipleRandomReadTest.testIoTraceRecord(ioTraceRecords.get(i), IoType.UPDATE.ordinal(), EXPECTED_UPDATE_SIZE);
            } else {
                SingleRandomUpdateAndMultipleRandomReadTest.testIoTraceRecord(ioTraceRecords.get(i), IoType.READ.ordinal(), EXPECTED_READ_SIZE);
            }
            ++i;
        }
    }
}

