/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.ui.log.LogUtil;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TlsAndNodeBalancingTest
extends EnvConfiguredScenarioTestBase {
    private static String STD_OUTPUT;
    private static long ACTUAL_TEST_TIME_MILLISECONDS;
    private static final int EXPECTED_TEST_TIME_MINUTES = 3;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("fs"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_COUNT", Arrays.asList(2));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(100, 1000));
        STEP_ID = TlsAndNodeBalancingTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "ReadUsingInputPath.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        HTTP_STORAGE_NODE_COUNT = 4;
        CONFIG_ARGS.add("--storage-mock-node=true");
        CONFIG_ARGS.add("--storage-net-ssl=true");
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
        STD_OUT_STREAM.startRecording();
        ACTUAL_TEST_TIME_MILLISECONDS = System.currentTimeMillis();
        SCENARIO.run();
        ACTUAL_TEST_TIME_MILLISECONDS = System.currentTimeMillis() - ACTUAL_TEST_TIME_MILLISECONDS;
        LogUtil.flushAll();
        STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testFinishedInTime() {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        Assert.assertEquals((float)(TimeUnit.MINUTES.toMillis(3L) + 10000L), (float)ACTUAL_TEST_TIME_MILLISECONDS, (float)TimeUnit.MINUTES.toMillis(3L));
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> totalMetrcisLogRecords = TlsAndNodeBalancingTest.getMetricsTotalLogRecords();
        TlsAndNodeBalancingTest.testTotalMetricsLogRecord(totalMetrcisLogRecords.get(0), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
        TlsAndNodeBalancingTest.testTotalMetricsLogRecord(totalMetrcisLogRecords.get(1), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 0);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        TlsAndNodeBalancingTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.CREATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        TlsAndNodeBalancingTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.READ, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = TlsAndNodeBalancingTest.getIoTraceLogRecords();
        Object2IntOpenHashMap nodeFreq = new Object2IntOpenHashMap();
        for (CSVRecord ioTraceRecord : ioTraceRecords) {
            TlsAndNodeBalancingTest.testIoTraceRecord(ioTraceRecord, IoType.READ.ordinal(), ITEM_DATA_SIZE);
            String storageNodeAddr = ioTraceRecord.get("StorageNode");
            if (nodeFreq.containsKey((Object)storageNodeAddr)) {
                nodeFreq.put((Object)storageNodeAddr, nodeFreq.getInt((Object)storageNodeAddr) + 1);
                continue;
            }
            nodeFreq.put((Object)storageNodeAddr, 1);
        }
        ObjectSet storageNodeSet = nodeFreq.keySet();
        Assert.assertTrue((storageNodeSet.size() > 0 ? 1 : 0) != 0);
        double expectedAvgPerNode = (double)ioTraceRecords.size() / (double)storageNodeSet.size();
        for (String nextNode : storageNodeSet) {
            Assert.assertEquals((String)("Actual node " + nextNode + " record count: " + nodeFreq.getInt((Object)nextNode) + ", expected: " + expectedAvgPerNode), (double)expectedAvgPerNode, (double)nodeFreq.getInt((Object)nextNode), (double)(expectedAvgPerNode / 1000.0));
        }
    }

    @Test
    public void testTlsEnableLogged() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<String> msgLogLines = TlsAndNodeBalancingTest.getMessageLogLines();
        int msgCount = 0;
        for (String msgLogLine : msgLogLines) {
            if (!msgLogLine.contains(STEP_ID + ": SSL/TLS is enabled for the channel")) continue;
            ++msgCount;
        }
        Assert.assertTrue((3 * STORAGE_DRIVERS_COUNT * CONCURRENCY <= msgCount ? 1 : 0) != 0);
    }
}

