/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.tests.system.base.EnvConfiguredScenarioTestBase;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class UpdateUsingInputFileLimitByTimeTest
extends EnvConfiguredScenarioTestBase {
    private static final int EXPECTED_TIME = 25;
    private static String STD_OUTPUT = null;
    private static String ITEM_OUTPUT_PATH = null;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXCLUDE_PARAMS.clear();
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_TYPE", Arrays.asList("atmos", "swift"));
        EXCLUDE_PARAMS.put("STORAGE_DRIVER_CONCURRENCY", Arrays.asList(1));
        EXCLUDE_PARAMS.put("ITEM_DATA_SIZE", Arrays.asList(new SizeInBytes(0L), new SizeInBytes("10KB"), new SizeInBytes("100MB"), new SizeInBytes("10GB")));
        STEP_ID = UpdateUsingInputFileLimitByTimeTest.class.getSimpleName();
        SCENARIO_PATH = Paths.get(PathUtil.getBaseDir(), "scenario", "systest", "UpdateUsingInputFileLimitByTime.json");
        ThreadContext.put((String)"stepId", (String)STEP_ID);
        EnvConfiguredScenarioTestBase.setUpClass();
        if (SKIP_FLAG) {
            return;
        }
        switch (STORAGE_DRIVER_TYPE) {
            case "fs": {
                ITEM_OUTPUT_PATH = Paths.get(Paths.get(PathUtil.getBaseDir(), new String[0]).getParent().toString(), STEP_ID).toString();
                CONFIG.getItemConfig().getOutputConfig().setPath(ITEM_OUTPUT_PATH);
            }
        }
        try {
            SCENARIO = new JsonScenario(CONFIG, SCENARIO_PATH.toFile());
            STD_OUT_STREAM.startRecording();
            SCENARIO.run();
            STD_OUTPUT = STD_OUT_STREAM.stopRecordingAndGet();
        }
        catch (Throwable t) {
            LogUtil.exception((Level)Level.ERROR, (Throwable)t, (String)"Failed to run the scenario", (Object[])new Object[0]);
        }
        LogUtil.flushAll();
        TimeUnit.SECONDS.sleep(10L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG && "fs".equals(STORAGE_DRIVER_TYPE)) {
            try {
                FileUtils.deleteDirectory((File)new File(ITEM_OUTPUT_PATH));
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        EnvConfiguredScenarioTestBase.tearDownClass();
    }

    @Test
    public void testMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        UpdateUsingInputFileLimitByTimeTest.testMetricsLogRecords(UpdateUsingInputFileLimitByTimeTest.getMetricsLogRecords(), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, 0L, 25, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
    }

    @Test
    public void testTotalMetricsLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        SizeInBytes updateSize = new SizeInBytes(1L, ITEM_DATA_SIZE.get() / 2L + 1L, 1.0);
        UpdateUsingInputFileLimitByTimeTest.testTotalMetricsLogRecord(UpdateUsingInputFileLimitByTimeTest.getMetricsTotalLogRecords().get(0), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, updateSize, 0L, 25);
    }

    @Test
    public void testMetricsStdout() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        UpdateUsingInputFileLimitByTimeTest.testSingleMetricsStdout(STD_OUTPUT.replaceAll("[\r\n]+", " "), IoType.UPDATE, CONCURRENCY, STORAGE_DRIVERS_COUNT, ITEM_DATA_SIZE, CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod());
        UpdateUsingInputFileLimitByTimeTest.testMetricsTableStdout(STD_OUTPUT, STEP_ID, STORAGE_DRIVERS_COUNT, 0L, (Map<IoType, Integer>)new HashMap<IoType, Integer>(){
            {
                this.put(IoType.UPDATE, CONCURRENCY);
            }
        });
    }

    @Test
    public void testIoTraceLogFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        List<CSVRecord> ioTraceRecords = UpdateUsingInputFileLimitByTimeTest.getIoTraceLogRecords();
        Assert.assertTrue((ioTraceRecords.size() > 0 ? 1 : 0) != 0);
        SizeInBytes updateSize = new SizeInBytes(1L, ITEM_DATA_SIZE.get() / 2L + 1L, 1.0);
        for (CSVRecord ioTraceRecord : ioTraceRecords) {
            UpdateUsingInputFileLimitByTimeTest.testIoTraceRecord(ioTraceRecord, IoType.UPDATE.ordinal(), updateSize);
        }
    }

    @Test
    public void testUpdatedItemsListFile() throws Exception {
        Assume.assumeFalse((boolean)SKIP_FLAG);
        ArrayList<CSVRecord> items = new ArrayList<CSVRecord>();
        try (BufferedReader br = new BufferedReader(new FileReader("UpdateUsingInputFileLimitByTimeTest_.csv"));){
            CSVParser csvParser = CSVFormat.RFC4180.parse((Reader)br);
            for (CSVRecord csvRecord : csvParser) {
                items.add(csvRecord);
            }
        }
        int itemIdRadix = CONFIG.getItemConfig().getNamingConfig().getRadix();
        for (CSVRecord itemRec : items) {
            String itemPath = itemRec.get(0);
            String itemId = itemPath.substring(itemPath.lastIndexOf(47) + 1);
            long itemOffset = Long.parseLong(itemRec.get(1), 16);
            Assert.assertEquals((long)Long.parseLong(itemId, itemIdRadix), (long)itemOffset);
            long itemSize = Long.parseLong(itemRec.get(2));
            Assert.assertEquals((long)ITEM_DATA_SIZE.get(), (long)itemSize);
            String[] modLayerAndMask = itemRec.get(3).split("/");
            Assert.assertEquals((String)"Modification record should contain 2 parts", (long)2L, (long)modLayerAndMask.length);
            int layer = Integer.parseInt(modLayerAndMask[0], 16);
            Assert.assertEquals((long)layer, (long)0L);
            String rangesMask = modLayerAndMask[1];
            char[] rangesMaskChars = rangesMask.length() == 0 ? ("00" + rangesMask).toCharArray() : (rangesMask.length() % 2 == 1 ? ("0" + rangesMask).toCharArray() : rangesMask.toCharArray());
            BitSet mask = BitSet.valueOf(Hex.decodeHex((char[])rangesMaskChars));
            Assert.assertTrue((String)("The modification record \"" + itemRec.get(3) + "\" is not updated"), (mask.cardinality() > 0 ? 1 : 0) != 0);
        }
    }
}

