/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system.base;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.concurrent.Daemon;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.storage.driver.builder.StorageDriverBuilderSvc;
import com.emc.mongoose.storage.driver.service.BasicStorageDriverBuilderSvc;
import com.emc.mongoose.storage.mock.api.StorageMock;
import com.emc.mongoose.storage.mock.impl.http.StorageMockFactory;
import com.emc.mongoose.tests.system.base.ConfiguredTestBase;
import com.emc.mongoose.ui.config.item.ItemConfig;
import com.emc.mongoose.ui.config.item.data.input.InputConfig;
import com.emc.mongoose.ui.config.item.naming.NamingConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.driver.DriverConfig;
import com.emc.mongoose.ui.config.storage.mock.MockConfig;
import com.emc.mongoose.ui.config.storage.mock.container.ContainerConfig;
import com.emc.mongoose.ui.config.storage.mock.fail.FailConfig;
import com.emc.mongoose.ui.config.storage.net.NetConfig;
import com.emc.mongoose.ui.config.storage.net.node.NodeConfig;
import com.emc.mongoose.ui.config.test.step.StepConfig;
import com.emc.mongoose.ui.log.Loggers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class EnvConfiguredTestBase
extends ConfiguredTestBase {
    public static final String KEY_ENV_STORAGE_DRIVER_TYPE = "STORAGE_DRIVER_TYPE";
    public static final String KEY_ENV_STORAGE_DRIVER_COUNT = "STORAGE_DRIVER_COUNT";
    public static final String KEY_ENV_STORAGE_DRIVER_CONCURRENCY = "STORAGE_DRIVER_CONCURRENCY";
    public static final String KEY_ENV_ITEM_DATA_SIZE = "ITEM_DATA_SIZE";
    protected static String STORAGE_DRIVER_TYPE = null;
    protected static boolean DISTRIBUTED_MODE_FLAG = false;
    protected static int CONCURRENCY = 0;
    protected static SizeInBytes ITEM_DATA_SIZE = null;
    protected static final Map<String, List<Object>> EXCLUDE_PARAMS = new HashMap<String, List<Object>>();
    protected static boolean SKIP_FLAG = false;
    protected static Map<String, Daemon> HTTP_STORAGE_MOCKS = null;
    protected static int HTTP_STORAGE_NODE_COUNT = 1;
    protected static int STORAGE_DRIVERS_COUNT;
    private static List<StorageDriverBuilderSvc> STORAGE_DRIVER_BUILDER_SVCS;
    protected static final String STORAGE_TYPE_FS = "fs";
    protected static final String STORAGE_TYPE_ATMOS = "atmos";
    protected static final String STORAGE_TYPE_S3 = "s3";
    protected static final String STORAGE_TYPE_SWIFT = "swift";

    @BeforeClass
    public static void setUpClass() throws Exception {
        SKIP_FLAG = false;
        ConfiguredTestBase.setUpClass();
        Map<String, String> env = System.getenv();
        if (!env.containsKey(KEY_ENV_STORAGE_DRIVER_TYPE)) {
            throw new IllegalArgumentException("Environment property w/ name \"STORAGE_DRIVER_TYPE\" is not defined");
        }
        STORAGE_DRIVER_TYPE = System.getenv(KEY_ENV_STORAGE_DRIVER_TYPE);
        EnvConfiguredTestBase.checkExclusionAndSetFlag(KEY_ENV_STORAGE_DRIVER_TYPE, STORAGE_DRIVER_TYPE);
        if (!env.containsKey(KEY_ENV_STORAGE_DRIVER_COUNT)) {
            throw new IllegalArgumentException("Environment property w/ name \"STORAGE_DRIVER_COUNT\" is not defined");
        }
        STORAGE_DRIVERS_COUNT = Integer.parseInt(System.getenv(KEY_ENV_STORAGE_DRIVER_COUNT));
        DISTRIBUTED_MODE_FLAG = STORAGE_DRIVERS_COUNT > 1;
        EnvConfiguredTestBase.checkExclusionAndSetFlag(KEY_ENV_STORAGE_DRIVER_COUNT, DISTRIBUTED_MODE_FLAG);
        if (!env.containsKey(KEY_ENV_STORAGE_DRIVER_CONCURRENCY)) {
            throw new IllegalArgumentException("Environment property w/ name \"STORAGE_DRIVER_CONCURRENCY\" is not defined");
        }
        CONCURRENCY = Integer.parseInt(System.getenv(KEY_ENV_STORAGE_DRIVER_CONCURRENCY));
        EnvConfiguredTestBase.checkExclusionAndSetFlag(KEY_ENV_STORAGE_DRIVER_CONCURRENCY, CONCURRENCY);
        if (!env.containsKey(KEY_ENV_ITEM_DATA_SIZE)) {
            throw new IllegalArgumentException("Environment property w/ name \"ITEM_DATA_SIZE\" is not defined");
        }
        ITEM_DATA_SIZE = new SizeInBytes(System.getenv(KEY_ENV_ITEM_DATA_SIZE));
        EnvConfiguredTestBase.checkExclusionAndSetFlag(KEY_ENV_ITEM_DATA_SIZE, ITEM_DATA_SIZE);
        Loggers.MSG.info("* Storage type:     {}", (Object)STORAGE_DRIVER_TYPE);
        Loggers.MSG.info("* Distributed mode: {}", (Object)DISTRIBUTED_MODE_FLAG);
        Loggers.MSG.info("* Concurrency:      {}", (Object)CONCURRENCY);
        Loggers.MSG.info("* Items size:       {}", (Object)ITEM_DATA_SIZE);
        Loggers.MSG.info("* Excluded:         {}", (Object)SKIP_FLAG);
        if (SKIP_FLAG) {
            return;
        }
        EnvConfiguredTestBase.setUpStorageMockIfNeeded();
        EnvConfiguredTestBase.setUpDistributedModeIfNeeded();
        EnvConfiguredTestBase.setUpConcurrency();
        EnvConfiguredTestBase.setUpItemDataSize();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (!SKIP_FLAG) {
            EnvConfiguredTestBase.tearDownStorageMockIfNeeded();
            EnvConfiguredTestBase.tearDownDistributedModeIfNeeded();
        }
        ConfiguredTestBase.tearDownClass();
    }

    private static void checkExclusionAndSetFlag(String name, Object value) {
        List<Object> excludeParams = EXCLUDE_PARAMS.get(name);
        if (excludeParams != null && !excludeParams.isEmpty()) {
            for (Object nextExcludeParam : excludeParams) {
                if (!nextExcludeParam.equals(value)) continue;
                System.out.println("Test excluded for the " + name + "=" + value);
                SKIP_FLAG = true;
                break;
            }
        }
    }

    private static void setUpStorageMockIfNeeded() throws Exception {
        StorageConfig storageConfig = CONFIG.getStorageConfig();
        storageConfig.getDriverConfig().setType(STORAGE_DRIVER_TYPE);
        switch (STORAGE_DRIVER_TYPE) {
            case "atmos": 
            case "s3": 
            case "swift": {
                HTTP_STORAGE_MOCKS = new HashMap<String, Daemon>();
                NodeConfig nodeConfig = storageConfig.getNetConfig().getNodeConfig();
                ItemConfig itemConfig = CONFIG.getItemConfig();
                StepConfig stepConfig = CONFIG.getTestConfig().getStepConfig();
                int port = nodeConfig.getPort();
                ArrayList<String> nodeAddrs = new ArrayList<String>();
                MockConfig mockConfig = storageConfig.getMockConfig();
                NetConfig netConfig = storageConfig.getNetConfig();
                ContainerConfig containerConfig = mockConfig.getContainerConfig();
                FailConfig failConfig = mockConfig.getFailConfig();
                NamingConfig namingConfig = itemConfig.getNamingConfig();
                InputConfig dataInputConfig = itemConfig.getDataConfig().getInputConfig();
                DataInput dataInput = DataInput.getInstance((String)dataInputConfig.getFile(), (String)dataInputConfig.getSeed(), (SizeInBytes)dataInputConfig.getLayerConfig().getSize(), (int)dataInputConfig.getLayerConfig().getCache());
                for (int i = 0; i < HTTP_STORAGE_NODE_COUNT; ++i) {
                    nodeConfig.setPort(port + i);
                    StorageMockFactory storageMockFactory = new StorageMockFactory(itemConfig.getInputConfig().getFile(), mockConfig.getCapacity(), containerConfig.getCapacity(), containerConfig.getCountLimit(), (int)CONFIG.getOutputConfig().getMetricsConfig().getAverageConfig().getPeriod(), failConfig.getConnections(), failConfig.getResponses(), dataInput, netConfig.getNodeConfig().getPort(), netConfig.getSsl(), (float)CONFIG.getLoadConfig().getRateConfig().getLimit(), namingConfig.getPrefix(), namingConfig.getRadix());
                    StorageMock storageMock = storageMockFactory.newStorageMock();
                    String nextNodeAddr = "127.0.0.1:" + (port + i);
                    storageMock.start();
                    HTTP_STORAGE_MOCKS.put(nextNodeAddr, (Daemon)storageMock);
                    nodeAddrs.add(nextNodeAddr);
                }
                nodeConfig.setAddrs(nodeAddrs);
                nodeConfig.setPort(port);
                break;
            }
        }
    }

    private static void tearDownStorageMockIfNeeded() throws Exception {
        if (HTTP_STORAGE_MOCKS != null) {
            for (Daemon storageMock : HTTP_STORAGE_MOCKS.values()) {
                storageMock.close();
            }
            HTTP_STORAGE_MOCKS.clear();
            HTTP_STORAGE_MOCKS = null;
        }
    }

    private static void setUpDistributedModeIfNeeded() throws Exception {
        if (DISTRIBUTED_MODE_FLAG) {
            STORAGE_DRIVER_BUILDER_SVCS = new ArrayList<StorageDriverBuilderSvc>(STORAGE_DRIVERS_COUNT);
            DriverConfig driverConfig = CONFIG.getStorageConfig().getDriverConfig();
            ArrayList<String> storageDriverAddrs = new ArrayList<String>(STORAGE_DRIVERS_COUNT);
            for (int i = 0; i < STORAGE_DRIVERS_COUNT; ++i) {
                int nextStorageDriverPort = driverConfig.getPort() + i;
                BasicStorageDriverBuilderSvc nextStorageDriverBuilder = new BasicStorageDriverBuilderSvc(nextStorageDriverPort);
                nextStorageDriverBuilder.start();
                STORAGE_DRIVER_BUILDER_SVCS.add((StorageDriverBuilderSvc)nextStorageDriverBuilder);
                storageDriverAddrs.add("127.0.0.1:" + nextStorageDriverPort);
            }
            driverConfig.setAddrs(storageDriverAddrs);
            driverConfig.setRemote(true);
        }
    }

    private static void tearDownDistributedModeIfNeeded() throws Exception {
        if (DISTRIBUTED_MODE_FLAG && STORAGE_DRIVER_BUILDER_SVCS != null) {
            for (StorageDriverBuilderSvc svc : STORAGE_DRIVER_BUILDER_SVCS) {
                svc.close();
            }
            STORAGE_DRIVER_BUILDER_SVCS.clear();
            STORAGE_DRIVER_BUILDER_SVCS = null;
        }
    }

    private static void setUpConcurrency() throws Exception {
        if (CONCURRENCY < 1) {
            throw new IllegalArgumentException("Concurrency level should be an integer > 0");
        }
        CONFIG.getStorageConfig().getDriverConfig().setConcurrency(CONCURRENCY);
    }

    private static void setUpItemDataSize() throws Exception {
        CONFIG.getItemConfig().getDataConfig().setSize(ITEM_DATA_SIZE);
    }

    static {
        STORAGE_DRIVER_BUILDER_SVCS = null;
    }
}

