/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system.base;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.env.DateUtil;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.metrics.logging.MetricsAsciiTableLogMessage;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.tests.system.util.BufferingOutputStream;
import com.emc.mongoose.tests.system.util.LogPatterns;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class LoggingTestBase {
    protected static Logger LOG;
    protected static String STEP_ID;
    protected static BufferingOutputStream STD_OUT_STREAM;
    protected static int LOG_FILE_TIMEOUT_SEC;

    @BeforeClass
    public static void setUpClass() throws Exception {
        FileUtils.deleteDirectory((File)Paths.get(PathUtil.getBaseDir(), "log", STEP_ID).toFile());
        LogUtil.init();
        STEP_ID = ThreadContext.get((String)"stepId");
        STD_OUT_STREAM = new BufferingOutputStream(System.out);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        STD_OUT_STREAM.close();
    }

    private static List<String> getLogFileLines(String fileName) throws IOException {
        File logFile = Paths.get(PathUtil.getBaseDir(), "log", STEP_ID, fileName).toFile();
        try (BufferedReader br = new BufferedReader(new FileReader(logFile));){
            List<String> list = br.lines().collect(Collectors.toList());
            return list;
        }
    }

    protected static List<String> getMessageLogLines() throws IOException {
        return LoggingTestBase.getLogFileLines("messages.log");
    }

    protected static List<String> getErrorsLogLines() throws IOException {
        return LoggingTestBase.getLogFileLines("errors.log");
    }

    protected static List<String> getConfigLogLines() throws IOException {
        return LoggingTestBase.getLogFileLines("config.log");
    }

    protected static List<String> getPartsUploadLogLines() throws IOException {
        return LoggingTestBase.getLogFileLines("parts.upload.csv");
    }

    /*
     * Exception decompiling
     */
    protected static List<CSVRecord> getLogFileCsvRecords(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static List<CSVRecord> getMetricsMedLogRecords() throws IOException {
        return LoggingTestBase.getLogFileCsvRecords("metrics.med.csv");
    }

    protected static List<CSVRecord> getMetricsMedTotalLogRecords() throws IOException {
        return LoggingTestBase.getLogFileCsvRecords("metrics.med.total.csv");
    }

    protected static List<CSVRecord> getMetricsLogRecords() throws IOException {
        return LoggingTestBase.getLogFileCsvRecords("metrics.csv");
    }

    protected static List<CSVRecord> getMetricsTotalLogRecords() throws IOException {
        return LoggingTestBase.getLogFileCsvRecords("metrics.total.csv");
    }

    protected static List<CSVRecord> getIoTraceLogRecords() throws IOException {
        return LoggingTestBase.getLogFileCsvRecords("io.trace.csv");
    }

    protected static List<CSVRecord> getPartsUploadRecords() throws IOException {
        return LoggingTestBase.getLogFileCsvRecords("parts.upload.csv");
    }

    protected static void testMetricsLogRecords(List<CSVRecord> metrics, IoType expectedIoType, int expectedConcurrency, int expectedDriverCount, SizeInBytes expectedItemDataSize, long expectedMaxCount, int expectedLoadJobTime, long metricsPeriodSec) throws Exception {
        int countRecords = metrics.size();
        if (expectedLoadJobTime > 0) {
            Assert.assertEquals((String)("Count of the metrics records: " + countRecords), (float)expectedLoadJobTime, (float)(metricsPeriodSec * (long)countRecords), (float)metricsPeriodSec);
        }
        Date lastTimeStamp = null;
        long prevTotalBytes = Long.MIN_VALUE;
        long prevCountSucc = Long.MIN_VALUE;
        double prevJobDuration = Double.NaN;
        double prevDurationSum = Double.NaN;
        for (CSVRecord nextRecord : metrics) {
            Date nextDateTimeStamp = DateUtil.FMT_DATE_ISO8601.parse(nextRecord.get("DateTimeISO8601"));
            if (lastTimeStamp != null) {
                Assert.assertEquals((String)("Next metrics record is expected to be in " + metricsPeriodSec), (double)metricsPeriodSec, (double)((double)(nextDateTimeStamp.getTime() - lastTimeStamp.getTime()) / 1000.0), (double)((double)metricsPeriodSec / 2.0));
            }
            lastTimeStamp = nextDateTimeStamp;
            String ioTypeStr = nextRecord.get("TypeLoad").toUpperCase();
            Assert.assertEquals((Object)expectedIoType.name(), (Object)ioTypeStr);
            int concurrencyLevel = Integer.parseInt(nextRecord.get("Concurrency"));
            Assert.assertEquals((String)("Expected concurrency level: " + expectedConcurrency), (long)expectedConcurrency, (long)concurrencyLevel);
            int driverCount = Integer.parseInt(nextRecord.get("DriverCount"));
            Assert.assertEquals((String)("Expected driver count: " + driverCount), (long)expectedDriverCount, (long)driverCount);
            long totalBytes = SizeInBytes.toFixedSize((String)nextRecord.get("Size"));
            if (prevTotalBytes == Long.MIN_VALUE) {
                Assert.assertTrue((String)Long.toString(totalBytes), (totalBytes >= 0L ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)Long.toString(totalBytes), (totalBytes >= prevTotalBytes ? 1 : 0) != 0);
            }
            prevTotalBytes = totalBytes;
            long countSucc = Long.parseLong(nextRecord.get("CountSucc"));
            if (prevCountSucc == Long.MIN_VALUE) {
                Assert.assertTrue((String)Long.toString(countSucc), (countSucc >= 0L ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)Long.toString(countSucc), (countSucc >= prevCountSucc ? 1 : 0) != 0);
            }
            if (expectedMaxCount > 0L) {
                Assert.assertTrue((String)Long.toString(countSucc), (countSucc <= expectedMaxCount ? 1 : 0) != 0);
            }
            prevCountSucc = countSucc;
            long countFail = Long.parseLong(nextRecord.get("CountFail"));
            Assert.assertTrue((String)Long.toString(countFail), (countFail < 1L ? 1 : 0) != 0);
            if (countSucc > 0L) {
                long avgItemSize = totalBytes / countSucc;
                if (expectedItemDataSize.getMin() < expectedItemDataSize.getMax()) {
                    Assert.assertTrue((expectedItemDataSize.getMin() <= avgItemSize ? 1 : 0) != 0);
                    Assert.assertTrue((expectedItemDataSize.getMax() >= avgItemSize ? 1 : 0) != 0);
                } else {
                    Assert.assertEquals((String)("Actual average item size: " + avgItemSize), (float)expectedItemDataSize.getAvg(), (float)avgItemSize, (float)(expectedItemDataSize.get() / 100L));
                }
            }
            double jobDuration = Double.parseDouble(nextRecord.get("JobDuration[s]"));
            if (Double.isNaN(prevJobDuration)) {
                Assert.assertEquals((String)Double.toString(jobDuration), (double)0.0, (double)jobDuration, (double)15.0);
            } else {
                Assert.assertEquals((String)Double.toString(jobDuration), (double)(prevJobDuration + (double)metricsPeriodSec), (double)jobDuration, (double)2.0);
            }
            prevJobDuration = jobDuration;
            double durationSum = Double.parseDouble(nextRecord.get("DurationSum[s]"));
            if (Double.isNaN(prevDurationSum)) {
                Assert.assertTrue((durationSum >= 0.0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((durationSum >= prevDurationSum ? 1 : 0) != 0);
                double effEstimate = durationSum / ((double)(concurrencyLevel * driverCount) * jobDuration);
                Assert.assertTrue((String)("Efficiency estimate: " + effEstimate), (effEstimate <= 1.0 && effEstimate >= 0.0 ? 1 : 0) != 0);
            }
            prevDurationSum = durationSum;
            double tpAvg = Double.parseDouble(nextRecord.get("TPAvg[op/s]"));
            double tpLast = Double.parseDouble(nextRecord.get("TPLast[op/s]"));
            double bwAvg = Double.parseDouble(nextRecord.get("BWAvg[MB/s]"));
            double bwLast = Double.parseDouble(nextRecord.get("BWLast[MB/s]"));
            Assert.assertEquals((double)(bwAvg / tpAvg), (double)(bwAvg / tpAvg), (double)(expectedItemDataSize.getAvg() / 100L));
            Assert.assertEquals((double)(bwLast / tpLast), (double)(bwLast / tpLast), (double)(expectedItemDataSize.getAvg() / 100L));
            double durAvg = Double.parseDouble(nextRecord.get("DurationAvg[us]"));
            Assert.assertTrue((durAvg >= 0.0 ? 1 : 0) != 0);
            int durMin = Integer.parseInt(nextRecord.get("DurationMin[us]"));
            Assert.assertTrue((durAvg >= (double)durMin ? 1 : 0) != 0);
            int durLoQ = Integer.parseInt(nextRecord.get("DurationLoQ[us]"));
            Assert.assertTrue((durLoQ >= durMin ? 1 : 0) != 0);
            int durMed = Integer.parseInt(nextRecord.get("DurationMed[us]"));
            Assert.assertTrue((durMed >= durLoQ ? 1 : 0) != 0);
            int durHiQ = Integer.parseInt(nextRecord.get("DurationHiQ[us]"));
            Assert.assertTrue((durHiQ >= durMed ? 1 : 0) != 0);
            int durMax = Integer.parseInt(nextRecord.get("DurationMax[us]"));
            Assert.assertTrue((durMax >= durHiQ ? 1 : 0) != 0);
            double latAvg = Double.parseDouble(nextRecord.get("LatencyAvg[us]"));
            Assert.assertTrue((latAvg >= 0.0 ? 1 : 0) != 0);
            int latMin = Integer.parseInt(nextRecord.get("LatencyMin[us]"));
            Assert.assertTrue((latAvg >= (double)latMin ? 1 : 0) != 0);
            int latLoQ = Integer.parseInt(nextRecord.get("LatencyLoQ[us]"));
            Assert.assertTrue((latLoQ >= latMin ? 1 : 0) != 0);
            int latMed = Integer.parseInt(nextRecord.get("LatencyMed[us]"));
            Assert.assertTrue((latMed >= latLoQ ? 1 : 0) != 0);
            int latHiQ = Integer.parseInt(nextRecord.get("LatencyHiQ[us]"));
            Assert.assertTrue((latHiQ >= latMed ? 1 : 0) != 0);
            int latMax = Integer.parseInt(nextRecord.get("LatencyMax[us]"));
            Assert.assertTrue((latMax >= latHiQ ? 1 : 0) != 0);
        }
    }

    protected static void testTotalMetricsLogRecord(CSVRecord metrics, IoType expectedIoType, int expectedConcurrency, int expectedDriverCount, SizeInBytes expectedItemDataSize, long expectedMaxCount, int expectedLoadJobTime) throws Exception {
        try {
            DateUtil.FMT_DATE_ISO8601.parse(metrics.get("DateTimeISO8601"));
        }
        catch (ParseException e) {
            Assert.fail((String)e.toString());
        }
        String ioTypeStr = metrics.get("TypeLoad").toUpperCase();
        Assert.assertEquals((String)ioTypeStr, (Object)expectedIoType.name(), (Object)ioTypeStr);
        int concurrencyLevel = Integer.parseInt(metrics.get("Concurrency"));
        Assert.assertEquals((String)Integer.toString(concurrencyLevel), (long)expectedConcurrency, (long)concurrencyLevel);
        int driverCount = Integer.parseInt(metrics.get("DriverCount"));
        Assert.assertEquals((String)Integer.toString(driverCount), (long)expectedDriverCount, (long)driverCount);
        long totalBytes = SizeInBytes.toFixedSize((String)metrics.get("Size"));
        if (expectedMaxCount > 0L && expectedItemDataSize.get() > 0L && (IoType.CREATE.equals((Object)expectedIoType) || IoType.READ.equals((Object)expectedIoType) || IoType.UPDATE.equals((Object)expectedIoType))) {
            Assert.assertTrue((String)Long.toString(totalBytes), (totalBytes > 0L ? 1 : 0) != 0);
        }
        long countSucc = Long.parseLong(metrics.get("CountSucc"));
        if (expectedMaxCount > 0L) {
            Assert.assertEquals((long)expectedMaxCount, (long)countSucc);
            Assert.assertTrue((String)Long.toString(countSucc), (countSucc > 0L ? 1 : 0) != 0);
        }
        long countFail = Long.parseLong(metrics.get("CountFail"));
        Assert.assertTrue((String)Long.toString(countFail), (countFail < 1L ? 1 : 0) != 0);
        long avgItemSize = totalBytes / countSucc;
        if (expectedItemDataSize.getMin() < expectedItemDataSize.getMax()) {
            Assert.assertTrue((avgItemSize >= expectedItemDataSize.getMin() ? 1 : 0) != 0);
            Assert.assertTrue((avgItemSize <= expectedItemDataSize.getMax() ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)Long.toString(avgItemSize), (float)expectedItemDataSize.get(), (float)avgItemSize, (float)(expectedItemDataSize.getAvg() / 100L));
        }
        double jobDuration = Double.parseDouble(metrics.get("JobDuration[s]"));
        if (expectedLoadJobTime > 0) {
            Assert.assertEquals((String)Double.toString(jobDuration), (double)expectedLoadJobTime, (double)jobDuration, (double)5.0);
        }
        double durationSum = Double.parseDouble(metrics.get("DurationSum[s]"));
        double effEstimate = durationSum / ((double)(concurrencyLevel * driverCount) * jobDuration);
        Assert.assertTrue((String)Double.toString(effEstimate), (effEstimate <= 1.0 && effEstimate > 0.0 ? 1 : 0) != 0);
        double tpAvg = Double.parseDouble(metrics.get("TPAvg[op/s]"));
        double tpLast = Double.parseDouble(metrics.get("TPLast[op/s]"));
        double bwAvg = Double.parseDouble(metrics.get("BWAvg[MB/s]"));
        double bwLast = Double.parseDouble(metrics.get("BWLast[MB/s]"));
        Assert.assertEquals((double)(bwAvg / tpAvg), (double)(bwAvg / tpAvg), (double)(expectedItemDataSize.getAvg() / 100L));
        Assert.assertEquals((double)(bwLast / tpLast), (double)(bwLast / tpLast), (double)(expectedItemDataSize.getAvg() / 100L));
        double durAvg = Double.parseDouble(metrics.get("DurationAvg[us]"));
        Assert.assertTrue((durAvg >= 0.0 ? 1 : 0) != 0);
        int durMin = Integer.parseInt(metrics.get("DurationMin[us]"));
        Assert.assertTrue((durAvg >= (double)durMin ? 1 : 0) != 0);
        int durLoQ = Integer.parseInt(metrics.get("DurationLoQ[us]"));
        Assert.assertTrue((durLoQ >= durMin ? 1 : 0) != 0);
        int durMed = Integer.parseInt(metrics.get("DurationMed[us]"));
        Assert.assertTrue((durMed >= durLoQ ? 1 : 0) != 0);
        int durHiQ = Integer.parseInt(metrics.get("DurationHiQ[us]"));
        Assert.assertTrue((durHiQ >= durMed ? 1 : 0) != 0);
        int durMax = Integer.parseInt(metrics.get("DurationMax[us]"));
        Assert.assertTrue((durMax >= durHiQ ? 1 : 0) != 0);
        double latAvg = Double.parseDouble(metrics.get("LatencyAvg[us]"));
        Assert.assertTrue((latAvg >= 0.0 ? 1 : 0) != 0);
        int latMin = Integer.parseInt(metrics.get("LatencyMin[us]"));
        Assert.assertTrue((latAvg >= (double)latMin ? 1 : 0) != 0);
        int latLoQ = Integer.parseInt(metrics.get("LatencyLoQ[us]"));
        Assert.assertTrue((latLoQ >= latMin ? 1 : 0) != 0);
        int latMed = Integer.parseInt(metrics.get("LatencyMed[us]"));
        Assert.assertTrue((latMed >= latLoQ ? 1 : 0) != 0);
        int latHiQ = Integer.parseInt(metrics.get("LatencyHiQ[us]"));
        Assert.assertTrue((latHiQ >= latMed ? 1 : 0) != 0);
        int latMax = Integer.parseInt(metrics.get("LatencyMax[us]"));
        Assert.assertTrue((latMax >= latHiQ ? 1 : 0) != 0);
    }

    protected static void testIoTraceRecord(CSVRecord ioTraceRecord, int ioTypeCodeExpected, SizeInBytes sizeExpected) throws Exception {
        Assert.assertEquals((long)ioTypeCodeExpected, (long)Integer.parseInt(ioTraceRecord.get("IoTypeCode")));
        int actualStatusCode = Integer.parseInt(ioTraceRecord.get("StatusCode"));
        if (IoTask.Status.INTERRUPTED.ordinal() == actualStatusCode) {
            return;
        }
        Assert.assertEquals((String)("Actual status code is " + IoTask.Status.values()[actualStatusCode]), (long)IoTask.Status.SUCC.ordinal(), (long)actualStatusCode);
        long duration = Long.parseLong(ioTraceRecord.get("Duration[us]"));
        String latencyStr = ioTraceRecord.get("RespLatency[us]");
        if (latencyStr != null && !latencyStr.isEmpty()) {
            Assert.assertTrue((duration >= Long.parseLong(latencyStr) ? 1 : 0) != 0);
        }
        long size = Long.parseLong(ioTraceRecord.get("TransferSize"));
        if (sizeExpected.getMin() != sizeExpected.getMax()) {
            Assert.assertTrue((String)("Expected the size " + sizeExpected.toString() + ", but got " + size), (sizeExpected.getMin() <= size && size <= sizeExpected.getMax() ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)("Expected the size " + sizeExpected.toString() + " but got " + size), (float)sizeExpected.get(), (float)size, (float)(sizeExpected.get() / 100L));
        }
    }

    protected static void testPartsUploadRecord(List<CSVRecord> recs) throws Exception {
        for (CSVRecord rec : recs) {
            Assert.assertEquals((long)rec.size(), (long)3L);
            String itemPath = rec.get("ItemPath");
            Assert.assertNotNull((Object)itemPath);
            String uploadId = rec.get("UploadId");
            Assert.assertNotNull((Object)uploadId);
            long respLatency = Long.parseLong(rec.get("RespLatency[us]"));
            Assert.assertTrue((respLatency > 0L ? 1 : 0) != 0);
        }
    }

    protected static void testSingleMetricsStdout(String stdOutContent, IoType expectedIoType, int expectedConcurrency, int expectedDriverCount, SizeInBytes expectedItemDataSize, long metricsPeriodSec) throws Exception {
        Date lastTimeStamp = null;
        long prevTotalBytes = Long.MIN_VALUE;
        long prevCountSucc = Long.MIN_VALUE;
        double prevJobDuration = Double.NaN;
        double prevDurationSum = Double.NaN;
        Matcher m = LogPatterns.STD_OUT_METRICS_SINGLE.matcher(stdOutContent);
        while (m.find()) {
            Date nextDateTimeStamp = DateUtil.FMT_DATE_ISO8601.parse(m.group("dateTime"));
            if (lastTimeStamp != null) {
                Assert.assertEquals((double)metricsPeriodSec, (double)((double)(nextDateTimeStamp.getTime() - lastTimeStamp.getTime()) / 1000.0), (double)((double)metricsPeriodSec / 10.0));
            }
            lastTimeStamp = nextDateTimeStamp;
            String ioTypeStr = m.group("typeLoad").toUpperCase();
            Assert.assertEquals((String)ioTypeStr, (Object)expectedIoType.name(), (Object)ioTypeStr);
            int concurrencyLevel = Integer.parseInt(m.group("concurrency"));
            Assert.assertEquals((String)Integer.toString(concurrencyLevel), (long)expectedConcurrency, (long)concurrencyLevel);
            int driverCount = Integer.parseInt(m.group("driverCount"));
            Assert.assertEquals((String)Integer.toString(driverCount), (long)expectedDriverCount, (long)driverCount);
            long totalBytes = SizeInBytes.toFixedSize((String)m.group("size"));
            if (prevTotalBytes == Long.MIN_VALUE) {
                Assert.assertTrue((String)Long.toString(totalBytes), (totalBytes >= 0L ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)Long.toString(totalBytes), (totalBytes >= prevTotalBytes ? 1 : 0) != 0);
            }
            prevTotalBytes = totalBytes;
            long countSucc = Long.parseLong(m.group("countSucc"));
            if (prevCountSucc == Long.MIN_VALUE) {
                Assert.assertTrue((String)Long.toString(countSucc), (countSucc >= 0L ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)Long.toString(countSucc), (countSucc >= prevCountSucc ? 1 : 0) != 0);
            }
            prevCountSucc = countSucc;
            long countFail = Long.parseLong(m.group("countFail"));
            Assert.assertTrue((String)Long.toString(countFail), (countFail < 1L ? 1 : 0) != 0);
            if (countSucc > 0L) {
                long avgItemSize = totalBytes / countSucc;
                Assert.assertEquals((String)Long.toString(avgItemSize), (float)expectedItemDataSize.getAvg(), (float)avgItemSize, (float)(expectedItemDataSize.getAvg() / 100L));
            }
            double jobDuration = Double.parseDouble(m.group("jobDur"));
            if (Double.isNaN(prevJobDuration)) {
                Assert.assertEquals((String)Double.toString(jobDuration), (double)0.0, (double)jobDuration, (double)1.0);
            } else {
                Assert.assertEquals((String)Double.toString(jobDuration), (double)(prevJobDuration + (double)metricsPeriodSec), (double)jobDuration, (double)1.0);
            }
            prevJobDuration = jobDuration;
            double durationSum = Double.parseDouble(m.group("sumDur"));
            if (Double.isNaN(prevDurationSum)) {
                Assert.assertTrue((durationSum >= 0.0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((durationSum >= prevDurationSum ? 1 : 0) != 0);
            }
            double effEstimate = durationSum / ((double)(concurrencyLevel * driverCount) * jobDuration);
            Assert.assertTrue((String)Double.toString(effEstimate), (effEstimate <= 1.0 && effEstimate >= 0.0 ? 1 : 0) != 0);
            prevDurationSum = durationSum;
            double tpAvg = Double.parseDouble(m.group("tpMean"));
            double tpLast = Double.parseDouble(m.group("tpLast"));
            double bwAvg = Double.parseDouble(m.group("bwMean"));
            double bwLast = Double.parseDouble(m.group("bwLast"));
            Assert.assertEquals((double)(bwAvg / tpAvg), (double)(bwAvg / tpAvg), (double)(expectedItemDataSize.getAvg() / 100L));
            Assert.assertEquals((double)(bwLast / tpLast), (double)(bwLast / tpLast), (double)(expectedItemDataSize.getAvg() / 100L));
            double durAvg = Double.parseDouble(m.group("durAvg"));
            Assert.assertTrue((durAvg >= 0.0 ? 1 : 0) != 0);
            int durMin = Integer.parseInt(m.group("durMin"));
            Assert.assertTrue((durAvg >= (double)durMin ? 1 : 0) != 0);
            int durMax = Integer.parseInt(m.group("durMax"));
            Assert.assertTrue(((double)durMax >= durAvg ? 1 : 0) != 0);
            double latAvg = Double.parseDouble(m.group("latAvg"));
            Assert.assertTrue((latAvg >= 0.0 ? 1 : 0) != 0);
            int latMin = Integer.parseInt(m.group("latMin"));
            Assert.assertTrue((latAvg >= (double)latMin ? 1 : 0) != 0);
            int latMax = Integer.parseInt(m.group("latMax"));
            Assert.assertTrue(((double)latMax >= latAvg ? 1 : 0) != 0);
        }
    }

    protected static void testMetricsTableStdout(String stdOutContent, String stepName, int driverCount, long countLimit, Map<IoType, Integer> concurrencyMap) throws Exception {
        Matcher m = LogPatterns.STD_OUT_METRICS_TABLE_ROW.matcher(stdOutContent);
        int rowCount = 0;
        while (m.find()) {
            ++rowCount;
            String actualStepNameEnding = m.group("stepName");
            Date nextTimstamp = DateUtil.FMT_DATE_METRICS_TABLE.parse(m.group("timestamp"));
            IoType actualIoType = IoType.valueOf((String)m.group("ioType"));
            int actualConcurrency = Integer.parseInt(m.group("concurrency"));
            int actualDriverCount = Integer.parseInt(m.group("driverCount"));
            long succCount = Long.parseLong(m.group("succCount"));
            long failCount = Long.parseLong(m.group("failCount"));
            float stepTimeSec = Float.parseFloat(m.group("stepTime"));
            float tp = Float.parseFloat(m.group("tp"));
            float bw = Float.parseFloat(m.group("bw"));
            long lat = Long.parseLong(m.group("lat"));
            long dur = Long.parseLong(m.group("dur"));
            Assert.assertEquals((Object)(stepName.length() > 17 ? stepName.substring(stepName.length() - 17) : stepName), (Object)actualStepNameEnding);
            boolean ioTypeFoundFlag = false;
            for (IoType nextIoType : concurrencyMap.keySet()) {
                if (!nextIoType.equals((Object)actualIoType)) continue;
                ioTypeFoundFlag = true;
                break;
            }
            Assert.assertTrue((String)("I/O type \"" + actualIoType + "\" not found, expected one of: " + Arrays.toString(concurrencyMap.keySet().toArray())), (boolean)ioTypeFoundFlag);
            Assert.assertEquals((long)concurrencyMap.get(actualIoType).intValue(), (long)actualConcurrency);
            Assert.assertEquals((long)driverCount, (long)actualDriverCount);
            if (countLimit > 0L) {
                Assert.assertTrue((countLimit > succCount ? 1 : 0) != 0);
            }
            Assert.assertTrue((failCount == 0L ? 1 : 0) != 0);
            Assert.assertTrue((stepTimeSec >= 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((tp >= 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((bw >= 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((lat >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((lat <= dur ? 1 : 0) != 0);
        }
        Assert.assertTrue((rowCount > 0 ? 1 : 0) != 0);
        int tableHeaderCount = (stdOutContent.length() - stdOutContent.replaceAll(MetricsAsciiTableLogMessage.TABLE_HEADER, "").length()) / MetricsAsciiTableLogMessage.TABLE_HEADER.length();
        if (tableHeaderCount > 0) {
            Assert.assertTrue((rowCount / tableHeaderCount <= 20 ? 1 : 0) != 0);
        }
    }

    static {
        LOG_FILE_TIMEOUT_SEC = 50;
    }
}

