/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system.util;

import com.emc.mongoose.api.common.concurrent.ThreadUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public interface DirWithManyFilesDeleter {
    public static void deleteExternal(String path) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(new String[]{"rm", "-rf", path});
        p.waitFor();
    }

    public static void deleteConcurrently(String path) throws InterruptedException {
        File dir = new File(path);
        File[] files = dir.listFiles();
        int threads = ThreadUtil.getHardwareThreadCount();
        int fileCount = files.length;
        int fileCountPerThread = fileCount / threads;
        int remainingFileCount = fileCount % threads;
        if (fileCountPerThread > 1) {
            int i;
            ExecutorService concurrentDeleteSvc = Executors.newFixedThreadPool(threads);
            for (i = 0; i < threads; ++i) {
                int startOffset = i * fileCountPerThread;
                concurrentDeleteSvc.submit(() -> {
                    for (int j = 0; j < fileCountPerThread; ++j) {
                        files[startOffset + j].delete();
                    }
                });
            }
            concurrentDeleteSvc.shutdown();
            if (remainingFileCount > 0) {
                for (i = 0; i < remainingFileCount; ++i) {
                    files[fileCount - i - 1].delete();
                }
            }
            concurrentDeleteSvc.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        } else {
            for (File file : files) {
                file.delete();
            }
        }
        dir.delete();
    }
}

