/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system.util;

import com.emc.mongoose.api.common.concurrent.ThreadUtil;
import com.emc.mongoose.api.model.NamingThreadFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.junit.Assert;

public interface HttpStorageMockUtil {
    public static final ExecutorService REQ_EXECUTOR = Executors.newFixedThreadPool(ThreadUtil.getHardwareThreadCount(), (ThreadFactory)new NamingThreadFactory("testHttpReqExecutor", true));

    public static void assertItemNotExists(String nodeAddr, String itemPath) throws MalformedURLException, IOException, InterruptedException, ExecutionException {
        Future<Integer> futureRespCode = REQ_EXECUTOR.submit(() -> {
            URL itemUrl = new URL("http://" + nodeAddr + itemPath);
            HttpURLConnection c = (HttpURLConnection)itemUrl.openConnection();
            c.setRequestMethod("GET");
            c.connect();
            try {
                Integer n = c.getResponseCode();
                return n;
            }
            finally {
                c.disconnect();
            }
        });
        Assert.assertEquals((long)404L, (long)futureRespCode.get().intValue());
    }

    public static void assertItemExists(String nodeAddr, String itemPath, long expectedSize) throws MalformedURLException, IOException, InterruptedException, ExecutionException {
        Future<Long> futureContentLen = REQ_EXECUTOR.submit(() -> {
            URL itemUrl = new URL("http://" + nodeAddr + itemPath);
            return itemUrl.openConnection().getContentLength();
        });
        Assert.assertEquals((long)expectedSize, (long)futureContentLen.get());
    }
}

