/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.system.util;

import java.io.IOException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface PortListener {
    public static final String FMT_PATTERN_CONN = "\\s+ESTABLISHED";

    public static Scanner getNetstatOutput() throws IOException {
        String[] netstatCommand = new String[]{"netstat", "-an"};
        Process netstatProcess = Runtime.getRuntime().exec(netstatCommand);
        return new Scanner(netstatProcess.getInputStream(), "IBM850").useDelimiter("\\n");
    }

    public static int getCountConnectionsOnPort(String nodeAddrWithPort) throws IOException {
        int countConnections = 0;
        Pattern patternConn = Pattern.compile(nodeAddrWithPort + FMT_PATTERN_CONN);
        try (Scanner netstatOutputScanner = PortListener.getNetstatOutput();){
            while (netstatOutputScanner.hasNext()) {
                String line = netstatOutputScanner.next();
                Matcher m = patternConn.matcher(line);
                if (!m.find()) continue;
                ++countConnections;
            }
        }
        return countConnections;
    }
}

