/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.unit;

import com.emc.mongoose.api.common.env.DateUtil;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.composite.data.BasicCompositeDataIoTask;
import com.emc.mongoose.api.model.io.task.data.BasicDataIoTask;
import com.emc.mongoose.api.model.io.task.partial.data.PartialDataIoTask;
import com.emc.mongoose.api.model.item.BasicDataItem;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.item.ItemType;
import com.emc.mongoose.api.model.storage.Credential;
import com.emc.mongoose.storage.driver.net.http.amzs3.AmzS3Api;
import com.emc.mongoose.storage.driver.net.http.amzs3.AmzS3StorageDriver;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.auth.AuthConfig;
import com.emc.mongoose.ui.config.storage.net.http.HttpConfig;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.system.SizeInBytes;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AmzS3StorageDriverTest
extends AmzS3StorageDriver {
    private static final String UID = "user1";
    private static final String SECRET = "u5QtPuQx+W5nrrQQEg7nArBqSgC8qLiDt2RhQthb";
    private final Queue<FullHttpRequest> httpRequestsLog = new ArrayDeque<FullHttpRequest>();

    private static Config getConfig() {
        try {
            Config config = Config.loadDefaults();
            StorageConfig storageConfig = config.getStorageConfig();
            HttpConfig httpConfig = storageConfig.getNetConfig().getHttpConfig();
            httpConfig.setNamespace("ns1");
            httpConfig.setFsAccess(true);
            httpConfig.setVersioning(true);
            AuthConfig authConfig = storageConfig.getAuthConfig();
            authConfig.setUid(UID);
            authConfig.setSecret(SECRET);
            return config;
        }
        catch (Throwable cause) {
            throw new RuntimeException(cause);
        }
    }

    public AmzS3StorageDriverTest() throws Exception {
        this(AmzS3StorageDriverTest.getConfig());
    }

    private AmzS3StorageDriverTest(Config config) throws Exception {
        super(config.getTestConfig().getStepConfig().getId(), DataInput.getInstance((String)config.getItemConfig().getDataConfig().getInputConfig().getFile(), (String)config.getItemConfig().getDataConfig().getInputConfig().getSeed(), (SizeInBytes)config.getItemConfig().getDataConfig().getInputConfig().getLayerConfig().getSize(), (int)config.getItemConfig().getDataConfig().getInputConfig().getLayerConfig().getCache()), config.getLoadConfig(), config.getStorageConfig(), config.getItemConfig().getDataConfig().getVerify());
    }

    protected FullHttpResponse executeHttpRequest(FullHttpRequest httpRequest) {
        this.httpRequestsLog.add(httpRequest);
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @After
    public void tearDown() {
        this.httpRequestsLog.clear();
    }

    @Test
    public void testRequestNewPath() throws Exception {
        String bucketName = "/bucket0";
        String result = this.requestNewPath("/bucket0");
        Assert.assertEquals((Object)"/bucket0", (Object)result);
        Assert.assertEquals((long)3L, (long)this.httpRequestsLog.size());
        FullHttpRequest req0 = this.httpRequestsLog.poll();
        Assert.assertEquals((Object)HttpMethod.HEAD, (Object)req0.method());
        Assert.assertEquals((Object)"/bucket0", (Object)req0.uri());
        HttpHeaders reqHeaders0 = req0.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders0.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)0L, (long)reqHeaders0.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Date reqDate0 = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders0.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate0.getTime(), (float)10000.0f);
        String authHeaderValue0 = reqHeaders0.get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        Assert.assertTrue((boolean)authHeaderValue0.startsWith("AWS user1:"));
        FullHttpRequest req1 = this.httpRequestsLog.poll();
        Assert.assertEquals((Object)HttpMethod.GET, (Object)req1.method());
        Assert.assertEquals((Object)"/bucket0?versioning", (Object)req1.uri());
        HttpHeaders reqHeaders1 = req1.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders1.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)0L, (long)reqHeaders1.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Date reqDate1 = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders1.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((String)("Date differs from now " + new Date() + " more than 10 sec: " + reqDate1), (float)new Date().getTime(), (float)reqDate1.getTime(), (float)10000.0f);
        String authHeaderValue1 = reqHeaders1.get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        Assert.assertTrue((boolean)authHeaderValue1.startsWith("AWS user1:"));
        FullHttpRequest req2 = this.httpRequestsLog.poll();
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)req2.method());
        Assert.assertEquals((Object)"/bucket0?versioning", (Object)req2.uri());
        HttpHeaders reqHeaders2 = req2.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders2.get((CharSequence)HttpHeaderNames.HOST));
        Date reqDate2 = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders2.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate2.getTime(), (float)10000.0f);
        String authHeaderValue2 = reqHeaders2.get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        Assert.assertTrue((boolean)authHeaderValue2.startsWith("AWS user1:"));
        byte[] reqContent2 = req2.content().array();
        Assert.assertEquals((Object)AmzS3Api.VERSIONING_ENABLE_CONTENT, (Object)reqContent2);
        Assert.assertEquals((long)reqContent2.length, (long)reqHeaders2.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
    }

    @Test
    public void testBucketListing() throws Exception {
        ItemFactory itemFactory = ItemType.getItemFactory((ItemType)ItemType.DATA);
        String bucketName = "/bucket1";
        String itemPrefix = "0000";
        String markerItemId = "00003brre8lgz";
        Item markerItem = itemFactory.getItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        List items = this.list(itemFactory, "/bucket1", "0000", 36, markerItem, 1000);
        Assert.assertEquals((long)0L, (long)items.size());
        Assert.assertEquals((long)1L, (long)this.httpRequestsLog.size());
        FullHttpRequest httpRequest = this.httpRequestsLog.poll();
        Assert.assertEquals((Object)HttpMethod.GET, (Object)httpRequest.method());
        String reqUri = httpRequest.uri();
        Assert.assertEquals((Object)"/bucket1?prefix=0000&marker=00003brre8lgz&max-keys=1000", (Object)reqUri);
        HttpHeaders httpHeaders = httpRequest.headers();
        Assert.assertEquals((long)0L, (long)httpHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)httpHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(httpHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertTrue((boolean)httpHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
    }

    @Test
    public void testCreateRequest() throws Exception {
        String bucketName = "/bucket2";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/bucket2", Credential.getInstance((String)UID, (String)SECRET), null, 0);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket2/00003brre8lgz", (Object)httpRequest.uri());
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertEquals((long)10240L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("PUT\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + "/bucket2" + '/' + "00003brre8lgz"), (Object)canonicalReq);
    }

    @Test
    public void testCopyRequest() throws Exception {
        String bucketSrcName = "/bucketSrc";
        String bucketDstName = "/bucketDst";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, "/bucketSrc", "/bucketDst", Credential.getInstance((String)UID, (String)SECRET), null, 0);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucketDst/00003brre8lgz", (Object)httpRequest.uri());
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)"/bucketSrc/00003brre8lgz", (Object)reqHeaders.get("x-amz-copy-source"));
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("PUT\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + '\n' + "x-amz-copy-source" + ':' + "/bucketSrc" + '/' + "00003brre8lgz" + '\n' + "/bucketDst" + '/' + "00003brre8lgz"), (Object)canonicalReq);
    }

    @Test
    public void testMpuInitRequest() throws Exception {
        String bucketName = "/bucket3";
        long itemSize = 12345L;
        long partSize = 1234L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 12345L);
        BasicCompositeDataIoTask mpuTask = new BasicCompositeDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/bucket3", Credential.getInstance((String)UID, (String)SECRET), null, 0, 1234L);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)mpuTask, this.storageNodeAddrs[0]);
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)HttpMethod.POST, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket3/00003brre8lgz?uploads", (Object)httpRequest.uri());
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("POST\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + '\n' + "/bucket3" + '/' + "00003brre8lgz" + "?uploads"), (Object)canonicalReq);
    }

    @Test
    public void testMpuCompleteRequest() throws Exception {
        String bucketName = "/bucket3";
        long itemSize = 12345L;
        long partSize = 1234L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 12345L);
        BasicCompositeDataIoTask mpuTask = new BasicCompositeDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/bucket3", Credential.getInstance((String)UID, (String)SECRET), null, 0, 1234L);
        mpuTask.put("uploadId", "qazxswedc");
        List subTasks = mpuTask.getSubTasks();
        for (PartialDataIoTask subTask : subTasks) {
            subTask.startRequest();
            subTask.finishRequest();
            subTask.startResponse();
            subTask.finishResponse();
        }
        Assert.assertTrue((boolean)mpuTask.allSubTasksDone());
        HttpRequest httpRequest = this.getHttpRequest((IoTask)mpuTask, this.storageNodeAddrs[0]);
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)HttpMethod.POST, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket3/00003brre8lgz?uploadId=qazxswedc", (Object)httpRequest.uri());
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        byte[] reqContent = ((FullHttpRequest)httpRequest).content().array();
        int contentLen = reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        Assert.assertTrue((contentLen > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)contentLen, (long)reqContent.length);
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("POST\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + '\n' + "/bucket3" + '/' + "00003brre8lgz" + "?uploadId=qazxswedc"), (Object)canonicalReq);
    }

    @Test
    public void testUploadPartRequest() throws Exception {
        String bucketName = "/bucket4";
        long itemSize = 12345L;
        long partSize = 1234L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 12345L);
        BasicCompositeDataIoTask mpuTask = new BasicCompositeDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/bucket4", Credential.getInstance((String)UID, (String)SECRET), null, 0, 1234L);
        mpuTask.put("uploadId", "vfrtgbnhy");
        List subTasks = mpuTask.getSubTasks();
        int subTasksCount = subTasks.size();
        Assert.assertEquals((long)11L, (long)subTasksCount);
        for (int i = 0; i < subTasksCount; ++i) {
            PartialDataIoTask subTask = (PartialDataIoTask)subTasks.get(i);
            HttpRequest httpRequest = this.getHttpRequest((IoTask)subTask, this.storageNodeAddrs[0]);
            Assert.assertEquals((Object)HttpMethod.PUT, (Object)httpRequest.method());
            Assert.assertEquals((Object)("/bucket4/00003brre8lgz?partNumber=" + (i + 1) + "&uploadId=vfrtgbnhy"), (Object)httpRequest.uri());
            HttpHeaders reqHeaders = httpRequest.headers();
            Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
            Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
            Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
            int contentLen = reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (i == subTasksCount - 1) {
                Assert.assertEquals((long)5L, (long)contentLen);
            } else {
                Assert.assertEquals((long)1234L, (long)contentLen);
            }
            Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
            String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
            Assert.assertEquals((Object)("PUT\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + '\n' + "/bucket4" + '/' + "00003brre8lgz" + "?partNumber=" + (i + 1) + "&uploadId=vfrtgbnhy"), (Object)canonicalReq);
        }
    }

    @Test
    public void testReadRequest() throws Exception {
        String bucketName = "/bucket2";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.READ, (DataItem)dataItem, null, "/bucket2", Credential.getInstance((String)UID, (String)SECRET), null, 0);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.GET, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket2/00003brre8lgz", (Object)httpRequest.uri());
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("GET\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + "/bucket2" + '/' + "00003brre8lgz"), (Object)canonicalReq);
    }

    @Test
    public void testReadFixedRangesRequest() throws Exception {
        String bucketName = "/bucket2";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        ArrayList<Range> fixedRanges = new ArrayList<Range>();
        fixedRanges.add(new Range(0L, 0L, -1L));
        fixedRanges.add(new Range(1L, 1L, -1L));
        fixedRanges.add(new Range(2L, 2L, -1L));
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.READ, (DataItem)dataItem, null, "/bucket2", Credential.getInstance((String)UID, (String)SECRET), fixedRanges, 0);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.GET, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket2/00003brre8lgz", (Object)httpRequest.uri());
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertEquals((Object)"bytes=0-0,1-1,2-2", (Object)reqHeaders.get((CharSequence)HttpHeaderNames.RANGE));
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("GET\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + "/bucket2" + '/' + "00003brre8lgz"), (Object)canonicalReq);
    }

    @Test
    public void testReadRandomRangesRequest() throws Exception {
        int rndRangeCount = 2;
        String bucketName = "/bucket2";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.READ, (DataItem)dataItem, null, "/bucket2", Credential.getInstance((String)UID, (String)SECRET), null, 2);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.GET, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket2/00003brre8lgz", (Object)httpRequest.uri());
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        String rangeHeaderValue = reqHeaders.get((CharSequence)HttpHeaderNames.RANGE);
        Assert.assertTrue((boolean)rangeHeaderValue.startsWith("bytes="));
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String nextRangeValue : rangeHeaderValue.substring(6).split(",")) {
            ranges.add(new Range(nextRangeValue));
        }
        Assert.assertEquals((long)2L, (long)ranges.size());
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("GET\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + "/bucket2" + '/' + "00003brre8lgz"), (Object)canonicalReq);
    }

    @Test
    public void testUpdateRequest() throws Exception {
        String bucketName = "/bucket2";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.UPDATE, (DataItem)dataItem, null, "/bucket2", Credential.getInstance((String)UID, (String)SECRET), null, 0);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket2/00003brre8lgz", (Object)httpRequest.uri());
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertEquals((long)10240L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("PUT\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + "/bucket2" + '/' + "00003brre8lgz"), (Object)canonicalReq);
    }

    @Test
    public void testUpdateFixedRangesRequest() throws Exception {
        String bucketName = "/bucket2";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        ArrayList<Range> fixedRanges = new ArrayList<Range>();
        fixedRanges.add(new Range(0L, 0L, -1L));
        fixedRanges.add(new Range(1L, 1L, -1L));
        fixedRanges.add(new Range(2L, 2L, -1L));
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.UPDATE, (DataItem)dataItem, null, "/bucket2", Credential.getInstance((String)UID, (String)SECRET), fixedRanges, 0);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket2/00003brre8lgz", (Object)httpRequest.uri());
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertEquals((long)3L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertEquals((Object)"bytes=0-0,1-1,2-2", (Object)reqHeaders.get((CharSequence)HttpHeaderNames.RANGE));
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("PUT\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + "/bucket2" + '/' + "00003brre8lgz"), (Object)canonicalReq);
    }

    @Test
    public void testUpdateRandomRangesRequest() throws Exception {
        int rndRangeCount = 2;
        String bucketName = "/bucket2";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.UPDATE, (DataItem)dataItem, null, "/bucket2", Credential.getInstance((String)UID, (String)SECRET), null, 2);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket2/00003brre8lgz", (Object)httpRequest.uri());
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertTrue((0 < reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH) ? 1 : 0) != 0);
        Assert.assertTrue((10240L > (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue() ? 1 : 0) != 0);
        String rangeHeaderValue = reqHeaders.get((CharSequence)HttpHeaderNames.RANGE);
        Assert.assertTrue((boolean)rangeHeaderValue.startsWith("bytes="));
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String nextRangeValue : rangeHeaderValue.substring(6).split(",")) {
            ranges.add(new Range(nextRangeValue));
        }
        Assert.assertEquals((long)2L, (long)ranges.size());
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("PUT\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + "/bucket2" + '/' + "00003brre8lgz"), (Object)canonicalReq);
    }

    @Test
    public void testDeleteRequest() throws Exception {
        String bucketName = "/bucket2";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.DELETE, (DataItem)dataItem, null, "/bucket2", Credential.getInstance((String)UID, (String)SECRET), null, 0);
        HttpRequest httpRequest = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.DELETE, (Object)httpRequest.method());
        Assert.assertEquals((Object)"/bucket2/00003brre8lgz", (Object)httpRequest.uri());
        HttpHeaders reqHeaders = httpRequest.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Date dateHeaderValue = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)dateHeaderValue.getTime(), (float)10000.0f);
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS user1:"));
        String canonicalReq = this.getCanonical(reqHeaders, httpRequest.method(), httpRequest.uri());
        Assert.assertEquals((Object)("DELETE\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + "/bucket2" + '/' + "00003brre8lgz"), (Object)canonicalReq);
    }
}

