/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.unit;

import com.emc.mongoose.api.common.env.DateUtil;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.data.BasicDataIoTask;
import com.emc.mongoose.api.model.item.BasicDataItem;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.storage.Credential;
import com.emc.mongoose.storage.driver.net.http.emc.atmos.AtmosStorageDriver;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.auth.AuthConfig;
import com.emc.mongoose.ui.config.storage.net.http.HttpConfig;
import com.github.akurilov.commons.system.SizeInBytes;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AtmosFsStorageDriverTest
extends AtmosStorageDriver {
    private static final Credential CREDENTIAL = Credential.getInstance((String)"user1", (String)"u5QtPuQx+W5nrrQQEg7nArBqSgC8qLiDt2RhQthb");
    private static final String AUTH_TOKEN = "5cc597535ed747f09b5d273154216339";
    private static final String NS = "ns1";
    private final Queue<FullHttpRequest> httpRequestsLog = new ArrayDeque<FullHttpRequest>();

    private static Config getConfig() {
        try {
            Config config = Config.loadDefaults();
            StorageConfig storageConfig = config.getStorageConfig();
            HttpConfig httpConfig = storageConfig.getNetConfig().getHttpConfig();
            httpConfig.setNamespace(NS);
            httpConfig.setFsAccess(true);
            httpConfig.setVersioning(true);
            AuthConfig authConfig = storageConfig.getAuthConfig();
            authConfig.setUid(CREDENTIAL.getUid());
            authConfig.setToken(AUTH_TOKEN);
            authConfig.setSecret(CREDENTIAL.getSecret());
            return config;
        }
        catch (Throwable cause) {
            throw new RuntimeException(cause);
        }
    }

    public AtmosFsStorageDriverTest() throws Exception {
        this(AtmosFsStorageDriverTest.getConfig());
    }

    private AtmosFsStorageDriverTest(Config config) throws Exception {
        super(config.getTestConfig().getStepConfig().getId(), DataInput.getInstance((String)config.getItemConfig().getDataConfig().getInputConfig().getFile(), (String)config.getItemConfig().getDataConfig().getInputConfig().getSeed(), (SizeInBytes)config.getItemConfig().getDataConfig().getInputConfig().getLayerConfig().getSize(), (int)config.getItemConfig().getDataConfig().getInputConfig().getLayerConfig().getCache()), config.getLoadConfig(), config.getStorageConfig(), config.getItemConfig().getDataConfig().getVerify());
    }

    protected FullHttpResponse executeHttpRequest(FullHttpRequest httpRequest) {
        this.httpRequestsLog.add(httpRequest);
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @After
    public void tearDown() {
        this.httpRequestsLog.clear();
    }

    @Test
    public void testRequestNewAuthToken() throws Exception {
        this.requestNewAuthToken(this.credential);
        Assert.assertEquals((long)1L, (long)this.httpRequestsLog.size());
        FullHttpRequest req = this.httpRequestsLog.poll();
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)req.method());
        Assert.assertEquals((Object)"/rest/subtenant", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)NS, (Object)reqHeaders.get("x-emc-namespace"));
        Assert.assertEquals((Object)this.credential.getUid(), (Object)reqHeaders.get("x-emc-uid"));
        String sig = reqHeaders.get("x-emc-signature");
        Assert.assertTrue((sig != null && sig.length() > 0 ? 1 : 0) != 0);
        String canonicalReq = this.getCanonical(reqHeaders, req.method(), req.uri());
        Assert.assertEquals((Object)("PUT\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + "/rest/subtenant" + "\n" + "x-emc-filesystem-access-enabled" + ":true\n" + "x-emc-namespace" + ':' + NS + '\n' + "x-emc-uid" + ':' + this.credential.getUid()), (Object)canonicalReq);
    }

    @Test
    public void testCreate() throws Exception {
        long itemSize = 10240L;
        String dir = "/dir0";
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/dir0", this.credential, null, 0);
        HttpRequest req = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.POST, (Object)req.method());
        Assert.assertEquals((Object)"/rest/namespace/dir0/00003brre8lgz", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)10240L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)NS, (Object)reqHeaders.get("x-emc-namespace"));
        Assert.assertEquals((Object)("5cc597535ed747f09b5d273154216339/" + this.credential.getUid()), (Object)reqHeaders.get("x-emc-uid"));
        String sig = reqHeaders.get("x-emc-signature");
        Assert.assertTrue((sig != null && sig.length() > 0 ? 1 : 0) != 0);
        String canonicalReq = this.getCanonical(reqHeaders, req.method(), req.uri());
        Assert.assertEquals((Object)("POST\n\n\n" + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + "\n" + req.uri() + "\n" + "x-emc-namespace" + ':' + NS + '\n' + "x-emc-uid" + ':' + AUTH_TOKEN + '/' + this.credential.getUid()), (Object)canonicalReq);
    }
}

