/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.unit;

import com.github.akurilov.commons.io.collection.BufferingInputBase;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class BufferingInputBaseTest {
    @Test
    public final void test0() throws Exception {
        int totalCount = 1234567;
        final AtomicInteger doneCount = new AtomicInteger(0);
        BufferingInputBase<Integer> in = new BufferingInputBase<Integer>(1000){

            protected int loadMoreItems(Integer last) {
                int n;
                for (n = 0; n < this.capacity && doneCount.get() < 1234567; ++n) {
                    this.items.add(doneCount.getAndIncrement());
                }
                return n;
            }
        };
        ArrayList buff = new ArrayList(256);
        int m = 0;
        while (true) {
            int k;
            try {
                k = in.get(buff, 256);
            }
            catch (EOFException e) {
                break;
            }
            Assert.assertEquals((long)k, (long)buff.size());
            buff.clear();
            m += k;
        }
        Assert.assertEquals((long)1234567L, (long)m);
        Assert.assertEquals((long)m, (long)doneCount.get());
    }

    @Test
    public final void test1() throws Exception {
        int totalCount = 10;
        final AtomicInteger doneCount = new AtomicInteger(0);
        BufferingInputBase<Integer> in = new BufferingInputBase<Integer>(1000){

            protected int loadMoreItems(Integer last) {
                int n;
                for (n = 0; n < this.capacity && doneCount.get() < 10; ++n) {
                    this.items.add(doneCount.getAndIncrement());
                }
                return n;
            }
        };
        ArrayList buff2 = new ArrayList(100);
        int m = 0;
        while (true) {
            int k;
            try {
                k = in.get(buff2, 100);
            }
            catch (EOFException e) {
                break;
            }
            Assert.assertEquals((long)k, (long)buff2.size());
            buff2.clear();
            m += k;
        }
        Assert.assertEquals((long)10L, (long)m);
        Assert.assertEquals((long)m, (long)doneCount.get());
    }
}

