/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.unit;

import com.emc.mongoose.api.common.TimeUtil;
import com.emc.mongoose.tests.unit.util.ConfigMatcher;
import com.emc.mongoose.tests.unit.util.ConfigNullMatcher;
import com.emc.mongoose.ui.cli.CliArgParser;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.config.IllegalArgumentNameException;
import com.emc.mongoose.ui.config.item.ItemConfig;
import com.emc.mongoose.ui.config.item.data.DataConfig;
import com.emc.mongoose.ui.config.item.input.InputConfig;
import com.emc.mongoose.ui.config.item.naming.NamingConfig;
import com.emc.mongoose.ui.config.item.output.OutputConfig;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.load.generator.GeneratorConfig;
import com.emc.mongoose.ui.config.output.metrics.MetricsConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.auth.AuthConfig;
import com.emc.mongoose.ui.config.storage.driver.DriverConfig;
import com.emc.mongoose.ui.config.storage.mock.MockConfig;
import com.emc.mongoose.ui.config.storage.mock.container.ContainerConfig;
import com.emc.mongoose.ui.config.storage.net.NetConfig;
import com.emc.mongoose.ui.config.storage.net.http.HttpConfig;
import com.emc.mongoose.ui.config.test.scenario.ScenarioConfig;
import com.emc.mongoose.ui.config.test.step.limit.LimitConfig;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ConfigTest {
    @Test
    public void shouldParseWithoutFireballsThrowing() throws IOException {
        Config config = Config.loadDefaults();
        MatcherAssert.assertThat((Object)config, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)config.getVersion(), ConfigMatcher.equalTo("next", "version"));
        NetConfig netConfig = config.getStorageConfig().getNetConfig();
        MatcherAssert.assertThat((Object)netConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)netConfig.getTimeoutMilliSec(), ConfigMatcher.equalTo(0, "storage.net.timeoutMilliSec"));
        MatcherAssert.assertThat((Object)netConfig.getReuseAddr(), ConfigMatcher.equalTo(true, "storage.net.reuseAddr"));
        MatcherAssert.assertThat((Object)netConfig.getKeepAlive(), ConfigMatcher.equalTo(true, "storage.net.keepAlive"));
        MatcherAssert.assertThat((Object)netConfig.getTcpNoDelay(), ConfigMatcher.equalTo(true, "storage.net.tcpNoDelay"));
        MatcherAssert.assertThat((Object)netConfig.getLinger(), ConfigMatcher.equalTo(0, "storage.net.linger"));
        MatcherAssert.assertThat((Object)netConfig.getBindBacklogSize(), ConfigMatcher.equalTo(0, "storage.net.bindBacklogSize"));
        MatcherAssert.assertThat((Object)netConfig.getInterestOpQueued(), ConfigMatcher.equalTo(false, "storage.net.interestOpQueued"));
        ItemConfig itemConfig = config.getItemConfig();
        MatcherAssert.assertThat((Object)itemConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)itemConfig.getType(), ConfigMatcher.equalTo("data", "item.type"));
        DataConfig dataConfig = itemConfig.getDataConfig();
        MatcherAssert.assertThat((Object)dataConfig, ConfigNullMatcher.notNullValue());
        com.emc.mongoose.ui.config.item.data.input.InputConfig dataInputConfig = dataConfig.getInputConfig();
        MatcherAssert.assertThat((Object)dataInputConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)dataInputConfig.getFile(), ConfigNullMatcher.nullValue("item.data.content.file"));
        MatcherAssert.assertThat((Object)dataInputConfig.getSeed(), ConfigMatcher.equalTo("7a42d9c483244167", "item.data.content.seed"));
        MatcherAssert.assertThat((Object)dataInputConfig.getLayerConfig().getSize(), ConfigMatcher.equalTo(new SizeInBytes("4MB"), "item.data.content.ringSize"));
        MatcherAssert.assertThat((Object)dataConfig.getRangesConfig().getRandom(), ConfigMatcher.equalTo(0, "item.data.ranges.random"));
        MatcherAssert.assertThat((Object)dataConfig.getSize(), ConfigMatcher.equalTo(new SizeInBytes("1MB"), "item.data.size"));
        MatcherAssert.assertThat((Object)dataConfig.getVerify(), ConfigMatcher.equalTo(false, "item.data.verify"));
        InputConfig itemInputConfig = itemConfig.getInputConfig();
        MatcherAssert.assertThat((Object)itemInputConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)itemInputConfig.getPath(), ConfigNullMatcher.nullValue("item.input.path"));
        MatcherAssert.assertThat((Object)itemInputConfig.getFile(), ConfigNullMatcher.nullValue("item.input.file"));
        OutputConfig outputConfig = itemConfig.getOutputConfig();
        MatcherAssert.assertThat((Object)outputConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)outputConfig.getPath(), ConfigNullMatcher.nullValue("item.output.path"));
        MatcherAssert.assertThat((Object)outputConfig.getFile(), ConfigNullMatcher.nullValue("item.output.file"));
        NamingConfig namingConfig = itemConfig.getNamingConfig();
        MatcherAssert.assertThat((Object)namingConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)namingConfig.getType(), ConfigMatcher.equalTo("random", "item.naming.type"));
        MatcherAssert.assertThat((Object)namingConfig.getPrefix(), ConfigNullMatcher.nullValue("item.naming.prefix"));
        MatcherAssert.assertThat((Object)namingConfig.getRadix(), ConfigMatcher.equalTo(36, "item.naming.radix"));
        MatcherAssert.assertThat((Object)namingConfig.getOffset(), ConfigMatcher.equalTo(0L, "item.naming.offset"));
        MatcherAssert.assertThat((Object)namingConfig.getLength(), ConfigMatcher.equalTo(13, "item.naming.length"));
        LoadConfig loadConfig = config.getLoadConfig();
        MatcherAssert.assertThat((Object)loadConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)loadConfig.getGeneratorConfig().getRecycleConfig().getEnabled(), ConfigMatcher.equalTo(false, "load.circular"));
        MatcherAssert.assertThat((Object)loadConfig.getType(), ConfigMatcher.equalTo("create", "load.type"));
        MatcherAssert.assertThat((Object)config.getLoadConfig().getLimitConfig().getConcurrency(), ConfigMatcher.equalTo(1, "load.concurrency"));
        LimitConfig limitConfig = config.getTestConfig().getStepConfig().getLimitConfig();
        MatcherAssert.assertThat((Object)limitConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)limitConfig.getCount(), ConfigMatcher.equalTo(0L, "load.limit.count"));
        MatcherAssert.assertThat((Object)loadConfig.getLimitConfig().getRate(), ConfigMatcher.equalTo(0.0, "load.limit.rate"));
        MatcherAssert.assertThat((Object)limitConfig.getSize(), ConfigMatcher.equalTo(new SizeInBytes(0L), "load.limit.size"));
        String timeTestValue = "0s";
        MatcherAssert.assertThat((Object)limitConfig.getTime(), ConfigMatcher.equalTo(TimeUtil.getTimeUnit((String)"0s").toSeconds(TimeUtil.getTimeValue((String)"0s")), "load.limit.time"));
        GeneratorConfig generatorConfig = loadConfig.getGeneratorConfig();
        MatcherAssert.assertThat((Object)generatorConfig.getRemote(), ConfigMatcher.equalTo(false, "load.generator.remote"));
        MatcherAssert.assertThat(generatorConfig.getAddrs().get(0), ConfigMatcher.equalTo("127.0.0.1", "load.generator.addrs"));
        MetricsConfig metricsConfig = config.getOutputConfig().getMetricsConfig();
        MatcherAssert.assertThat((Object)metricsConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)metricsConfig.getThreshold(), ConfigMatcher.equalTo(0.0, "load.metrics.intermediate"));
        String periodTestValue = "10s";
        MatcherAssert.assertThat((Object)metricsConfig.getAverageConfig().getPeriod(), ConfigMatcher.equalTo(TimeUtil.getTimeUnit((String)"10s").toSeconds(TimeUtil.getTimeValue((String)"10s")), "load.metrics.period"));
        ScenarioConfig scenarioConfig = config.getTestConfig().getScenarioConfig();
        MatcherAssert.assertThat((Object)scenarioConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)scenarioConfig.getFile(), ConfigNullMatcher.nullValue("run.file"));
        StorageConfig storageConfig = config.getStorageConfig();
        MatcherAssert.assertThat((Object)storageConfig, ConfigNullMatcher.notNullValue());
        AuthConfig authConfig = storageConfig.getAuthConfig();
        MatcherAssert.assertThat((Object)authConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)authConfig.getUid(), ConfigNullMatcher.nullValue("storage.auth.uid"));
        MatcherAssert.assertThat((Object)authConfig.getSecret(), ConfigNullMatcher.nullValue("storage.auth.secret"));
        MatcherAssert.assertThat((Object)authConfig.getToken(), ConfigNullMatcher.nullValue("storage.auth.token"));
        HttpConfig httpConfig = storageConfig.getNetConfig().getHttpConfig();
        MatcherAssert.assertThat((Object)httpConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)httpConfig.getFsAccess(), ConfigMatcher.equalTo(false, "storage.net.http.fsAccess"));
        Map headers = httpConfig.getHeaders();
        MatcherAssert.assertThat((Object)headers, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)headers.containsKey("Connection"), ConfigMatcher.equalTo(true, "storage.net.http.headers[Connection]"));
        MatcherAssert.assertThat(headers.get("Connection"), ConfigMatcher.equalTo("Keep-Alive", "storage.net.http.headers[Connection]"));
        MatcherAssert.assertThat((Object)headers.containsKey("User-Agent"), ConfigMatcher.equalTo(true, "storage.net.http.headers[User-Agent]"));
        MatcherAssert.assertThat(headers.get("User-Agent"), ConfigMatcher.equalTo("mongoose/next", "storage.net.http.headers[User-Agent]"));
        MatcherAssert.assertThat((Object)httpConfig.getNamespace(), ConfigNullMatcher.nullValue("storage.net.http.namespace"));
        MatcherAssert.assertThat((Object)httpConfig.getVersioning(), ConfigMatcher.equalTo(false, "storage.net.http.versioning"));
        MatcherAssert.assertThat(storageConfig.getNetConfig().getNodeConfig().getAddrs().get(0), ConfigMatcher.equalTo("127.0.0.1", "storage.net.node.addrs"));
        DriverConfig driverConfig = storageConfig.getDriverConfig();
        MatcherAssert.assertThat((Object)storageConfig.getNetConfig().getSsl(), ConfigMatcher.equalTo(false, "storage.driver.remote"));
        MatcherAssert.assertThat(driverConfig.getAddrs().get(0), ConfigMatcher.equalTo("127.0.0.1", "storage.driver.addrs"));
        MatcherAssert.assertThat((Object)storageConfig.getNetConfig().getNodeConfig().getPort(), ConfigMatcher.equalTo(9020, "storage.port"));
        MatcherAssert.assertThat((Object)storageConfig.getNetConfig().getSsl(), ConfigMatcher.equalTo(false, "storage.net.ssl."));
        MockConfig mockConfig = storageConfig.getMockConfig();
        MatcherAssert.assertThat((Object)mockConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)mockConfig.getCapacity(), ConfigMatcher.equalTo(1000000, "storage.mock.capacity"));
        MatcherAssert.assertThat((Object)mockConfig.getNode(), ConfigMatcher.equalTo(false, "storage.mock.node"));
        ContainerConfig containerConfig = mockConfig.getContainerConfig();
        MatcherAssert.assertThat((Object)containerConfig, ConfigNullMatcher.notNullValue());
        MatcherAssert.assertThat((Object)containerConfig.getCapacity(), ConfigMatcher.equalTo(1000000, "storage.mock.container.capacity"));
        MatcherAssert.assertThat((Object)containerConfig.getCountLimit(), ConfigMatcher.equalTo(1000000, "storage.mock.container.countLimit"));
    }

    @Test
    public void testApply() throws Exception {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        argsMap.put("--test-step-id", "goose");
        argsMap.put("--version", "1.2.5.10");
        argsMap.put("--item-data-input-layer-size", "16MB");
        argsMap.put("--item-data-ranges-random", "1");
        argsMap.put("--test-step-limit-count", "1000");
        argsMap.put("--load-rate-limit", "12.345");
        argsMap.put("--test-step-limit-size", "321KB");
        argsMap.put("--test-step-limit-time", "5m");
        argsMap.put("--storage-net-timeoutMilliSec", "123456");
        argsMap.put("--storage-net-reuseAddr", "true");
        argsMap.put("--storage-net-tcpNoDelay", "false");
        argsMap.put("--storage-net-interestOpQueued", null);
        argsMap.put("--storage-net-node-addrs", "10.123.45.67,10.123.45.68,10.123.45.69,10.123.45.70");
        argsMap.put("--storage-net-http-fsAccess", "true");
        argsMap.put("--storage-net-http-headers", "customHeaderName:customHeaderValue");
        ArrayList<String> args = new ArrayList<String>();
        for (String argName : argsMap.keySet()) {
            String t = (String)argsMap.get(argName);
            if (t == null) {
                args.add(argName);
                continue;
            }
            args.add(argName + '=' + (String)argsMap.get(argName));
        }
        Map argTree = CliArgParser.parseArgs(null, (String[])args.toArray(new String[0]));
        Config config = Config.loadDefaults();
        config.apply(argTree, null);
        TestCase.assertEquals((String)((String)argsMap.get("--version")), (String)config.getVersion());
        NetConfig netConfig = config.getStorageConfig().getNetConfig();
        TestCase.assertEquals((int)Integer.parseInt((String)argsMap.get("--storage-net-timeoutMilliSec")), (int)netConfig.getTimeoutMilliSec());
        TestCase.assertEquals((boolean)true, (boolean)netConfig.getReuseAddr());
        TestCase.assertEquals((boolean)false, (boolean)netConfig.getTcpNoDelay());
        TestCase.assertEquals((boolean)true, (boolean)netConfig.getInterestOpQueued());
        DataConfig dataConfig = config.getItemConfig().getDataConfig();
        TestCase.assertEquals((String)"16MB", (String)dataConfig.getInputConfig().getLayerConfig().getSize().toString());
        TestCase.assertEquals((int)1, (int)dataConfig.getRangesConfig().getRandom());
        LimitConfig limitConfig = config.getTestConfig().getStepConfig().getLimitConfig();
        TestCase.assertEquals((long)1000L, (long)limitConfig.getCount());
        TestCase.assertEquals((Object)12.345, (Object)config.getLoadConfig().getLimitConfig().getRate());
        TestCase.assertEquals((String)"321KB", (String)limitConfig.getSize().toString());
        TestCase.assertEquals((long)300L, (long)limitConfig.getTime());
        TestCase.assertEquals((int)4, (int)netConfig.getNodeConfig().getAddrs().size());
        TestCase.assertEquals((boolean)true, (boolean)netConfig.getHttpConfig().getFsAccess());
        TestCase.assertEquals((String)"customHeaderValue", (String)((String)netConfig.getHttpConfig().getHeaders().get("customHeaderName")));
    }

    @Test
    public void testInvalidSizeValue() throws Exception {
        Config config = Config.loadDefaults();
        try {
            config.apply((Map)new HashMap<String, Object>(){
                {
                    this.put("item", new HashMap<String, Object>(){
                        {
                            this.put("data", new HashMap<String, Object>(){
                                {
                                    this.put("size", "invalidSizeValue");
                                }
                            });
                        }
                    });
                }
            }, null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidTimeValue() throws Exception {
        Config config = Config.loadDefaults();
        try {
            config.apply((Map)new HashMap<String, Object>(){
                {
                    this.put("test", new HashMap<String, Object>(){
                        {
                            this.put("step", new HashMap<String, Object>(){
                                {
                                    this.put("limit", new HashMap<String, Object>(){
                                        {
                                            this.put("time", "100500y");
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            }, null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidRangesValue() throws Exception {
        Config config = Config.loadDefaults();
        try {
            config.apply((Map)new HashMap<String, Object>(){
                {
                    this.put("item", new HashMap<String, Object>(){
                        {
                            this.put("data", new HashMap<String, Object>(){
                                {
                                    this.put("ranges", new HashMap<String, Object>(){
                                        {
                                            this.put("random", "nope");
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            }, null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidInteger() throws Exception {
        Config config = Config.loadDefaults();
        try {
            config.apply((Map)new HashMap<String, Object>(){
                {
                    this.put("test", new HashMap<String, Object>(){
                        {
                            this.put("step", new HashMap<String, Object>(){
                                {
                                    this.put("limit", new HashMap<String, Object>(){
                                        {
                                            this.put("count", "nope");
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            }, null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNoSuchArgName() throws Exception {
        Config config = Config.loadDefaults();
        try {
            config.apply((Map)new HashMap<String, Object>(){
                {
                    this.put("storage", new HashMap<String, Object>(){
                        {
                            this.put("driver", new HashMap<String, Object>(){
                                {
                                    this.put("blabla", "123");
                                }
                            });
                        }
                    });
                }
            }, null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentNameException e) {
            Assert.assertEquals((Object)"--storage-driver-blabla", (Object)e.getMessage());
        }
    }
}

