/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.unit;

import com.emc.mongoose.api.common.env.DateUtil;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.data.BasicDataIoTask;
import com.emc.mongoose.api.model.item.BasicDataItem;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.storage.Credential;
import com.emc.mongoose.storage.driver.net.http.emc.s3.EmcS3StorageDriver;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.auth.AuthConfig;
import com.emc.mongoose.ui.config.storage.net.http.HttpConfig;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.system.SizeInBytes;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.junit.Assert;
import org.junit.Test;

public class EmcS3StorageDriverTest
extends EmcS3StorageDriver {
    private static final Credential CREDENTIAL = Credential.getInstance((String)"user1", (String)"u5QtPuQx+W5nrrQQEg7nArBqSgC8qLiDt2RhQthb");
    private static final String NS = "ns1";
    private static final ThreadLocal<MessageDigest> MD5_DIGEST = ThreadLocal.withInitial(DigestUtils::getMd5Digest);

    private static Config getConfig() {
        try {
            Config config = Config.loadDefaults();
            StorageConfig storageConfig = config.getStorageConfig();
            HttpConfig httpConfig = storageConfig.getNetConfig().getHttpConfig();
            httpConfig.setNamespace(NS);
            httpConfig.setFsAccess(true);
            httpConfig.setVersioning(true);
            AuthConfig authConfig = storageConfig.getAuthConfig();
            authConfig.setUid(CREDENTIAL.getUid());
            authConfig.setSecret(CREDENTIAL.getSecret());
            return config;
        }
        catch (Throwable cause) {
            throw new RuntimeException(cause);
        }
    }

    public EmcS3StorageDriverTest() throws Exception {
        this(EmcS3StorageDriverTest.getConfig());
    }

    private EmcS3StorageDriverTest(Config config) throws Exception {
        super(config.getTestConfig().getStepConfig().getId(), DataInput.getInstance((String)config.getItemConfig().getDataConfig().getInputConfig().getFile(), (String)config.getItemConfig().getDataConfig().getInputConfig().getSeed(), (SizeInBytes)config.getItemConfig().getDataConfig().getInputConfig().getLayerConfig().getSize(), (int)config.getItemConfig().getDataConfig().getInputConfig().getLayerConfig().getCache()), config.getLoadConfig(), config.getStorageConfig(), config.getItemConfig().getDataConfig().getVerify());
    }

    protected FullHttpResponse executeHttpRequest(FullHttpRequest httpRequest) {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @Test
    public void testConcatRequest() throws Exception {
        String srcBucketName = "srcBucket";
        long itemSize = 10240L;
        int srcItemsCount = 10;
        ArrayList<BasicDataItem> srcItems = new ArrayList<BasicDataItem>(10);
        for (int i = 0; i < 10; ++i) {
            String srcItemId = "000000000000" + i;
            srcItems.add(new BasicDataItem("/srcBucket/" + srcItemId, Long.parseLong(srcItemId, 36), 10240L));
        }
        String dstBucketName = "dstBucket";
        String dstItemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 0L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/dstBucket", this.credential, null, 0, srcItems);
        HttpRequest req = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertTrue((boolean)(req instanceof FullHttpRequest));
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)req.method());
        Assert.assertEquals((Object)"/dstBucket/00003brre8lgz", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        int contentLen = reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)NS, (Object)reqHeaders.get("x-emc-namespace"));
        Assert.assertEquals((Object)HttpHeaderValues.APPLICATION_JSON.toString(), (Object)reqHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        Assert.assertEquals((Object)"true", (Object)reqHeaders.get("x-emc-multipart-copy"));
        Assert.assertEquals((Object)NS, (Object)reqHeaders.get("x-emc-namespace"));
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS " + this.credential.getUid() + ":"));
        String contentMd5 = reqHeaders.get((CharSequence)HttpHeaderNames.CONTENT_MD5);
        String canonicalReq = this.getCanonical(reqHeaders, req.method(), req.uri());
        Assert.assertEquals((Object)("PUT\n" + contentMd5 + '\n' + HttpHeaderValues.APPLICATION_JSON + '\n' + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + '\n' + "x-emc-multipart-copy" + ":true\n" + "x-emc-namespace" + ':' + NS + '\n' + '/' + "dstBucket" + '/' + "00003brre8lgz"), (Object)canonicalReq);
        byte[] contentBytes = ((FullHttpRequest)req).content().array();
        Assert.assertEquals((long)contentLen, (long)contentBytes.length);
        MessageDigest md5Digest = MD5_DIGEST.get();
        md5Digest.reset();
        byte[] contentMd5Bytes = md5Digest.digest(contentBytes);
        String contentMd5EncodedHash = new String(Base64.encodeBase64((byte[])contentMd5Bytes));
        Assert.assertEquals((Object)contentMd5, (Object)contentMd5EncodedHash);
        String contentStr = new String(contentBytes, StandardCharsets.US_ASCII);
        for (DataItem dataItem2 : srcItems) {
            Assert.assertTrue((boolean)contentStr.contains("\"path\": \"" + dataItem2.getName().substring(1) + "\""));
        }
    }

    @Test
    public void testConcatFixedRangesRequest() throws Exception {
        String srcBucketName = "srcBucket";
        long itemSize = 10240L;
        int srcItemsCount = 10;
        ArrayList<BasicDataItem> srcItems = new ArrayList<BasicDataItem>(10);
        for (int i = 0; i < 10; ++i) {
            String srcItemId = "000000000000" + i;
            srcItems.add(new BasicDataItem("/srcBucket/" + srcItemId, Long.parseLong(srcItemId, 36), 10240L));
        }
        ArrayList<Range> fixedRanges = new ArrayList<Range>(10);
        for (int i = 0; i < 10; ++i) {
            fixedRanges.add(new Range((long)(i * 1000), (long)(i * 1000 + 100), -1L));
        }
        String dstBucketName = "dstBucket";
        String dstItemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 0L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/dstBucket", this.credential, fixedRanges, 0, srcItems);
        HttpRequest req = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertTrue((boolean)(req instanceof FullHttpRequest));
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)req.method());
        Assert.assertEquals((Object)"/dstBucket/00003brre8lgz", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        int contentLen = reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)NS, (Object)reqHeaders.get("x-emc-namespace"));
        Assert.assertEquals((Object)HttpHeaderValues.APPLICATION_JSON.toString(), (Object)reqHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        Assert.assertEquals((Object)"true", (Object)reqHeaders.get("x-emc-multipart-copy"));
        Assert.assertEquals((Object)NS, (Object)reqHeaders.get("x-emc-namespace"));
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS " + this.credential.getUid() + ":"));
        String contentMd5 = reqHeaders.get((CharSequence)HttpHeaderNames.CONTENT_MD5);
        String canonicalReq = this.getCanonical(reqHeaders, req.method(), req.uri());
        Assert.assertEquals((Object)("PUT\n" + contentMd5 + '\n' + HttpHeaderValues.APPLICATION_JSON + '\n' + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + '\n' + "x-emc-multipart-copy" + ":true\n" + "x-emc-namespace" + ':' + NS + '\n' + '/' + "dstBucket" + '/' + "00003brre8lgz"), (Object)canonicalReq);
        byte[] contentBytes = ((FullHttpRequest)req).content().array();
        Assert.assertEquals((long)contentLen, (long)contentBytes.length);
        MessageDigest md5Digest = MD5_DIGEST.get();
        md5Digest.reset();
        byte[] contentMd5Bytes = md5Digest.digest(contentBytes);
        String contentMd5EncodedHash = new String(Base64.encodeBase64((byte[])contentMd5Bytes));
        Assert.assertEquals((Object)contentMd5, (Object)contentMd5EncodedHash);
        String contentStr = new String(contentBytes, StandardCharsets.US_ASCII);
        StringBuilder strb = new StringBuilder();
        EmcS3StorageDriverTest.rangeListToStringBuff(fixedRanges, (long)dataItem.size(), (StringBuilder)strb);
        Pattern rangesRegex = Pattern.compile("\"range\":\\s\"" + strb.toString() + "\"");
        Matcher m = rangesRegex.matcher(contentStr);
        for (DataItem dataItem2 : srcItems) {
            Assert.assertTrue((boolean)contentStr.contains("\"path\": \"" + dataItem2.getName().substring(1) + "\""));
            Assert.assertTrue((boolean)m.find());
        }
    }

    @Test
    public void testConcatRandomRangesRequest() throws Exception {
        String srcBucketName = "srcBucket";
        long itemSize = 10240L;
        int srcItemsCount = 10;
        ArrayList<BasicDataItem> srcItems = new ArrayList<BasicDataItem>(10);
        for (int i = 0; i < 10; ++i) {
            String srcItemId = "000000000000" + i;
            srcItems.add(new BasicDataItem("/srcBucket/" + srcItemId, Long.parseLong(srcItemId, 36), 10240L));
        }
        String dstBucketName = "dstBucket";
        String dstItemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 0L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/dstBucket", this.credential, null, 10, srcItems);
        HttpRequest req = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertTrue((boolean)(req instanceof FullHttpRequest));
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)req.method());
        Assert.assertEquals((Object)"/dstBucket/00003brre8lgz", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        int contentLen = reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)NS, (Object)reqHeaders.get("x-emc-namespace"));
        Assert.assertEquals((Object)HttpHeaderValues.APPLICATION_JSON.toString(), (Object)reqHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        Assert.assertEquals((Object)"true", (Object)reqHeaders.get("x-emc-multipart-copy"));
        Assert.assertEquals((Object)NS, (Object)reqHeaders.get("x-emc-namespace"));
        Assert.assertTrue((boolean)reqHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION).startsWith("AWS " + this.credential.getUid() + ":"));
        String contentMd5 = reqHeaders.get((CharSequence)HttpHeaderNames.CONTENT_MD5);
        String canonicalReq = this.getCanonical(reqHeaders, req.method(), req.uri());
        Assert.assertEquals((Object)("PUT\n" + contentMd5 + '\n' + HttpHeaderValues.APPLICATION_JSON + '\n' + reqHeaders.get((CharSequence)HttpHeaderNames.DATE) + '\n' + "x-emc-multipart-copy" + ":true\n" + "x-emc-namespace" + ':' + NS + '\n' + '/' + "dstBucket" + '/' + "00003brre8lgz"), (Object)canonicalReq);
        byte[] contentBytes = ((FullHttpRequest)req).content().array();
        Assert.assertEquals((long)contentLen, (long)contentBytes.length);
        MessageDigest md5Digest = MD5_DIGEST.get();
        md5Digest.reset();
        byte[] contentMd5Bytes = md5Digest.digest(contentBytes);
        String contentMd5EncodedHash = new String(Base64.encodeBase64((byte[])contentMd5Bytes));
        Assert.assertEquals((Object)contentMd5, (Object)contentMd5EncodedHash);
        String contentStr = new String(contentBytes, StandardCharsets.US_ASCII);
        Pattern rangesRegex = Pattern.compile("\"range\":\\s\"([0-9]+-[0-9]+,){9}[0-9]+-[0-9]+\"");
        Matcher m = rangesRegex.matcher(contentStr);
        for (DataItem dataItem2 : srcItems) {
            Assert.assertTrue((boolean)contentStr.contains("\"path\": \"" + dataItem2.getName().substring(1) + "\""));
            Assert.assertTrue((boolean)m.find());
        }
    }
}

