/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.unit;

import com.emc.mongoose.api.model.item.BasicDataItem;
import com.emc.mongoose.api.model.item.BasicItemFactory;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.storage.driver.nio.fs.FileStorageDriver;
import com.github.akurilov.commons.math.Random;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class FileStorageDriverTest {
    private static Path TMP_DIR_PATH = null;

    @BeforeClass
    public static void setUpClass() throws Exception {
        try {
            TMP_DIR_PATH = Files.createTempDirectory(null, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (TMP_DIR_PATH != null) {
            try {
                FileUtils.deleteDirectory((File)TMP_DIR_PATH.toFile());
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            TMP_DIR_PATH = null;
        }
    }

    @Test
    @Ignore
    public final void testList() throws Exception {
        String prefix = "yohoho";
        int count = 1000;
        for (int i = 0; i < 1000; ++i) {
            if (i < 10) {
                new File(TMP_DIR_PATH.toString() + File.separatorChar + "yohoho" + "000" + Integer.toString(i)).createNewFile();
                continue;
            }
            if (i < 100) {
                new File(TMP_DIR_PATH.toString() + File.separatorChar + "yohoho" + "00" + Integer.toString(i)).createNewFile();
                continue;
            }
            if (i >= 1000) continue;
            new File(TMP_DIR_PATH.toString() + File.separatorChar + "yohoho" + "0" + Integer.toString(i)).createNewFile();
        }
        Random rnd = new Random();
        for (int i = 0; i < 1000; ++i) {
            new File(TMP_DIR_PATH.toString() + File.separatorChar + Integer.toString(rnd.nextInt())).createNewFile();
        }
        List items = FileStorageDriver._list((ItemFactory)new BasicItemFactory(), (String)TMP_DIR_PATH.toString(), (String)"yohoho", (int)10, (Item)new BasicDataItem("yohoho0099", 0L, 0L), (int)1000);
        Assert.assertEquals((String)Integer.toString(items.size()), (long)99L, (long)items.size());
        items = FileStorageDriver._list((ItemFactory)new BasicItemFactory(), (String)TMP_DIR_PATH.toString(), (String)"yohoho", (int)10, null, (int)100);
        Assert.assertEquals((long)100L, (long)items.size());
        items = FileStorageDriver._list((ItemFactory)new BasicItemFactory(), (String)TMP_DIR_PATH.toString(), null, (int)10, null, (int)2000);
        Assert.assertEquals((long)2000L, (long)items.size());
    }
}

