/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.unit;

import com.emc.mongoose.api.common.env.DateUtil;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.composite.data.BasicCompositeDataIoTask;
import com.emc.mongoose.api.model.io.task.data.BasicDataIoTask;
import com.emc.mongoose.api.model.io.task.partial.data.PartialDataIoTask;
import com.emc.mongoose.api.model.item.BasicDataItem;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.item.ItemType;
import com.emc.mongoose.api.model.storage.Credential;
import com.emc.mongoose.storage.driver.net.http.swift.SwiftStorageDriver;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.auth.AuthConfig;
import com.emc.mongoose.ui.config.storage.net.http.HttpConfig;
import com.github.akurilov.commons.system.SizeInBytes;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SwiftStorageDriverTest
extends SwiftStorageDriver {
    private static final Credential CREDENTIAL = Credential.getInstance((String)"user1", (String)"u5QtPuQx+W5nrrQQEg7nArBqSgC8qLiDt2RhQthb");
    private static final String AUTH_TOKEN = "AUTH_tk65840af9f6f74d1aaefac978cb8f0899";
    private static final String NS = "ns1";
    private final Queue<FullHttpRequest> httpRequestsLog = new ArrayDeque<FullHttpRequest>();

    private static Config getConfig() {
        try {
            Config config = Config.loadDefaults();
            StorageConfig storageConfig = config.getStorageConfig();
            HttpConfig httpConfig = storageConfig.getNetConfig().getHttpConfig();
            httpConfig.setNamespace(NS);
            httpConfig.setFsAccess(true);
            httpConfig.setVersioning(true);
            AuthConfig authConfig = storageConfig.getAuthConfig();
            authConfig.setUid(CREDENTIAL.getUid());
            authConfig.setToken(AUTH_TOKEN);
            authConfig.setSecret(CREDENTIAL.getSecret());
            return config;
        }
        catch (Throwable cause) {
            throw new RuntimeException(cause);
        }
    }

    public SwiftStorageDriverTest() throws Exception {
        this(SwiftStorageDriverTest.getConfig());
    }

    private SwiftStorageDriverTest(Config config) throws Exception {
        super(config.getTestConfig().getStepConfig().getId(), DataInput.getInstance((String)config.getItemConfig().getDataConfig().getInputConfig().getFile(), (String)config.getItemConfig().getDataConfig().getInputConfig().getSeed(), (SizeInBytes)config.getItemConfig().getDataConfig().getInputConfig().getLayerConfig().getSize(), (int)config.getItemConfig().getDataConfig().getInputConfig().getLayerConfig().getCache()), config.getLoadConfig(), config.getStorageConfig(), config.getItemConfig().getDataConfig().getVerify());
    }

    protected FullHttpResponse executeHttpRequest(FullHttpRequest httpRequest) {
        this.httpRequestsLog.add(httpRequest);
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @After
    public void tearDown() {
        this.httpRequestsLog.clear();
    }

    @Test
    public void testRequestNewAuthToken() throws Exception {
        this.requestNewAuthToken(this.credential);
        Assert.assertEquals((long)1L, (long)this.httpRequestsLog.size());
        FullHttpRequest req = this.httpRequestsLog.poll();
        Assert.assertEquals((Object)HttpMethod.GET, (Object)req.method());
        Assert.assertEquals((Object)"/auth/v1.0", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)CREDENTIAL.getUid(), (Object)reqHeaders.get("X-Auth-User"));
        Assert.assertEquals((Object)CREDENTIAL.getSecret(), (Object)reqHeaders.get("X-Auth-Key"));
    }

    @Test
    public void testRequestNewPath() throws Exception {
        String container = "/container0";
        Assert.assertEquals((Object)"/container0", (Object)this.requestNewPath("/container0"));
        Assert.assertEquals((long)2L, (long)this.httpRequestsLog.size());
        FullHttpRequest req = this.httpRequestsLog.poll();
        Assert.assertEquals((Object)HttpMethod.HEAD, (Object)req.method());
        Assert.assertEquals((Object)"/v1/ns1/container0", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)AUTH_TOKEN, (Object)reqHeaders.get("X-Auth-Token"));
        req = this.httpRequestsLog.poll();
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)req.method());
        Assert.assertEquals((Object)"/v1/ns1/container0", (Object)req.uri());
        reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)"archive", (Object)reqHeaders.get("X-Versions-Location"));
        Assert.assertEquals((Object)AUTH_TOKEN, (Object)reqHeaders.get("X-Auth-Token"));
    }

    @Test
    public void testContainerListingTest() throws Exception {
        ItemFactory itemFactory = ItemType.getItemFactory((ItemType)ItemType.DATA);
        String container = "/container1";
        String itemPrefix = "0000";
        String markerItemId = "00003brre8lgz";
        Item markerItem = itemFactory.getItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        List items = this.list(itemFactory, "/container1", "0000", 36, markerItem, 1000);
        Assert.assertEquals((long)0L, (long)items.size());
        Assert.assertEquals((long)1L, (long)this.httpRequestsLog.size());
        FullHttpRequest req = this.httpRequestsLog.poll();
        Assert.assertEquals((Object)HttpMethod.GET, (Object)req.method());
        Assert.assertEquals((Object)"/v1/ns1/container1?format=json&prefix=0000&marker=00003brre8lgz&limit=1000", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)AUTH_TOKEN, (Object)reqHeaders.get("X-Auth-Token"));
    }

    @Test
    public void testCopyRequest() throws Exception {
        String containerSrcName = "/containerSrc";
        String containerDstName = "/containerDst";
        long itemSize = 10240L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 10240L);
        BasicDataIoTask ioTask = new BasicDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, "/containerSrc", "/containerDst", CREDENTIAL, null, 0);
        HttpRequest req = this.getHttpRequest((IoTask)ioTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)req.method());
        Assert.assertEquals((Object)"/v1/ns1/containerDst/00003brre8lgz", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)"/v1/ns1/containerSrc/00003brre8lgz", (Object)reqHeaders.get("X-Copy-From"));
        Assert.assertEquals((Object)AUTH_TOKEN, (Object)reqHeaders.get("X-Auth-Token"));
    }

    @Test
    public void testCreateDloPartRequest() throws Exception {
        String container = "/container2";
        long itemSize = 12345L;
        long partSize = 1234L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 12345L);
        BasicCompositeDataIoTask dloTask = new BasicCompositeDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/container2", CREDENTIAL, null, 0, 1234L);
        PartialDataIoTask dloSubTask = (PartialDataIoTask)dloTask.getSubTasks().get(0);
        HttpRequest req = this.getHttpRequest((IoTask)dloSubTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)req.method());
        Assert.assertEquals((Object)"/v1/ns1/container2/00003brre8lgz/0000001", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)1234L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)AUTH_TOKEN, (Object)reqHeaders.get("X-Auth-Token"));
    }

    @Test
    public void testCreateDloManifestRequest() throws Exception {
        String container = "container2";
        long itemSize = 12345L;
        long partSize = 1234L;
        String itemId = "00003brre8lgz";
        BasicDataItem dataItem = new BasicDataItem("00003brre8lgz", Long.parseLong("00003brre8lgz", 36), 12345L);
        BasicCompositeDataIoTask dloTask = new BasicCompositeDataIoTask(((Object)((Object)this)).hashCode(), IoType.CREATE, (DataItem)dataItem, null, "/container2", CREDENTIAL, null, 0, 1234L);
        List subTasks = dloTask.getSubTasks();
        for (PartialDataIoTask subTask : subTasks) {
            subTask.startRequest();
            subTask.finishRequest();
            subTask.startResponse();
            subTask.finishResponse();
        }
        Assert.assertTrue((boolean)dloTask.allSubTasksDone());
        HttpRequest req = this.getHttpRequest((IoTask)dloTask, this.storageNodeAddrs[0]);
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)req.method());
        Assert.assertEquals((Object)"/v1/ns1/container2/00003brre8lgz", (Object)req.uri());
        HttpHeaders reqHeaders = req.headers();
        Assert.assertEquals((Object)this.storageNodeAddrs[0], (Object)reqHeaders.get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertEquals((long)0L, (long)reqHeaders.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertEquals((Object)"container2/00003brre8lgz/", (Object)reqHeaders.get("X-Object-Manifest"));
        Date reqDate = DateUtil.FMT_DATE_RFC1123.parse(reqHeaders.get((CharSequence)HttpHeaderNames.DATE));
        Assert.assertEquals((float)new Date().getTime(), (float)reqDate.getTime(), (float)10000.0f);
        Assert.assertEquals((Object)AUTH_TOKEN, (Object)reqHeaders.get("X-Auth-Token"));
    }
}

