/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.unit;

import com.github.akurilov.commons.system.DirectMemUtil;
import java.nio.MappedByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class ThreadLocalByteBufferTest {
    @Test
    public final void testZeroBytesRequest() throws Exception {
        MappedByteBuffer bb = DirectMemUtil.getThreadLocalReusableBuff((long)0L);
        Assert.assertEquals((long)bb.capacity(), (long)1L);
    }

    @Test
    public final void testOneByteRequest() throws Exception {
        MappedByteBuffer bb = DirectMemUtil.getThreadLocalReusableBuff((long)1L);
        Assert.assertEquals((long)bb.capacity(), (long)1L);
    }

    @Test
    public final void testNegativeBytesRequestThrowsException() throws Exception {
        try {
            MappedByteBuffer bb = DirectMemUtil.getThreadLocalReusableBuff((long)-100000L);
            Assert.fail((String)"Exception was not thrown as expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public final void testSomeBytesRequest1() throws Exception {
        MappedByteBuffer bb = DirectMemUtil.getThreadLocalReusableBuff((long)12345L);
        Assert.assertEquals((long)bb.capacity(), (long)16384L);
    }

    @Test
    public final void testSomeBytesRequest2() throws Exception {
        MappedByteBuffer bb = DirectMemUtil.getThreadLocalReusableBuff((long)262144L);
        Assert.assertEquals((long)bb.capacity(), (long)262144L);
    }

    @Test
    public final void testTooManyBytesRequest() {
        MappedByteBuffer bb = DirectMemUtil.getThreadLocalReusableBuff((long)1000000000000L);
        Assert.assertEquals((long)bb.capacity(), (long)0x1000000L);
    }
}

