/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.unit;

import com.emc.mongoose.api.common.Constants;
import com.emc.mongoose.api.common.env.PathUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class ValidateScenariosTest {
    @Test
    public final void testAllScenarios() throws Exception {
        ObjectMapper m = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true);
        JsonNode jsonSchema = m.readTree(Paths.get(PathUtil.getBaseDir(), Constants.DIR_EXAMPLE_SCENARIO, "json", "schema.json").toFile());
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        JsonValidator validator = factory.getValidator();
        List scenarioPaths = Files.walk(Paths.get(PathUtil.getBaseDir(), Constants.DIR_EXAMPLE_SCENARIO, "json"), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".json")).filter(path -> !path.endsWith("schema.json") && !path.endsWith("invalid.json")).collect(Collectors.toList());
        for (Path nextScenarioPath : scenarioPaths) {
            if (nextScenarioPath.toString().contains("compat")) continue;
            System.out.println("Validating the scenario file: " + nextScenarioPath.toString());
            JsonNode nextScenario = m.readTree(nextScenarioPath.toFile());
            ProcessingReport report = validator.validate(jsonSchema, nextScenario);
            Assert.assertTrue((String)report.toString(), (boolean)report.isSuccess());
        }
    }
}

