/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.ui.cli;

import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.log.Loggers;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;

public final class CliArgParser {
    public static final String ARG_PREFIX = "--";
    public static final String CONFIG_CLS_SUFFIX = "Config";
    public static final String FIELD_PREFIX = "KEY_";

    private CliArgParser() {
    }

    public static Map<String, Object> parseArgs(List<Map<String, Object>> aliasingConfig, String ... args) throws IllegalArgumentException {
        TreeMap<String, Object> tree = new TreeMap<String, Object>();
        for (String arg : args) {
            String[] argValPair = arg.split("=", 2);
            if (aliasingConfig != null) {
                for (Map<String, Object> aliasingNode : aliasingConfig) {
                    boolean nextDeprecatedFlag;
                    String nextAliasName = ARG_PREFIX + aliasingNode.get("name");
                    String nextAliasTarget = (String)aliasingNode.get("target");
                    nextAliasTarget = nextAliasTarget == null ? null : ARG_PREFIX + nextAliasTarget;
                    boolean bl = nextDeprecatedFlag = aliasingNode.containsKey("deprecated") && (Boolean)aliasingNode.get("deprecated") != false;
                    if (!arg.startsWith(nextAliasName)) continue;
                    if (nextAliasTarget == null) {
                        Loggers.ERR.fatal("The argument \"{}\" is deprecated", (Object)nextAliasName);
                    } else if (nextDeprecatedFlag) {
                        Loggers.ERR.warn("The argument \"{}\" is deprecated, use \"{}\" instead", (Object)nextAliasName, (Object)nextAliasTarget);
                    }
                    String[] aliasArgValPair = nextAliasTarget.split("=", 2);
                    argValPair[0] = aliasArgValPair[0];
                    if (aliasArgValPair.length != 2) break;
                    if (argValPair.length == 2) {
                        argValPair[1] = aliasArgValPair[1];
                        break;
                    }
                    argValPair = new String[]{argValPair[0], aliasArgValPair[1]};
                    break;
                }
            }
            if (argValPair.length > 1) {
                CliArgParser.parseArg(tree, argValPair[0], argValPair[1]);
                continue;
            }
            CliArgParser.parseArg(tree, argValPair[0]);
        }
        return tree;
    }

    private static void parseArg(Map<String, Object> tree, String arg, String value) throws IllegalArgumentException {
        if (arg.startsWith(ARG_PREFIX) && arg.length() > ARG_PREFIX.length()) {
            String[] argParts = arg.substring(ARG_PREFIX.length()).split("-");
            Map subTree = tree;
            for (int i = 0; i < argParts.length; ++i) {
                String argPart = argParts[i];
                if (i < argParts.length - 1) {
                    TreeMap node = subTree.get(argPart);
                    if (node == null) {
                        node = new TreeMap();
                        subTree.put(argPart, node);
                    }
                    subTree = node;
                    continue;
                }
                subTree.put((String)argPart, (Object)value);
            }
        } else {
            throw new IllegalArgumentException(arg);
        }
    }

    private static void parseArg(Map<String, Object> tree, String arg) {
        CliArgParser.parseArg(tree, arg, Boolean.TRUE.toString());
    }

    public static String formatCliArgsList(Map<String, Class> argsWithTypes) {
        StringBuilder strb = new StringBuilder();
        for (String arg : argsWithTypes.keySet()) {
            strb.append('\t').append(arg).append("=<").append(argsWithTypes.get(arg).getSimpleName()).append(">\n");
        }
        return strb.toString();
    }

    public static Map<String, Class> getAllCliArgs() throws ReflectiveOperationException {
        Package[] allPkgs;
        TreeMap<String, Class> argsWithTypes = new TreeMap<String, Class>();
        Package configRootPkg = Config.class.getPackage();
        String configRootPkgName = configRootPkg.getName();
        for (Package subPkg : allPkgs = Package.getPackages()) {
            String subPkgName = subPkg.getName();
            if (!subPkgName.startsWith(configRootPkgName)) continue;
            String configBranchPrefix = subPkgName.substring(configRootPkgName.length()).replaceAll(Pattern.quote("."), "-");
            String configBranchClsNamePrefix = subPkg.equals(configRootPkg) ? "" : WordUtils.capitalize((String)subPkgName.substring(subPkgName.lastIndexOf(46) + 1));
            try {
                Field[] fields;
                Class<?> configBranchCls = Class.forName(subPkgName + '.' + configBranchClsNamePrefix + CONFIG_CLS_SUFFIX);
                for (Field field : fields = configBranchCls.getFields()) {
                    String fieldName;
                    if (!field.getType().equals(String.class) || !(fieldName = field.getName()).startsWith(FIELD_PREFIX)) continue;
                    String rawArgName = fieldName.substring(FIELD_PREFIX.length()).toLowerCase();
                    try {
                        String[] argNameParts = rawArgName.split("_");
                        StringBuilder argNameBuilder = new StringBuilder();
                        for (String argNamePart : argNameParts) {
                            argNameBuilder.append(Character.toUpperCase(argNamePart.charAt(0))).append(argNamePart.substring(1));
                        }
                        Method m = configBranchCls.getMethod("get" + argNameBuilder.toString(), new Class[0]);
                        Class<?> type = m.getReturnType();
                        String argName = Character.toLowerCase(argNameBuilder.charAt(0)) + argNameBuilder.substring(1);
                        argsWithTypes.put(ARG_PREFIX + configBranchPrefix + "-" + argName, type);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return argsWithTypes;
    }
}

