/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.ui.config;

import com.emc.mongoose.api.common.Constants;
import com.emc.mongoose.api.common.TimeUtil;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.common.exception.OmgDoesNotPerformException;
import com.emc.mongoose.api.common.exception.OmgLookAtMyConsoleException;
import com.emc.mongoose.ui.config.IllegalAliasNameException;
import com.emc.mongoose.ui.config.IllegalAliasTargetException;
import com.emc.mongoose.ui.config.IllegalArgumentNameException;
import com.emc.mongoose.ui.config.item.ItemConfig;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.output.OutputConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.test.TestConfig;
import com.emc.mongoose.ui.config.test.step.StepConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;

public final class Config
implements Serializable {
    public static final String NAME = "name";
    public static final String DEPRECATED = "deprecated";
    public static final String TARGET = "target";
    public static final String PATH_SEP = "-";
    public static final String KEY_VERSION = "version";
    public static final String KEY_ITEM = "item";
    public static final String KEY_LOAD = "load";
    public static final String KEY_OUTPUT = "output";
    public static final String KEY_STORAGE = "storage";
    public static final String KEY_TEST = "test";
    public static final String KEY_ALIASING = "aliasing";
    @JsonProperty(value="item")
    private ItemConfig itemConfig;
    @JsonProperty(value="load")
    private LoadConfig loadConfig;
    @JsonProperty(value="output")
    private OutputConfig outputConfig;
    @JsonProperty(value="storage")
    private StorageConfig storageConfig;
    @JsonProperty(value="test")
    private TestConfig testConfig;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="aliasing")
    private List<Map<String, Object>> aliasingConfig;

    public Config() {
    }

    public Config(Config config) {
        this.version = config.getVersion();
        this.itemConfig = new ItemConfig(config.getItemConfig());
        this.loadConfig = new LoadConfig(config.getLoadConfig());
        this.outputConfig = new OutputConfig(config.getOutputConfig());
        this.storageConfig = new StorageConfig(config.getStorageConfig());
        this.testConfig = new TestConfig(config.getTestConfig());
        List<Map<String, Object>> ac = config.getAliasingConfig();
        this.aliasingConfig = ac == null ? null : new ArrayList<Map<String, Object>>(config.getAliasingConfig());
    }

    public final String getVersion() {
        return this.version;
    }

    public final OutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    public final StorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public final TestConfig getTestConfig() {
        return this.testConfig;
    }

    public final LoadConfig getLoadConfig() {
        return this.loadConfig;
    }

    public final ItemConfig getItemConfig() {
        return this.itemConfig;
    }

    public final List<Map<String, Object>> getAliasingConfig() {
        return this.aliasingConfig;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public final void setOutputConfig(OutputConfig outputConfig) {
        this.outputConfig = outputConfig;
    }

    public final void setStorageConfig(StorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }

    public final void setTestConfig(TestConfig testConfig) {
        this.testConfig = testConfig;
    }

    public final void setLoadConfig(LoadConfig loadConfig) {
        this.loadConfig = loadConfig;
    }

    public final void setItemConfig(ItemConfig itemConfig) {
        this.itemConfig = itemConfig;
    }

    public final void setAliasingConfig(List<Map<String, Object>> aliasingConfig) {
        this.aliasingConfig = aliasingConfig;
    }

    public void apply(Map<String, Object> tree, String autoGeneratedTestIdOffer) throws IllegalArgumentException {
        String newTestStepId;
        StepConfig testStepConfg = this.getTestConfig().getStepConfig();
        String oldTestStepId = testStepConfg.getId();
        boolean tmpTestIdFlag = testStepConfg.getIdTmp();
        if (tree != null) {
            Config.applyAliasing(tree, this.getAliasingConfig());
            try {
                Config.applyRecursively(this, tree);
            }
            catch (IllegalArgumentNameException e) {
                throw new IllegalArgumentNameException("--" + e.getMessage());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace(System.err);
            }
        }
        if ((newTestStepId = testStepConfg.getId()) == null || newTestStepId.equals(oldTestStepId) && tmpTestIdFlag) {
            newTestStepId = autoGeneratedTestIdOffer;
            testStepConfg.setId(newTestStepId);
            testStepConfg.setIdTmp(true);
        }
    }

    private static void applyAliasing(Map<String, Object> tree, List<Map<String, Object>> rawAliases) {
        for (Map<String, Object> nextAliasNode : rawAliases) {
            String aliasNamePart;
            Object t;
            String aliasTarget;
            String aliasName = (String)nextAliasNode.get(NAME);
            if (aliasName.equals(aliasTarget = (String)nextAliasNode.get(TARGET))) {
                throw new IllegalAliasNameException(aliasName);
            }
            String[] aliasNamePath = aliasName.split(PATH_SEP);
            Map subTree = tree;
            for (int i = 0; i < aliasNamePath.length && (t = subTree.get(aliasNamePart = aliasNamePath[i])) != null; ++i) {
                if (t instanceof Map) {
                    subTree = (Map)t;
                    continue;
                }
                if (i == aliasNamePath.length - 1) {
                    if (aliasTarget == null) {
                        System.err.println("ERROR: configuration value @ \"" + aliasName + "\" is deprecated");
                    } else if (nextAliasNode.containsKey(DEPRECATED) && ((Boolean)nextAliasNode.get(DEPRECATED)).booleanValue()) {
                        System.err.println("WARNING: configuration value @ \"" + aliasName + "\" is deprecated, please use \"" + aliasTarget + "\" instead");
                    }
                    Config.setNewPath(tree, aliasTarget, t);
                    subTree.remove(aliasNamePart);
                    continue;
                }
                throw new IllegalAliasNameException(aliasName);
            }
        }
        Config.cleanEmptyPaths(tree);
    }

    private static void setNewPath(Map<String, Object> tree, String rawPath, Object value) {
        String[] newPath = rawPath.split(PATH_SEP);
        Map subTree = tree;
        for (int i = 0; i < newPath.length; ++i) {
            String newPathPart = newPath[i];
            HashMap t = subTree.get(newPathPart);
            if (t != null) {
                if (t instanceof Map) {
                    subTree = t;
                    if (i != newPath.length - 1) continue;
                    subTree.put(newPathPart, value);
                    continue;
                }
                throw new IllegalAliasTargetException(rawPath);
            }
            if (i == newPath.length - 1) {
                subTree.put(newPathPart, value);
                continue;
            }
            t = new HashMap();
            subTree.put(newPathPart, t);
            subTree = t;
        }
    }

    private static void cleanEmptyPaths(Map<String, Object> tree) {
        boolean emptyBranchFound = true;
        while (emptyBranchFound && !tree.isEmpty()) {
            Iterator<Map.Entry<String, Object>> i = tree.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Object> nextEntry = i.next();
                emptyBranchFound = false;
                Object t = nextEntry.getValue();
                if (!(t instanceof Map)) continue;
                if (((Map)t).isEmpty()) {
                    i.remove();
                    emptyBranchFound = true;
                    continue;
                }
                Config.cleanEmptyPaths((Map)t);
            }
        }
    }

    private static void applyRecursively(Object config, Map<String, Object> branch) throws InvocationTargetException, IllegalAccessException {
        Class<?> configCls = config.getClass();
        for (String key : branch.keySet()) {
            Object node = branch.get(key);
            if (node instanceof Map) {
                Map childBranch = (Map)node;
                try {
                    Method subConfigGetter = configCls.getMethod("get" + WordUtils.capitalize((String)key) + "Config", new Class[0]);
                    Object subConfig = subConfigGetter.invoke(config, new Object[0]);
                    try {
                        Config.applyRecursively(subConfig, childBranch);
                        continue;
                    }
                    catch (IllegalArgumentNameException e) {
                        throw new IllegalArgumentNameException(key + PATH_SEP + e.getMessage());
                    }
                }
                catch (NoSuchMethodException e) {
                    Config.applyField(config, key, node);
                    continue;
                }
            }
            if (config instanceof Map) {
                ((Map)config).put(key, node);
                continue;
            }
            Config.applyField(config, key, node);
        }
    }

    private static void applyField(Object config, String key, Object value) throws InvocationTargetException, IllegalAccessException {
        block25: {
            Class<?> configCls = config.getClass();
            try {
                Method fieldGetter = configCls.getMethod("get" + WordUtils.capitalize((String)key), new Class[0]);
                Class<?> fieldType = fieldGetter.getReturnType();
                if (value == null) {
                    configCls.getMethod("set" + WordUtils.capitalize((String)key), fieldType).invoke(config, value);
                    break block25;
                }
                Class<?> valueType = value.getClass();
                if (TypeUtil.typeEquals(fieldType, valueType)) {
                    configCls.getMethod("set" + WordUtils.capitalize((String)key), fieldType).invoke(config, value);
                    break block25;
                }
                if (value instanceof Map && TypeUtil.typeEquals(fieldType, Map.class)) {
                    configCls.getMethod("set" + WordUtils.capitalize((String)key), fieldType).invoke(config, value);
                    break block25;
                }
                if (value instanceof List && TypeUtil.typeEquals(fieldType, List.class)) {
                    configCls.getMethod("set" + WordUtils.capitalize((String)key), fieldType).invoke(config, value);
                    break block25;
                }
                if (value instanceof String) {
                    if (fieldType.equals(List.class)) {
                        List<String> listValue = Arrays.asList(((String)value).split(","));
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), List.class).invoke(config, listValue);
                        break block25;
                    }
                    if (fieldType.equals(Map.class)) {
                        Map field = (Map)fieldGetter.invoke(config, new Object[0]);
                        String[] keyValuePair = ((String)value).split(":", 2);
                        if (keyValuePair.length == 1) {
                            field.remove(keyValuePair[0]);
                        } else if (keyValuePair.length == 2) {
                            field.put(keyValuePair[0], keyValuePair[1]);
                        }
                        break block25;
                    }
                    if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                        int intValue = Integer.parseInt((String)value);
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), Integer.TYPE).invoke(config, intValue);
                        break block25;
                    }
                    if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
                        try {
                            long longValue = Long.parseLong((String)value);
                            configCls.getMethod("set" + WordUtils.capitalize((String)key), Long.TYPE).invoke(config, longValue);
                        }
                        catch (NumberFormatException e) {
                            long timeValue = TimeUtil.getTimeInSeconds((String)((String)value));
                            configCls.getMethod("set" + WordUtils.capitalize((String)key), Long.TYPE).invoke(config, timeValue);
                        }
                        break block25;
                    }
                    if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
                        float floatValue = Float.parseFloat((String)value);
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), Float.TYPE).invoke(config, Float.valueOf(floatValue));
                        break block25;
                    }
                    if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                        double doubleValue = Double.parseDouble((String)value);
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), Double.TYPE).invoke(config, doubleValue);
                        break block25;
                    }
                    if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                        boolean boolValue = Boolean.parseBoolean((String)value);
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), Boolean.TYPE).invoke(config, boolValue);
                        break block25;
                    }
                    if (fieldType.equals(SizeInBytes.class)) {
                        SizeInBytes sizeValue = new SizeInBytes((String)value);
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), SizeInBytes.class).invoke(config, sizeValue);
                        break block25;
                    }
                    if (fieldType.equals(Range.class)) {
                        Range rangeValue = new Range((String)value);
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), Range.class).invoke(config, rangeValue);
                        break block25;
                    }
                    throw new IllegalStateException("Field type is \"" + fieldType.getName() + "\" for key: " + key);
                }
                if (Integer.TYPE.equals(valueType) || Integer.class.equals(valueType)) {
                    int intValue = (Integer)value;
                    if (SizeInBytes.class.equals(fieldType)) {
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), SizeInBytes.class).invoke(config, new SizeInBytes((long)intValue));
                        break block25;
                    }
                    if (Long.class.equals(fieldType) || Long.TYPE.equals(fieldType)) {
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), Long.TYPE).invoke(config, intValue);
                        break block25;
                    }
                    if (Double.class.equals(fieldType) || Double.TYPE.equals(fieldType)) {
                        configCls.getMethod("set" + WordUtils.capitalize((String)key), Double.TYPE).invoke(config, intValue);
                        break block25;
                    }
                    throw new IllegalStateException("Field type is \"" + fieldType.getName() + "\" but value type is \"" + valueType.getName() + "\"");
                }
                throw new IllegalStateException("Field type is \"" + fieldType.getName() + "\" but value type is \"" + valueType.getName() + "\"");
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentNameException(key);
            }
        }
    }

    public static Config loadDefaults() throws IOException {
        String defaultConfigPath = PathUtil.getBaseDir() + File.separator + Constants.PATH_DEFAULTS;
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true);
        return (Config)mapper.readValue(new File(defaultConfigPath), Config.class);
    }

    public final Config replace(String replacePattern, Object newValue) throws OmgLookAtMyConsoleException, OmgDoesNotPerformException, IOException {
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true);
        try {
            String newConfigText;
            String configText = mapper.writeValueAsString((Object)this);
            String rp = Pattern.quote(replacePattern);
            if (newValue == null) {
                newConfigText = configText.replaceAll("\"" + rp + "\"", "null");
            } else if (newValue instanceof Boolean || newValue instanceof Number) {
                newConfigText = configText.replaceAll("\"" + rp + "\"", newValue.toString()).replaceAll(rp, newValue.toString());
            } else if (newValue instanceof List) {
                List newValues = (List)newValue;
                ArrayList<String> newStrValues = new ArrayList<String>();
                for (int i = 0; i < newValues.size(); ++i) {
                    Object nextValue = newValues.get(i);
                    if (nextValue == null) {
                        newStrValues.add("null");
                        continue;
                    }
                    if (nextValue instanceof Boolean || nextValue instanceof Number) {
                        newStrValues.add(nextValue.toString());
                        continue;
                    }
                    if (nextValue instanceof String) {
                        newStrValues.add("\"" + nextValue + "\"");
                        continue;
                    }
                    throw new OmgLookAtMyConsoleException("Unexpected replacement value type: " + nextValue.getClass().getName());
                }
                String newValueStr = "[" + String.join((CharSequence)",", newStrValues) + "]";
                newConfigText = configText.replace(rp, newValueStr);
            } else if (newValue instanceof String) {
                newConfigText = configText.replaceAll(rp, (String)newValue);
            } else {
                throw new OmgLookAtMyConsoleException("Unexpected replacement value type: " + newValue.getClass().getName());
            }
            return (Config)mapper.readValue(newConfigText, Config.class);
        }
        catch (JsonProcessingException e) {
            throw new OmgDoesNotPerformException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Object> replace(Map<String, Object> config, String replacePattern, Object newValue) throws OmgLookAtMyConsoleException {
        HashMap<String, Object> newConfig = new HashMap<String, Object>();
        String rp = Pattern.quote(replacePattern);
        for (String k : config.keySet()) {
            Map<String, Object> v = config.get(k);
            if (v instanceof String) {
                String valueStr = (String)((Object)v);
                if (valueStr.equals("\"" + replacePattern + "\"")) {
                    v = newValue;
                } else if (newValue == null) {
                    v = valueStr.replaceAll(rp, "");
                } else if (newValue instanceof Boolean || newValue instanceof Number || newValue instanceof String) {
                    v = valueStr.replaceAll(rp, newValue.toString());
                } else {
                    if (!(newValue instanceof List)) throw new OmgLookAtMyConsoleException("Unexpected replacement value type: " + newValue.getClass().getName());
                    StringJoiner sj = new StringJoiner(",");
                    for (Object newValueElement : (List)newValue) {
                        sj.add(newValueElement == null ? "" : newValueElement.toString());
                    }
                    v = valueStr.replaceAll(rp, sj.toString());
                }
            } else if (v instanceof Map) {
                v = Config.replace(v, replacePattern, newValue);
            }
            newConfig.put(k, v);
        }
        return newConfig;
    }

    public final String toString() {
        ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true);
        DefaultIndenter indenter = new DefaultIndenter("\t", DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
        printer.withArrayIndenter((DefaultPrettyPrinter.Indenter)indenter);
        try {
            return mapper.writer((PrettyPrinter)printer).writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

