/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.ui.config.item.data.ranges;

import com.emc.mongoose.ui.config.RangeDeserializer;
import com.emc.mongoose.ui.config.RangeSerializer;
import com.emc.mongoose.ui.config.SizeInBytesDeserializer;
import com.emc.mongoose.ui.config.SizeInBytesSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class RangesConfig
implements Serializable {
    public static final String KEY_CONCAT = "concat";
    public static final String KEY_FIXED = "fixed";
    public static final String KEY_RANDOM = "random";
    public static final String KEY_THRESHOLD = "threshold";
    @JsonDeserialize(using=RangeDeserializer.class)
    @JsonSerialize(using=RangeSerializer.class)
    @JsonProperty(value="concat")
    private Range concat;
    @JsonProperty(value="fixed")
    private List<String> fixed;
    @JsonProperty(value="random")
    private int random;
    @JsonProperty(value="threshold")
    @JsonDeserialize(using=SizeInBytesDeserializer.class)
    @JsonSerialize(using=SizeInBytesSerializer.class)
    private SizeInBytes threshold;

    public RangesConfig() {
    }

    public RangesConfig(RangesConfig other) {
        List<String> otherRanges = other.getFixed();
        this.concat = other.getConcat();
        if (this.concat != null) {
            this.concat = new Range(this.concat);
        }
        this.fixed = otherRanges == null ? null : new ArrayList<String>(otherRanges);
        this.random = other.getRandom();
        this.threshold = new SizeInBytes(other.getThreshold());
    }

    public final Range getConcat() {
        return this.concat;
    }

    public final void setConcat(Range concat) {
        this.concat = concat;
    }

    public final List<String> getFixed() {
        return this.fixed;
    }

    public final void setFixed(List<String> fixed) {
        this.fixed = fixed;
    }

    public final int getRandom() {
        return this.random;
    }

    public final void setRandom(int random) {
        this.random = random;
    }

    public final SizeInBytes getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(SizeInBytes threshold) {
        this.threshold = threshold;
    }
}

