/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.ui.log;

import com.emc.mongoose.api.common.Constants;
import com.emc.mongoose.api.common.env.DateUtil;
import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.api.model.concurrent.DaemonBase;
import com.emc.mongoose.ui.log.Loggers;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.core.util.datetime.DatePrinter;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;

public final class LogUtil
implements ShutdownCallbackRegistry {
    public static final DatePrinter FMT_DT = FastDateFormat.getInstance((String)"yyyyMMdd.HHmmss.SSS", (TimeZone)DateUtil.TZ_UTC, (Locale)Constants.LOCALE_DEFAULT);
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33";
    public static final String BLUE = "\u001b[34m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37;1m";
    public static final String RESET = "\u001b[0m";
    public static final String NOOP_COLOR = "\u001b[38;5;101m";
    public static final String CREATE_COLOR = "\u001b[38;5;67m";
    public static final String READ_COLOR = "\u001b[38;5;65m";
    public static final String UPDATE_COLOR = "\u001b[38;5;104m";
    public static final String DELETE_COLOR = "\u001b[38;5;137m";
    public static final String LIST_COLOR = "\u001b[38;5;138m";

    public static String getDateTimeStamp() {
        return FMT_DT.format(Calendar.getInstance(DateUtil.TZ_UTC, Constants.LOCALE_DEFAULT).getTime());
    }

    public static void init() {
        ThreadContext.put((String)"baseDir", (String)PathUtil.BASE_DIR);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("logCtxShutDownHook"){

                @Override
                public final void run() {
                    LogUtil.shutdown();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static void flushAll() {
        LoggerContext logCtx = (LoggerContext)LogManager.getContext();
        for (org.apache.logging.log4j.core.Logger logger : logCtx.getLoggers()) {
            for (Appender appender : logger.getAppenders().values()) {
                if (!(appender instanceof AbstractOutputStreamAppender)) continue;
                ((AbstractOutputStreamAppender)appender).getManager().flush();
            }
        }
    }

    public static void shutdown() {
        try {
            DaemonBase.closeAll();
            LogManager.shutdown();
        }
        catch (Throwable cause) {
            cause.printStackTrace(System.err);
        }
    }

    public static String getFailureRatioAnsiColorCode(long succ, long fail) {
        if (fail == 0L) {
            return "\u001b[38;2;0;200;0m";
        }
        if (fail >= succ) {
            return "\u001b[38;2;" + (int)(200.0 + 55.0 * (double)fail / (double)(succ + fail)) + ";0;0m";
        }
        return "\u001b[38;2;" + (int)(400.0 * Math.sqrt((double)fail / (double)(succ + fail))) + ";" + (int)(200.0 * (double)succ / (double)(succ + fail)) + ";0m";
    }

    public static void exception(Level level, Throwable e, String msgPattern, Object ... args) {
        if (Loggers.ERR.isTraceEnabled()) {
            Loggers.ERR.log(level, Loggers.ERR.getMessageFactory().newMessage(msgPattern + ": " + e, args), e);
        } else {
            Loggers.ERR.log(level, Loggers.ERR.getMessageFactory().newMessage(msgPattern + ": " + e, args));
        }
    }

    public static void trace(Logger logger, Level level, String msgPattern, Object ... args) {
        logger.log(level, logger.getMessageFactory().newMessage(msgPattern, args), new Throwable());
    }

    public final Cancellable addShutdownCallback(final Runnable callback) {
        return new Cancellable(){

            public final void cancel() {
            }

            public final void run() {
                if (callback != null) {
                    System.out.println("Shutdown callback + \"" + callback + "\" run...");
                    callback.run();
                }
            }
        };
    }
}

