/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.ui.log;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.logging.log4j.core.LogEvent;

public final class ShortenedLogEvent
implements Serializable {
    private String level;
    private String loggerName;
    private String threadName;
    private final long timeStamp;
    private String message;

    public ShortenedLogEvent(LogEvent logEvent) {
        this.level = logEvent.getLevel().name();
        this.loggerName = logEvent.getLoggerName();
        this.threadName = logEvent.getThreadName();
        this.timeStamp = logEvent.getTimeMillis();
        this.message = logEvent.getMessage().getFormattedMessage();
    }

    public ShortenedLogEvent(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public final String toString() {
        return String.valueOf(this.timeStamp);
    }

    public static final class SleComparator
    implements Comparator<ShortenedLogEvent> {
        @Override
        public final int compare(ShortenedLogEvent sle1, ShortenedLogEvent sle2) {
            return Long.compare(sle1.timeStamp, sle2.timeStamp);
        }
    }
}

