/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.ui.log;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="StepIdTriggeringPolicy", category="Core", printObject=true)
public final class StepIdTriggeringPolicy
extends AbstractTriggeringPolicy {
    private RollingFileManager manager;
    private String lastStepId = null;

    @PluginFactory
    public static StepIdTriggeringPolicy createPolicy() {
        return new StepIdTriggeringPolicy();
    }

    public final void initialize(RollingFileManager manager) {
        this.manager = manager;
    }

    public final boolean isTriggeringEvent(LogEvent logEvent) {
        String stepId = (String)logEvent.getContextData().getValue("stepId");
        if (null == stepId) {
            return false;
        }
        ThreadContext.put((String)"stepId", (String)stepId);
        if (stepId.equals(this.lastStepId)) {
            return false;
        }
        this.lastStepId = stepId;
        this.manager.getFileName();
        return true;
    }
}

