/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.code;

import com.github.fartherp.framework.common.code.ASCII;
import com.github.fartherp.framework.common.code.EBCDIC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;

public class Coder {
    public static final String CHARSET_GBK = "GBK";
    public static final String INT = "0123456789";

    public static int ASCIIToEBCDIC(int ascii) {
        return ASCII.AToE[ascii & 0xFF] & 0xFF;
    }

    public static int EBCDICToASCII(int ebcdic) {
        return EBCDIC.EToA[ebcdic & 0xFF] & 0xFF;
    }

    public static byte[] ASCIIToEBCDIC(byte[] ascii) {
        byte[] tobytes = new byte[ascii.length];
        for (int i = 0; i < ascii.length; ++i) {
            tobytes[i] = (byte)Coder.ASCIIToEBCDIC(ascii[i]);
        }
        return tobytes;
    }

    public static byte[] EBCDICToASCII(byte[] ebcdic) {
        byte[] tobytes = new byte[ebcdic.length];
        for (int i = 0; i < ebcdic.length; ++i) {
            tobytes[i] = (byte)Coder.EBCDICToASCII(ebcdic[i]);
        }
        return tobytes;
    }

    public static String ASCIIToEBCDIC(String ascii) {
        return new String(Coder.ASCIIToEBCDIC(ascii.getBytes()));
    }

    public static String EBCDICToASCII(String ebcdic) {
        return new String(Coder.EBCDICToASCII(ebcdic.getBytes()));
    }

    public static void ASCIIToEBCDIC(String fromFile, String toFile) {
        try {
            int tempint;
            FileInputStream in = new FileInputStream(new File(fromFile));
            FileOutputStream out = new FileOutputStream(new File(toFile));
            int i = 0;
            byte[] tempbytes = new byte[in.available()];
            while ((tempint = in.read()) != -1) {
                tempbytes[i++] = (byte)tempint;
            }
            out.write(Coder.ASCIIToEBCDIC(tempbytes));
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void EBCDICToASCII(String fromFile, String toFile) {
        try {
            int temp;
            FileInputStream in = new FileInputStream(new File(fromFile));
            FileOutputStream out = new FileOutputStream(new File(toFile));
            int i = 0;
            byte[] bytes = new byte[in.available()];
            while ((temp = in.read()) != -1) {
                bytes[i++] = (byte)temp;
            }
            out.write(Coder.EBCDICToASCII(bytes));
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String transCode(String s) throws Exception {
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        byte[] b = s.getBytes("ISO-8859-1");
        if (s.indexOf("?") > -1) {
            String s_temp = StringUtils.replace((String)s, (String)"?", (String)"");
            byte[] b_temp = s_temp.getBytes("ISO-8859-1");
            for (int i = 0; i < b_temp.length; ++i) {
                if (b_temp[i] != 63) continue;
                return s;
            }
        } else {
            for (int i = 0; i < b.length; ++i) {
                if (b[i] != 63) continue;
                return s;
            }
        }
        return new String(b, CHARSET_GBK);
    }

    public static String encodeStrFromISOToGBK(Object s) {
        if (s == null) {
            return "";
        }
        try {
            if (!CHARSET_GBK.equalsIgnoreCase(CHARSET_GBK)) {
                s = new String(s.toString().trim().getBytes("8859_1"), CHARSET_GBK);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return s.toString();
    }

    public static String encodeStrFromGBKToISO(Object s) {
        if (s == null) {
            return "";
        }
        try {
            if (CHARSET_GBK.equalsIgnoreCase(CHARSET_GBK)) {
                s = new String(s.toString().trim().getBytes(CHARSET_GBK), "8859_1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s.toString();
    }

    public static Object transCharsetISO(Class targetType, Object obj) {
        if (!CHARSET_GBK.equalsIgnoreCase(CHARSET_GBK) || !targetType.equals(String.class)) {
            return obj;
        }
        return Coder.encodeStrFromISOToGBK(obj);
    }

    public static Object transCharsetGBK(Class targetType, Object obj) {
        if (CHARSET_GBK.equalsIgnoreCase(CHARSET_GBK) || !targetType.equals(String.class)) {
            return obj;
        }
        return Coder.encodeStrFromISOToGBK(obj);
    }

    public static String transCharsetISO(Object obj) {
        if (!CHARSET_GBK.equalsIgnoreCase(CHARSET_GBK)) {
            return obj.toString();
        }
        return Coder.encodeStrFromGBKToISO(obj);
    }

    public static String transCharsetGBK(Object obj) {
        if (CHARSET_GBK.equalsIgnoreCase(CHARSET_GBK)) {
            return obj.toString();
        }
        return Coder.transCharsetGBK(String.class, obj).toString();
    }
}

