/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.common.extension;

import com.github.fartherp.framework.common.extension.Activate;
import com.github.fartherp.framework.common.extension.Adaptive;
import com.github.fartherp.framework.common.extension.ConcurrentHashSet;
import com.github.fartherp.framework.common.extension.ExtensionFactory;
import com.github.fartherp.framework.common.extension.Holder;
import com.github.fartherp.framework.common.extension.SPI;
import com.github.fartherp.framework.common.extension.io.UnsafeStringWriter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionLoader<T> {
    private static final Log logger = LogFactory.getLog(ExtensionLoader.class);
    private static final String DEFAULT_DIRECTORY = "META-INF/";
    private static final String FRAMEWORK_DIRECTORY = "META-INF/framework";
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\s*[,]+\\s*");
    private static final ConcurrentMap<Class<?>, ExtensionLoader<?>> EXTENSION_LOADERS = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap();
    private final Class<?> type;
    private final ExtensionFactory objectFactory;
    private final ConcurrentMap<Class<?>, String> cachedNames = new ConcurrentHashMap();
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final Map<String, Activate> cachedActivates = new ConcurrentHashMap<String, Activate>();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private final Holder<Object> cachedAdaptiveInstance = new Holder();
    private volatile Class<?> cachedAdaptiveClass = null;
    private String cachedDefaultName;
    private volatile Throwable createAdaptiveInstanceError;
    private Set<Class<?>> cachedWrapperClasses;
    private Map<String, IllegalStateException> exceptions = new ConcurrentHashMap<String, IllegalStateException>();
    private List<String> paths;

    private ExtensionLoader(Class<?> type) {
        this.type = type;
        this.objectFactory = type == ExtensionFactory.class ? null : ExtensionLoader.getExtensionLoader(ExtensionFactory.class).getAdaptiveExtension();
    }

    private ExtensionLoader(Class<?> type, String path) {
        this(type);
        this.addPath(path);
    }

    private static <T> boolean withExtensionAnnotation(Class<T> type) {
        return type.isAnnotationPresent(SPI.class);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type, String path) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type(" + type + ") is not interface!");
        }
        if (!ExtensionLoader.withExtensionAnnotation(type)) {
            throw new IllegalArgumentException("Extension type(" + type + ") is not extension, because WITHOUT @" + SPI.class.getSimpleName() + " Annotation!");
        }
        ExtensionLoader<T> loader = (ExtensionLoader<T>)EXTENSION_LOADERS.get(type);
        if (loader == null) {
            ExtensionLoader<T> extensionLoader = new ExtensionLoader<T>(type, path);
            EXTENSION_LOADERS.putIfAbsent(type, extensionLoader);
            loader = extensionLoader;
        }
        return loader;
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        return ExtensionLoader.getExtensionLoader(type, null);
    }

    private static ClassLoader findClassLoader() {
        return ExtensionLoader.class.getClassLoader();
    }

    public String getExtensionName(T extensionInstance) {
        return this.getExtensionName(extensionInstance.getClass());
    }

    public String getExtensionName(Class<?> extensionClass) {
        return (String)this.cachedNames.get(extensionClass);
    }

    public T getLoadedExtension(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            Holder objectHolder = new Holder();
            this.cachedInstances.putIfAbsent(name, objectHolder);
            holder = objectHolder;
        }
        return holder.get();
    }

    public Set<String> getLoadedExtensions() {
        return Collections.unmodifiableSet(new TreeSet(this.cachedInstances.keySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name) {
        Object instance;
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        if ("true".equals(name)) {
            return this.getDefaultExtension();
        }
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            Holder objectHolder = new Holder();
            this.cachedInstances.putIfAbsent(name, objectHolder);
            holder = objectHolder;
        }
        if ((instance = holder.get()) == null) {
            Holder holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name);
                    holder.set(instance);
                }
            }
        }
        return instance;
    }

    public T getDefaultExtension() {
        this.getExtensionClasses();
        if (StringUtils.isBlank((String)this.cachedDefaultName) || "true".equals(this.cachedDefaultName)) {
            return null;
        }
        return this.getExtension(this.cachedDefaultName);
    }

    public boolean hasExtension(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        try {
            return this.getExtensionClass(name) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Set<String> getSupportedExtensions() {
        Map<String, Class<?>> clazzes = this.getExtensionClasses();
        return Collections.unmodifiableSet(new TreeSet<String>(clazzes.keySet()));
    }

    public String getDefaultExtensionName() {
        this.getExtensionClasses();
        return this.cachedDefaultName;
    }

    public void addExtension(String name, Class<?> clazz) {
        this.getExtensionClasses();
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Input type " + clazz + "not implement Extension " + this.type);
        }
        if (clazz.isInterface()) {
            throw new IllegalStateException("Input type " + clazz + "can not be interface!");
        }
        if (!clazz.isAnnotationPresent(Adaptive.class)) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalStateException("Extension name is blank (Extension " + this.type + ")!");
            }
            if (this.cachedClasses.get().containsKey(name)) {
                throw new IllegalStateException("Extension name " + name + " already existed(Extension " + this.type + ")!");
            }
            this.cachedNames.put(clazz, name);
            this.cachedClasses.get().put(name, clazz);
        } else {
            if (this.cachedAdaptiveClass != null) {
                throw new IllegalStateException("Adaptive Extension already existed(Extension " + this.type + ")!");
            }
            this.cachedAdaptiveClass = clazz;
        }
    }

    @Deprecated
    public void replaceExtension(String name, Class<?> clazz) {
        this.getExtensionClasses();
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Input type " + clazz + "not implement Extension " + this.type);
        }
        if (clazz.isInterface()) {
            throw new IllegalStateException("Input type " + clazz + "can not be interface!");
        }
        if (!clazz.isAnnotationPresent(Adaptive.class)) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalStateException("Extension name is blank (Extension " + this.type + ")!");
            }
            if (!this.cachedClasses.get().containsKey(name)) {
                throw new IllegalStateException("Extension name " + name + " not existed(Extension " + this.type + ")!");
            }
            this.cachedNames.put(clazz, name);
            this.cachedClasses.get().put(name, clazz);
            this.cachedInstances.remove(name);
        } else {
            if (this.cachedAdaptiveClass == null) {
                throw new IllegalStateException("Adaptive Extension not existed(Extension " + this.type + ")!");
            }
            this.cachedAdaptiveClass = clazz;
            this.cachedAdaptiveInstance.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAdaptiveExtension() {
        Object instance = this.cachedAdaptiveInstance.get();
        if (instance == null) {
            if (this.createAdaptiveInstanceError == null) {
                Holder<Object> holder = this.cachedAdaptiveInstance;
                synchronized (holder) {
                    instance = this.cachedAdaptiveInstance.get();
                    if (instance == null) {
                        try {
                            instance = this.createAdaptiveExtension();
                            this.cachedAdaptiveInstance.set(instance);
                        }
                        catch (Throwable t) {
                            this.createAdaptiveInstanceError = t;
                            throw new IllegalStateException("fail to create adaptive instance: " + t.toString(), t);
                        }
                    }
                }
            }
            throw new IllegalStateException("fail to create adaptive instance: " + this.createAdaptiveInstanceError.toString(), this.createAdaptiveInstanceError);
        }
        return (T)instance;
    }

    private IllegalStateException findException(String name) {
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(name.toLowerCase())) continue;
            return entry.getValue();
        }
        StringBuilder buf = new StringBuilder("No such extension " + this.type.getName() + " by name " + name);
        int i = 1;
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (i == 1) {
                buf.append(", possible causes: ");
            }
            buf.append("\r\n(");
            buf.append(i++);
            buf.append(") ");
            buf.append(entry.getKey());
            buf.append(":\r\n");
            buf.append(ExtensionLoader.toString(entry.getValue()));
        }
        return new IllegalStateException(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Throwable e) {
        UnsafeStringWriter w = new UnsafeStringWriter();
        PrintWriter p = new PrintWriter(w);
        p.print(e.getClass().getName());
        if (e.getMessage() != null) {
            p.print(": " + e.getMessage());
        }
        p.println();
        try {
            e.printStackTrace(p);
            String string = w.toString();
            return string;
        }
        finally {
            p.close();
        }
    }

    private T createExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw this.findException(name);
        }
        try {
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                Object t = clazz.newInstance();
                EXTENSION_INSTANCES.putIfAbsent(clazz, t);
                instance = t;
            }
            this.injectExtension(instance);
            Set<Class<?>> wrapperClasses = this.cachedWrapperClasses;
            if (wrapperClasses != null && wrapperClasses.size() > 0) {
                for (Class<?> wrapperClass : wrapperClasses) {
                    instance = this.injectExtension(wrapperClass.getConstructor(this.type).newInstance(instance));
                }
            }
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    private T injectExtension(T instance) {
        try {
            if (this.objectFactory != null) {
                for (Method method : instance.getClass().getMethods()) {
                    if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !Modifier.isPublic(method.getModifiers())) continue;
                    Class<?> pt = method.getParameterTypes()[0];
                    try {
                        String property = method.getName().length() > 3 ? method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4) : "";
                        Object object = this.objectFactory.getExtension(pt, property);
                        if (object == null) continue;
                        method.invoke(instance, object);
                    }
                    catch (Exception e) {
                        logger.error((Object)("fail to inject via method " + method.getName() + " of interface " + this.type.getName() + ": " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return instance;
    }

    private Class<?> getExtensionClass(String name) {
        if (this.type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new IllegalStateException("No such extension \"" + name + "\" for " + this.type.getName() + "!");
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = this.cachedClasses.get();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.get();
                if (classes == null) {
                    classes = this.loadExtensionClasses();
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClasses() {
        SPI defaultAnnotation = this.type.getAnnotation(SPI.class);
        if (defaultAnnotation != null) {
            this.cachedDefaultName = defaultAnnotation.value();
        }
        HashMap extensionClasses = new HashMap();
        this.loadFile(extensionClasses, FRAMEWORK_DIRECTORY);
        for (String path : this.paths) {
            this.loadFile(extensionClasses, DEFAULT_DIRECTORY + path);
        }
        return extensionClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(Map<String, Class<?>> extensionClasses, String dir) {
        int diff = dir.length() - dir.lastIndexOf("/");
        String fileName = diff == 1 ? dir + this.type.getName() : dir + "/" + this.type.getName();
        try {
            ClassLoader classLoader = ExtensionLoader.findClassLoader();
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                        try {
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                int ci = line.indexOf(35);
                                if (ci >= 0) {
                                    line = line.substring(0, ci).trim();
                                }
                                if (line.length() <= 0) continue;
                                try {
                                    String name = null;
                                    int i = line.indexOf(61);
                                    if (i > 0) {
                                        name = line.substring(0, i).trim();
                                        line = line.substring(i + 1).trim();
                                    }
                                    if (line.length() <= 0) continue;
                                    Class<?> clazz = Class.forName(line, true, classLoader);
                                    if (!this.type.isAssignableFrom(clazz)) {
                                        throw new IllegalStateException("Error when load extension class(interface: " + this.type + ", class: " + clazz.getName() + "), class is not subtype of interface.");
                                    }
                                    if (clazz.isAnnotationPresent(Adaptive.class)) {
                                        if (this.cachedAdaptiveClass == null) {
                                            this.cachedAdaptiveClass = clazz;
                                            continue;
                                        }
                                        if (this.cachedAdaptiveClass.equals(clazz)) continue;
                                        throw new IllegalStateException("More than 1 adaptive class found: " + this.cachedAdaptiveClass.getClass().getName() + ", " + clazz.getClass().getName());
                                    }
                                    try {
                                        clazz.getConstructor(this.type);
                                        Set<Class<?>> wrappers = this.cachedWrapperClasses;
                                        if (wrappers == null) {
                                            this.cachedWrapperClasses = new ConcurrentHashSet();
                                            wrappers = this.cachedWrapperClasses;
                                        }
                                        wrappers.add(clazz);
                                    }
                                    catch (NoSuchMethodException e) {
                                        clazz.getConstructor(new Class[0]);
                                        String[] names = NAME_SEPARATOR.split(name);
                                        if (names == null || names.length <= 0) continue;
                                        Activate activate = clazz.getAnnotation(Activate.class);
                                        if (activate != null) {
                                            this.cachedActivates.put(names[0], activate);
                                        }
                                        for (String n : names) {
                                            Class<?> c;
                                            if (!this.cachedNames.containsKey(clazz)) {
                                                this.cachedNames.put(clazz, n);
                                            }
                                            if ((c = extensionClasses.get(n)) == null) {
                                                extensionClasses.put(n, clazz);
                                                continue;
                                            }
                                            if (c == clazz) continue;
                                            throw new IllegalStateException("Duplicate extension " + this.type.getName() + " name " + n + " on " + c.getName() + " and " + clazz.getName());
                                        }
                                    }
                                }
                                catch (Throwable t) {
                                    IllegalStateException e = new IllegalStateException("Failed to load extension class(interface: " + this.type + ", class line: " + line + ") in " + url + ", cause: " + t.getMessage(), t);
                                    this.exceptions.put(line, e);
                                }
                            }
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (Throwable t) {
                        logger.error((Object)("Exception when load extension class(interface: " + this.type + ", class file: " + url + ") in " + url), t);
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Exception when load extension class(interface: " + this.type + ", description file: " + fileName + ")."), t);
        }
    }

    private T createAdaptiveExtension() {
        try {
            return (T)this.injectExtension(this.getAdaptiveExtensionClass().newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create adaptive extenstion " + this.type + ", cause: " + e.getMessage(), e);
        }
    }

    private Class<?> getAdaptiveExtensionClass() {
        this.getExtensionClasses();
        return this.cachedAdaptiveClass;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.type.getName() + "]";
    }

    public static boolean isNotEmpty(String value) {
        return !ExtensionLoader.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return StringUtils.isBlank((String)value) || "false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value) || "null".equalsIgnoreCase(value) || "N/A".equalsIgnoreCase(value);
    }

    public void addPath(String path) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(path);
    }
}

